/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff;

import com.hazelcast.shaded.org.apache.commons.math3.Field;
import com.hazelcast.shaded.org.apache.commons.math3.RealFieldElement;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FieldODEState;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FieldODEStateAndDerivative;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderFieldDifferentialEquations;
import com.hazelcast.shaded.org.apache.commons.math3.ode.events.Action;
import com.hazelcast.shaded.org.apache.commons.math3.ode.events.FieldEventHandler;
import com.hazelcast.shaded.org.apache.commons.math3.util.MathArrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StepFieldProblem<T extends RealFieldElement<T>>
implements FirstOrderFieldDifferentialEquations<T>,
FieldEventHandler<T> {
    private Field<T> field;
    private T rate;
    private T rateAfter;
    private T switchTime;

    public StepFieldProblem(Field<T> field, T rateBefore, T rateAfter, T switchTime) {
        this.field = field;
        this.rateAfter = rateAfter;
        this.switchTime = switchTime;
        this.setRate(rateBefore);
    }

    public T[] computeDerivatives(T t, T[] y) {
        RealFieldElement[] yDot = (RealFieldElement[])MathArrays.buildArray(this.field, (int)1);
        yDot[0] = this.rate;
        return yDot;
    }

    public int getDimension() {
        return 1;
    }

    public void setRate(T rate) {
        this.rate = rate;
    }

    public void init(T t0, T[] y0, T t) {
    }

    public void init(FieldODEStateAndDerivative<T> state0, T t) {
    }

    public Action eventOccurred(FieldODEStateAndDerivative<T> state, boolean increasing) {
        this.setRate(this.rateAfter);
        return Action.RESET_DERIVATIVES;
    }

    public T g(FieldODEStateAndDerivative<T> state) {
        return (T)((RealFieldElement)state.getTime().subtract(this.switchTime));
    }

    public FieldODEState<T> resetState(FieldODEStateAndDerivative<T> state) {
        return state;
    }
}

