/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff;

import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.ODEIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem1;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem3;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem4;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem5;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblemAbstract;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblemHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.events.EventHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.GraggBulirschStoerIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.StepProblem;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class GraggBulirschStoerIntegratorTest {
    @Test(expected=DimensionMismatchException.class)
    public void testDimensionCheck() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        GraggBulirschStoerIntegrator integrator = new GraggBulirschStoerIntegrator(0.0, 1.0, 1.0E-10, 1.0E-10);
        integrator.integrate((FirstOrderDifferentialEquations)pb, 0.0, new double[pb.getDimension() + 10], 1.0, new double[pb.getDimension() + 10]);
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testNullIntervalCheck() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        GraggBulirschStoerIntegrator integrator = new GraggBulirschStoerIntegrator(0.0, 1.0, 1.0E-10, 1.0E-10);
        integrator.integrate((FirstOrderDifferentialEquations)pb, 0.0, new double[pb.getDimension()], 0.0, new double[pb.getDimension()]);
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testMinStep() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem5 pb = new TestProblem5();
        double minStep = 0.1 * FastMath.abs((double)(pb.getFinalTime() - pb.getInitialTime()));
        double maxStep = FastMath.abs((double)(pb.getFinalTime() - pb.getInitialTime()));
        double[] vecAbsoluteTolerance = new double[]{1.0E-20, 1.0E-21};
        double[] vecRelativeTolerance = new double[]{1.0E-20, 1.0E-21};
        GraggBulirschStoerIntegrator integ = new GraggBulirschStoerIntegrator(minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
    }

    @Test
    public void testBackward() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem5 pb = new TestProblem5();
        double minStep = 0.0;
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double scalAbsoluteTolerance = 1.0E-8;
        double scalRelativeTolerance = 0.01 * scalAbsoluteTolerance;
        GraggBulirschStoerIntegrator integ = new GraggBulirschStoerIntegrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertTrue((handler.getLastError() < 7.5E-9 ? 1 : 0) != 0);
        Assert.assertTrue((handler.getMaximalValueError() < 8.1E-9 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)1.0E-12);
        Assert.assertEquals((Object)"Gragg-Bulirsch-Stoer", (Object)integ.getName());
    }

    @Test
    public void testIncreasingTolerance() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        int previousCalls = Integer.MAX_VALUE;
        for (int i = -12; i < -4; ++i) {
            double absTolerance;
            TestProblem1 pb = new TestProblem1();
            double minStep = 0.0;
            double maxStep = pb.getFinalTime() - pb.getInitialTime();
            double relTolerance = absTolerance = FastMath.pow((double)10.0, (int)i);
            GraggBulirschStoerIntegrator integ = new GraggBulirschStoerIntegrator(minStep, maxStep, absTolerance, relTolerance);
            TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
            integ.addStepHandler((StepHandler)handler);
            integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
            double ratio = handler.getMaximalValueError() / absTolerance;
            Assert.assertTrue((ratio < 2.4 ? 1 : 0) != 0);
            Assert.assertTrue((ratio > 0.02 ? 1 : 0) != 0);
            Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)1.0E-12);
            int calls = pb.getCalls();
            Assert.assertEquals((long)integ.getEvaluations(), (long)calls);
            Assert.assertTrue((calls <= previousCalls ? 1 : 0) != 0);
            previousCalls = calls;
        }
    }

    @Test
    public void testIntegratorControls() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem3 pb = new TestProblem3(0.999);
        GraggBulirschStoerIntegrator integ = new GraggBulirschStoerIntegrator(0.0, pb.getFinalTime() - pb.getInitialTime(), 1.0E-8, 1.0E-10);
        double errorWithDefaultSettings = this.getMaxError((FirstOrderIntegrator)integ, pb);
        integ.setStabilityCheck(true, 2, 1, 0.99);
        Assert.assertTrue((errorWithDefaultSettings < this.getMaxError((FirstOrderIntegrator)integ, pb) ? 1 : 0) != 0);
        integ.setStabilityCheck(true, -1, -1, -1.0);
        integ.setControlFactors(0.5, 0.99, 0.1, 2.5);
        Assert.assertTrue((errorWithDefaultSettings < this.getMaxError((FirstOrderIntegrator)integ, pb) ? 1 : 0) != 0);
        integ.setControlFactors(-1.0, -1.0, -1.0, -1.0);
        integ.setOrderControl(10, 0.7, 0.95);
        Assert.assertTrue((errorWithDefaultSettings < this.getMaxError((FirstOrderIntegrator)integ, pb) ? 1 : 0) != 0);
        integ.setOrderControl(-1, -1.0, -1.0);
        integ.setInterpolationControl(true, 3);
        Assert.assertTrue((errorWithDefaultSettings < this.getMaxError((FirstOrderIntegrator)integ, pb) ? 1 : 0) != 0);
        integ.setInterpolationControl(true, -1);
    }

    private double getMaxError(FirstOrderIntegrator integrator, TestProblemAbstract pb) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integrator);
        integrator.addStepHandler((StepHandler)handler);
        integrator.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        return handler.getMaximalValueError();
    }

    @Test
    public void testEvents() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem4 pb = new TestProblem4();
        double minStep = 0.0;
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double scalAbsoluteTolerance = 1.0E-10;
        double scalRelativeTolerance = 0.01 * scalAbsoluteTolerance;
        GraggBulirschStoerIntegrator integ = new GraggBulirschStoerIntegrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        TestProblemHandler handler = new TestProblemHandler(pb, (ODEIntegrator)integ);
        integ.addStepHandler((StepHandler)handler);
        EventHandler[] functions = pb.getEventsHandlers();
        double convergence = 1.0E-8 * maxStep;
        for (int l = 0; l < functions.length; ++l) {
            integ.addEventHandler(functions[l], Double.POSITIVE_INFINITY, convergence, 1000);
        }
        Assert.assertEquals((long)functions.length, (long)integ.getEventHandlers().size());
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertTrue((handler.getMaximalValueError() < 4.0E-7 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)handler.getMaximalTimeError(), (double)convergence);
        Assert.assertEquals((double)12.0, (double)handler.getLastTime(), (double)convergence);
        integ.clearEventHandlers();
        Assert.assertEquals((long)0L, (long)integ.getEventHandlers().size());
    }

    @Test
    public void testKepler() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem3 pb = new TestProblem3(0.9);
        double minStep = 0.0;
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double absTolerance = 1.0E-6;
        double relTolerance = 1.0E-6;
        GraggBulirschStoerIntegrator integ = new GraggBulirschStoerIntegrator(minStep, maxStep, absTolerance, relTolerance);
        integ.addStepHandler((StepHandler)new KeplerStepHandler(pb));
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertEquals((long)integ.getEvaluations(), (long)pb.getCalls());
        Assert.assertTrue((pb.getCalls() < 2150 ? 1 : 0) != 0);
    }

    @Test
    public void testVariableSteps() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem3 pb = new TestProblem3(0.9);
        double minStep = 0.0;
        double maxStep = pb.getFinalTime() - pb.getInitialTime();
        double absTolerance = 1.0E-8;
        double relTolerance = 1.0E-8;
        GraggBulirschStoerIntegrator integ = new GraggBulirschStoerIntegrator(minStep, maxStep, absTolerance, relTolerance);
        integ.addStepHandler((StepHandler)new VariableStepHandler());
        double stopTime = integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        Assert.assertEquals((double)pb.getFinalTime(), (double)stopTime, (double)1.0E-10);
        Assert.assertEquals((Object)"Gragg-Bulirsch-Stoer", (Object)integ.getName());
    }

    @Test
    public void testTooLargeFirstStep() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        GraggBulirschStoerIntegrator integ = new GraggBulirschStoerIntegrator(0.0, Double.POSITIVE_INFINITY, Double.NaN, Double.NaN);
        double start = 0.0;
        double end = 0.001;
        FirstOrderDifferentialEquations equations = new FirstOrderDifferentialEquations(){

            public int getDimension() {
                return 1;
            }

            public void computeDerivatives(double t, double[] y, double[] yDot) {
                Assert.assertTrue((t >= FastMath.nextAfter((double)0.0, (double)Double.NEGATIVE_INFINITY) ? 1 : 0) != 0);
                Assert.assertTrue((t <= FastMath.nextAfter((double)0.001, (double)Double.POSITIVE_INFINITY) ? 1 : 0) != 0);
                yDot[0] = -100.0 * y[0];
            }
        };
        integ.setStepSizeControl(0.0, 1.0, 1.0E-6, 1.0E-8);
        integ.integrate(equations, 0.0, new double[]{1.0}, 0.001, new double[1]);
    }

    @Test
    public void testUnstableDerivative() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        StepProblem stepProblem = new StepProblem(0.0, 1.0, 2.0);
        GraggBulirschStoerIntegrator integ = new GraggBulirschStoerIntegrator(0.1, 10.0, 1.0E-12, 0.0);
        integ.addEventHandler((EventHandler)stepProblem, 1.0, 1.0E-12, 1000);
        double[] y = new double[]{Double.NaN};
        integ.integrate((FirstOrderDifferentialEquations)stepProblem, 0.0, new double[]{0.0}, 10.0, y);
        Assert.assertEquals((double)8.0, (double)y[0], (double)1.0E-12);
    }

    @Test
    public void testIssue596() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        GraggBulirschStoerIntegrator integ = new GraggBulirschStoerIntegrator(1.0E-10, 100.0, 1.0E-7, 1.0E-7);
        integ.addStepHandler(new StepHandler(){

            public void init(double t0, double[] y0, double t) {
            }

            public void handleStep(StepInterpolator interpolator, boolean isLast) throws MaxCountExceededException {
                double t = interpolator.getCurrentTime();
                interpolator.setInterpolatedTime(t);
                double[] y = interpolator.getInterpolatedState();
                double[] yDot = interpolator.getInterpolatedDerivatives();
                Assert.assertEquals((double)(3.0 * t - 5.0), (double)y[0], (double)1.0E-14);
                Assert.assertEquals((double)3.0, (double)yDot[0], (double)1.0E-14);
            }
        });
        double[] y = new double[]{4.0};
        double t0 = 3.0;
        double tend = 10.0;
        integ.integrate(new FirstOrderDifferentialEquations(){

            public int getDimension() {
                return 1;
            }

            public void computeDerivatives(double t, double[] y, double[] yDot) {
                yDot[0] = 3.0;
            }
        }, t0, y, tend, y);
    }

    public static class VariableStepHandler
    implements StepHandler {
        private boolean firstTime = true;
        private double minStep = 0.0;
        private double maxStep = 0.0;

        public void init(double t0, double[] y0, double t) {
            this.firstTime = true;
            this.minStep = 0.0;
            this.maxStep = 0.0;
        }

        public void handleStep(StepInterpolator interpolator, boolean isLast) {
            double step = FastMath.abs((double)(interpolator.getCurrentTime() - interpolator.getPreviousTime()));
            if (this.firstTime) {
                this.maxStep = this.minStep = FastMath.abs((double)step);
                this.firstTime = false;
            } else {
                if (step < this.minStep) {
                    this.minStep = step;
                }
                if (step > this.maxStep) {
                    this.maxStep = step;
                }
            }
            if (isLast) {
                Assert.assertTrue((this.minStep < 0.0082 ? 1 : 0) != 0);
                Assert.assertTrue((this.maxStep > 1.5 ? 1 : 0) != 0);
            }
        }
    }

    private static class KeplerStepHandler
    implements StepHandler {
        private int nbSteps;
        private double maxError;
        private TestProblem3 pb;

        public KeplerStepHandler(TestProblem3 pb) {
            this.pb = pb;
        }

        public void init(double t0, double[] y0, double t) {
            this.nbSteps = 0;
            this.maxError = 0.0;
        }

        public void handleStep(StepInterpolator interpolator, boolean isLast) throws MaxCountExceededException {
            ++this.nbSteps;
            for (int a = 1; a < 100; ++a) {
                double prev = interpolator.getPreviousTime();
                double curr = interpolator.getCurrentTime();
                double interp = ((double)(100 - a) * prev + (double)a * curr) / 100.0;
                interpolator.setInterpolatedTime(interp);
                double[] interpolatedY = interpolator.getInterpolatedState();
                double[] theoreticalY = this.pb.computeTheoreticalState(interpolator.getInterpolatedTime());
                double dx = interpolatedY[0] - theoreticalY[0];
                double dy = interpolatedY[1] - theoreticalY[1];
                double error = dx * dx + dy * dy;
                if (!(error > this.maxError)) continue;
                this.maxError = error;
            }
            if (isLast) {
                Assert.assertTrue((this.maxError < 2.7E-6 ? 1 : 0) != 0);
                Assert.assertTrue((this.nbSteps < 80 ? 1 : 0) != 0);
            }
        }
    }
}

