/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff;

import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.ode.AbstractIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.ContinuousOutputModel;
import com.hazelcast.shaded.org.apache.commons.math3.ode.EquationsMapper;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem1;
import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblem3;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.EulerIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.EulerStepInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.RungeKuttaIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.RungeKuttaStepInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.sampling.StepInterpolatorTestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class EulerStepInterpolatorTest {
    @Test
    public void noReset() throws MaxCountExceededException {
        double[] y = new double[]{0.0, 1.0, -2.0};
        double[][] yDot = new double[][]{{1.0, 2.0, -2.0}};
        EulerStepInterpolator interpolator = new EulerStepInterpolator();
        interpolator.reinitialize((AbstractIntegrator)new DummyIntegrator((RungeKuttaStepInterpolator)interpolator), y, (double[][])yDot, true, new EquationsMapper(0, y.length), new EquationsMapper[0]);
        interpolator.storeTime(0.0);
        interpolator.shift();
        interpolator.storeTime(1.0);
        double[] result = interpolator.getInterpolatedState();
        for (int i = 0; i < result.length; ++i) {
            Assert.assertTrue((FastMath.abs((double)(result[i] - y[i])) < 1.0E-10 ? 1 : 0) != 0);
        }
    }

    @Test
    public void interpolationAtBounds() throws MaxCountExceededException {
        int i;
        double t0 = 0.0;
        double[] y0 = new double[]{0.0, 1.0, -2.0};
        double[] y = (double[])y0.clone();
        double[][] yDot = new double[][]{new double[y0.length]};
        EulerStepInterpolator interpolator = new EulerStepInterpolator();
        interpolator.reinitialize((AbstractIntegrator)new DummyIntegrator((RungeKuttaStepInterpolator)interpolator), y, (double[][])yDot, true, new EquationsMapper(0, y.length), new EquationsMapper[0]);
        interpolator.storeTime(t0);
        double dt = 1.0;
        interpolator.shift();
        y[0] = 1.0;
        y[1] = 3.0;
        y[2] = -4.0;
        yDot[0][0] = (y[0] - y0[0]) / dt;
        yDot[0][1] = (y[1] - y0[1]) / dt;
        yDot[0][2] = (y[2] - y0[2]) / dt;
        interpolator.storeTime(t0 + dt);
        interpolator.setInterpolatedTime(interpolator.getPreviousTime());
        double[] result = interpolator.getInterpolatedState();
        for (i = 0; i < result.length; ++i) {
            Assert.assertTrue((FastMath.abs((double)(result[i] - y0[i])) < 1.0E-10 ? 1 : 0) != 0);
        }
        interpolator.setInterpolatedTime(interpolator.getCurrentTime());
        result = interpolator.getInterpolatedState();
        for (i = 0; i < result.length; ++i) {
            Assert.assertTrue((FastMath.abs((double)(result[i] - y[i])) < 1.0E-10 ? 1 : 0) != 0);
        }
    }

    @Test
    public void interpolationInside() throws MaxCountExceededException {
        double[] y = new double[]{0.0, 1.0, -2.0};
        double[][] yDot = new double[][]{{1.0, 2.0, -2.0}};
        EulerStepInterpolator interpolator = new EulerStepInterpolator();
        interpolator.reinitialize((AbstractIntegrator)new DummyIntegrator((RungeKuttaStepInterpolator)interpolator), y, (double[][])yDot, true, new EquationsMapper(0, y.length), new EquationsMapper[0]);
        interpolator.storeTime(0.0);
        interpolator.shift();
        y[0] = 1.0;
        y[1] = 3.0;
        y[2] = -4.0;
        interpolator.storeTime(1.0);
        interpolator.setInterpolatedTime(0.1);
        double[] result = interpolator.getInterpolatedState();
        Assert.assertTrue((FastMath.abs((double)(result[0] - 0.1)) < 1.0E-10 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)(result[1] - 1.2)) < 1.0E-10 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)(result[2] + 2.2)) < 1.0E-10 ? 1 : 0) != 0);
        interpolator.setInterpolatedTime(0.5);
        result = interpolator.getInterpolatedState();
        Assert.assertTrue((FastMath.abs((double)(result[0] - 0.5)) < 1.0E-10 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)(result[1] - 2.0)) < 1.0E-10 ? 1 : 0) != 0);
        Assert.assertTrue((FastMath.abs((double)(result[2] + 3.0)) < 1.0E-10 ? 1 : 0) != 0);
    }

    @Test
    public void derivativesConsistency() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem3 pb = new TestProblem3();
        double step = (pb.getFinalTime() - pb.getInitialTime()) * 0.001;
        EulerIntegrator integ = new EulerIntegrator(step);
        StepInterpolatorTestUtils.checkDerivativesConsistency((FirstOrderIntegrator)integ, pb, 0.01, 5.1E-12);
    }

    @Test
    public void serialization() throws IOException, ClassNotFoundException, DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        TestProblem1 pb = new TestProblem1();
        double step = (pb.getFinalTime() - pb.getInitialTime()) * 0.001;
        EulerIntegrator integ = new EulerIntegrator(step);
        integ.addStepHandler((StepHandler)new ContinuousOutputModel());
        integ.integrate((FirstOrderDifferentialEquations)pb, pb.getInitialTime(), pb.getInitialState(), pb.getFinalTime(), new double[pb.getDimension()]);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        for (StepHandler handler : integ.getStepHandlers()) {
            oos.writeObject(handler);
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        ContinuousOutputModel cm = (ContinuousOutputModel)ois.readObject();
        Random random = new Random(347588535632L);
        double maxError = 0.0;
        for (int i = 0; i < 1000; ++i) {
            double r = random.nextDouble();
            double time = r * pb.getInitialTime() + (1.0 - r) * pb.getFinalTime();
            cm.setInterpolatedTime(time);
            double[] interpolatedY = cm.getInterpolatedState();
            double[] theoreticalY = pb.computeTheoreticalState(time);
            double dx = interpolatedY[0] - theoreticalY[0];
            double dy = interpolatedY[1] - theoreticalY[1];
            double error = dx * dx + dy * dy;
            if (!(error > maxError)) continue;
            maxError = error;
        }
        Assert.assertTrue((maxError < 0.001 ? 1 : 0) != 0);
    }

    private static class DummyIntegrator
    extends RungeKuttaIntegrator {
        protected DummyIntegrator(RungeKuttaStepInterpolator prototype) {
            super("dummy", new double[0], new double[0][0], new double[0], prototype, Double.NaN);
        }
    }
}

