/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff;

import com.hazelcast.shaded.org.apache.commons.math3.Field;
import com.hazelcast.shaded.org.apache.commons.math3.RealFieldElement;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.EulerFieldIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.RungeKuttaFieldIntegratorAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.util.Decimal64Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EulerFieldIntegratorTest
extends RungeKuttaFieldIntegratorAbstractTest {
    @Override
    protected <T extends RealFieldElement<T>> RungeKuttaFieldIntegrator<T> createIntegrator(Field<T> field, T step) {
        return new EulerFieldIntegrator(field, step);
    }

    @Override
    public void testNonFieldIntegratorConsistency() {
        this.doTestNonFieldIntegratorConsistency(Decimal64Field.getInstance());
    }

    @Override
    public void testMissedEndEvent() {
        this.doTestMissedEndEvent(Decimal64Field.getInstance(), 1.0E-15, 6.0E-5);
    }

    @Override
    public void testSanityChecks() {
        this.doTestSanityChecks(Decimal64Field.getInstance());
    }

    @Override
    public void testDecreasingSteps() {
        this.doTestDecreasingSteps(Decimal64Field.getInstance(), 1.0, 1.5, 1.0E-10);
    }

    @Override
    public void testSmallStep() {
        this.doTestSmallStep(Decimal64Field.getInstance(), 2.0E-4, 0.001, 1.0E-12, "Euler");
    }

    @Override
    public void testBigStep() {
        this.doTestBigStep(Decimal64Field.getInstance(), 0.01, 0.2, 1.0E-12, "Euler");
    }

    @Override
    public void testBackward() {
        this.doTestBackward(Decimal64Field.getInstance(), 0.45, 0.45, 1.0E-12, "Euler");
    }

    @Override
    public void testKepler() {
        this.doTestKepler(Decimal64Field.getInstance(), 881.176, 0.001);
    }

    @Override
    public void testStepSize() {
        this.doTestStepSize(Decimal64Field.getInstance(), 1.0E-12);
    }

    @Override
    public void testSingleStep() {
        this.doTestSingleStep(Decimal64Field.getInstance(), 0.21);
    }

    @Override
    public void testTooLargeFirstStep() {
        this.doTestTooLargeFirstStep(Decimal64Field.getInstance());
    }

    @Override
    public void testUnstableDerivative() {
        this.doTestUnstableDerivative(Decimal64Field.getInstance(), 1.0E-12);
    }

    @Override
    public void testDerivativesConsistency() {
        this.doTestDerivativesConsistency(Decimal64Field.getInstance(), 1.0E-10);
    }

    @Override
    public void testPartialDerivatives() {
        this.doTestPartialDerivatives(0.085, new double[]{0.47, 0.13, 0.019, 0.019, 0.13});
    }
}

