/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff;

import com.hazelcast.shaded.org.apache.commons.math3.Field;
import com.hazelcast.shaded.org.apache.commons.math3.RealFieldElement;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.DormandPrince853FieldIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.EmbeddedRungeKuttaFieldIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.EmbeddedRungeKuttaFieldIntegratorAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.util.Decimal64Field;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DormandPrince853FieldIntegratorTest
extends EmbeddedRungeKuttaFieldIntegratorAbstractTest {
    @Override
    protected <T extends RealFieldElement<T>> EmbeddedRungeKuttaFieldIntegrator<T> createIntegrator(Field<T> field, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        return new DormandPrince853FieldIntegrator(field, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
    }

    @Override
    protected <T extends RealFieldElement<T>> EmbeddedRungeKuttaFieldIntegrator<T> createIntegrator(Field<T> field, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        return new DormandPrince853FieldIntegrator(field, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
    }

    @Override
    public void testNonFieldIntegratorConsistency() {
        this.doTestNonFieldIntegratorConsistency(Decimal64Field.getInstance());
    }

    @Override
    public void testSanityChecks() {
        this.doTestSanityChecks(Decimal64Field.getInstance());
    }

    @Override
    public void testBackward() {
        this.doTestBackward(Decimal64Field.getInstance(), 8.1E-8, 1.1E-7, 1.0E-12, "Dormand-Prince 8 (5, 3)");
    }

    @Override
    public void testKepler() {
        this.doTestKepler(Decimal64Field.getInstance(), 4.4E-11);
    }

    @Override
    public void testForwardBackwardExceptions() {
        this.doTestForwardBackwardExceptions(Decimal64Field.getInstance());
    }

    @Override
    public void testMinStep() {
        this.doTestMinStep(Decimal64Field.getInstance());
    }

    @Override
    public void testIncreasingTolerance() {
        this.doTestIncreasingTolerance(Decimal64Field.getInstance(), 1.3, 1.0E-12);
    }

    @Override
    public void testEvents() {
        this.doTestEvents(Decimal64Field.getInstance(), 2.1E-7, "Dormand-Prince 8 (5, 3)");
    }

    @Override
    public void testEventsErrors() {
        this.doTestEventsErrors(Decimal64Field.getInstance());
    }

    @Override
    public void testEventsNoConvergence() {
        this.doTestEventsNoConvergence(Decimal64Field.getInstance());
    }

    @Override
    public void testPartialDerivatives() {
        this.doTestPartialDerivatives(2.6E-12, new double[]{1.3E-11, 3.6E-12, 5.2E-13, 3.6E-12, 3.6E-12});
    }
}

