/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode.events;

import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import com.hazelcast.shaded.org.apache.commons.math3.ode.events.EventHandler;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.DormandPrince853Integrator;
import org.junit.Assert;
import org.junit.Test;

public class CloseEventsTest {
    @Test
    public void testCloseEvents() {
        double e = 1.0E-15;
        DormandPrince853Integrator integrator = new DormandPrince853Integrator(e, 100.0, 1.0E-7, 1.0E-7);
        TimeDetector detector1 = new TimeDetector(5.0);
        integrator.addEventHandler((EventHandler)detector1, 10.0, 1.0, 100);
        TimeDetector detector2 = new TimeDetector(5.5);
        integrator.addEventHandler((EventHandler)detector2, 10.0, 1.0, 100);
        integrator.integrate((FirstOrderDifferentialEquations)new Equation(), 0.0, new double[2], 20.0, new double[2]);
        Assert.assertEquals((double)5.0, (double)detector1.getActualT(), (double)0.0);
        Assert.assertEquals((double)5.5, (double)detector2.getActualT(), (double)0.0);
    }

    @Test
    public void testSimultaneousEvents() {
        double e = 1.0E-15;
        DormandPrince853Integrator integrator = new DormandPrince853Integrator(e, 100.0, 1.0E-7, 1.0E-7);
        TimeDetector detector1 = new TimeDetector(5.0);
        integrator.addEventHandler((EventHandler)detector1, 10.0, 1.0, 100);
        TimeDetector detector2 = new TimeDetector(5.0);
        integrator.addEventHandler((EventHandler)detector2, 10.0, 1.0, 100);
        integrator.integrate((FirstOrderDifferentialEquations)new Equation(), 0.0, new double[2], 20.0, new double[2]);
        Assert.assertEquals((double)5.0, (double)detector1.getActualT(), (double)0.0);
        Assert.assertEquals((double)5.0, (double)detector2.getActualT(), (double)0.0);
    }

    public static class Equation
    implements FirstOrderDifferentialEquations {
        public int getDimension() {
            return 2;
        }

        public void computeDerivatives(double t, double[] y, double[] yDot) {
            yDot[0] = 1.0;
            yDot[1] = 2.0;
        }
    }

    private static class TimeDetector
    implements EventHandler {
        private final double eventT;
        private double actualT;

        public TimeDetector(double eventT) {
            this.eventT = eventT;
        }

        public double getActualT() {
            return this.actualT;
        }

        public void init(double t0, double[] y0, double t) {
        }

        public double g(double t, double[] y) {
            return t - this.eventT;
        }

        public EventHandler.Action eventOccurred(double t, double[] y, boolean increasing) {
            this.actualT = t;
            return EventHandler.Action.CONTINUE;
        }

        public void resetState(double t, double[] y) {
        }
    }
}

