/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode;

import com.hazelcast.shaded.org.apache.commons.math3.ode.TestProblemAbstract;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;

public class TestProblem2
extends TestProblemAbstract {
    private double[] y;

    public TestProblem2() {
        double[] y0 = new double[]{0.0};
        this.setInitialConditions(0.0, y0);
        this.setFinalConditions(1.0);
        double[] errorScale = new double[]{1.0};
        this.setErrorScale(errorScale);
        this.y = new double[y0.length];
    }

    public void doComputeDerivatives(double t, double[] y, double[] yDot) {
        for (int i = 0; i < this.getDimension(); ++i) {
            yDot[i] = t * (t * t - y[i]);
        }
    }

    public double[] computeTheoreticalState(double t) {
        double t2 = t * t;
        double c = t2 + 2.0 * (FastMath.exp((double)(-0.5 * t2)) - 1.0);
        for (int i = 0; i < this.getDimension(); ++i) {
            this.y[i] = c;
        }
        return this.y;
    }
}

