/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ode;

import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MaxCountExceededException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoBracketingException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderConverter;
import com.hazelcast.shaded.org.apache.commons.math3.ode.FirstOrderDifferentialEquations;
import com.hazelcast.shaded.org.apache.commons.math3.ode.SecondOrderDifferentialEquations;
import com.hazelcast.shaded.org.apache.commons.math3.ode.nonstiff.ClassicalRungeKuttaIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class FirstOrderConverterTest {
    @Test
    public void testDoubleDimension() {
        for (int i = 1; i < 10; ++i) {
            Equations eqn2 = new Equations(i, 0.2);
            FirstOrderConverter eqn1 = new FirstOrderConverter((SecondOrderDifferentialEquations)eqn2);
            Assert.assertTrue((eqn1.getDimension() == 2 * eqn2.getDimension() ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDecreasingSteps() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double previousError = Double.NaN;
        for (int i = 0; i < 10; ++i) {
            double step = FastMath.pow((double)2.0, (int)(-(i + 1)));
            double error = this.integrateWithSpecifiedStep(4.0, 0.0, 1.0, step) - FastMath.sin((double)4.0);
            if (i > 0) {
                Assert.assertTrue((FastMath.abs((double)error) < FastMath.abs((double)previousError) ? 1 : 0) != 0);
            }
            previousError = error;
        }
    }

    @Test
    public void testSmallStep() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double error = this.integrateWithSpecifiedStep(4.0, 0.0, 1.0, 1.0E-4) - FastMath.sin((double)4.0);
        Assert.assertTrue((FastMath.abs((double)error) < 1.0E-10 ? 1 : 0) != 0);
    }

    @Test
    public void testBigStep() throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double error = this.integrateWithSpecifiedStep(4.0, 0.0, 1.0, 0.5) - FastMath.sin((double)4.0);
        Assert.assertTrue((FastMath.abs((double)error) > 0.1 ? 1 : 0) != 0);
    }

    private double integrateWithSpecifiedStep(double omega, double t0, double t, double step) throws DimensionMismatchException, NumberIsTooSmallException, MaxCountExceededException, NoBracketingException {
        double[] y0 = new double[]{FastMath.sin((double)(omega * t0)), omega * FastMath.cos((double)(omega * t0))};
        ClassicalRungeKuttaIntegrator i = new ClassicalRungeKuttaIntegrator(step);
        double[] y = new double[2];
        i.integrate((FirstOrderDifferentialEquations)new FirstOrderConverter((SecondOrderDifferentialEquations)new Equations(1, omega)), t0, y0, t, y);
        return y[0];
    }

    private static class Equations
    implements SecondOrderDifferentialEquations {
        private int n;
        private double omega2;

        public Equations(int n, double omega) {
            this.n = n;
            this.omega2 = omega * omega;
        }

        public int getDimension() {
            return this.n;
        }

        public void computeSecondDerivatives(double t, double[] y, double[] yDot, double[] yDDot) {
            for (int i = 0; i < this.n; ++i) {
                yDDot[i] = -this.omega2 * y[i];
            }
        }
    }
}

