/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.ml.clustering;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.ml.clustering.Cluster;
import com.hazelcast.shaded.org.apache.commons.math3.ml.clustering.DoublePoint;
import com.hazelcast.shaded.org.apache.commons.math3.ml.clustering.FuzzyKMeansClusterer;
import com.hazelcast.shaded.org.apache.commons.math3.ml.distance.CanberraDistance;
import com.hazelcast.shaded.org.apache.commons.math3.ml.distance.DistanceMeasure;
import com.hazelcast.shaded.org.apache.commons.math3.random.JDKRandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class FuzzyKMeansClustererTest {
    @Test
    public void testCluster() {
        ArrayList<DoublePoint> points = new ArrayList<DoublePoint>();
        for (int i = 1; i <= 10; ++i) {
            DoublePoint p = new DoublePoint(new double[]{i});
            points.add(p);
        }
        FuzzyKMeansClusterer transformer = new FuzzyKMeansClusterer(3, 2.0);
        List clusters = transformer.cluster(points);
        List<DoublePoint> clusterOne = Arrays.asList((DoublePoint)points.get(0), (DoublePoint)points.get(1), (DoublePoint)points.get(2));
        List<DoublePoint> clusterTwo = Arrays.asList((DoublePoint)points.get(3), (DoublePoint)points.get(4), (DoublePoint)points.get(5), (DoublePoint)points.get(6));
        List<DoublePoint> clusterThree = Arrays.asList((DoublePoint)points.get(7), (DoublePoint)points.get(8), (DoublePoint)points.get(9));
        boolean cluster1Found = false;
        boolean cluster2Found = false;
        boolean cluster3Found = false;
        Assert.assertEquals((long)3L, (long)clusters.size());
        for (Cluster cluster : clusters) {
            if (cluster.getPoints().containsAll(clusterOne)) {
                cluster1Found = true;
            }
            if (cluster.getPoints().containsAll(clusterTwo)) {
                cluster2Found = true;
            }
            if (!cluster.getPoints().containsAll(clusterThree)) continue;
            cluster3Found = true;
        }
        Assert.assertTrue((boolean)cluster1Found);
        Assert.assertTrue((boolean)cluster2Found);
        Assert.assertTrue((boolean)cluster3Found);
    }

    @Test(expected=MathIllegalArgumentException.class)
    public void testTooSmallFuzzynessFactor() {
        new FuzzyKMeansClusterer(3, 1.0);
    }

    @Test(expected=NullArgumentException.class)
    public void testNullDataset() {
        FuzzyKMeansClusterer clusterer = new FuzzyKMeansClusterer(3, 2.0);
        clusterer.cluster(null);
    }

    @Test
    public void testGetters() {
        CanberraDistance measure = new CanberraDistance();
        JDKRandomGenerator random = new JDKRandomGenerator();
        FuzzyKMeansClusterer clusterer = new FuzzyKMeansClusterer(3, 2.0, 100, (DistanceMeasure)measure, 1.0E-6, (RandomGenerator)random);
        Assert.assertEquals((long)3L, (long)clusterer.getK());
        Assert.assertEquals((double)2.0, (double)clusterer.getFuzziness(), (double)1.0E-6);
        Assert.assertEquals((long)100L, (long)clusterer.getMaxIterations());
        Assert.assertEquals((double)1.0E-6, (double)clusterer.getEpsilon(), (double)1.0E-12);
        Assert.assertThat((Object)clusterer.getDistanceMeasure(), (Matcher)CoreMatchers.is((Object)measure));
        Assert.assertThat((Object)clusterer.getRandomGenerator(), (Matcher)CoreMatchers.is((Object)random));
    }

    @Test
    public void testSingleCluster() {
        ArrayList<DoublePoint> points = new ArrayList<DoublePoint>();
        points.add(new DoublePoint(new double[]{1.0, 1.0}));
        FuzzyKMeansClusterer transformer = new FuzzyKMeansClusterer(1, 2.0);
        List clusters = transformer.cluster(points);
        Assert.assertEquals((long)1L, (long)clusters.size());
    }

    @Test
    public void testClusterCenterEqualsPoints() {
        ArrayList<DoublePoint> points = new ArrayList<DoublePoint>();
        points.add(new DoublePoint(new double[]{1.0, 1.0}));
        points.add(new DoublePoint(new double[]{1.00001, 1.00001}));
        points.add(new DoublePoint(new double[]{2.0, 2.0}));
        points.add(new DoublePoint(new double[]{3.0, 3.0}));
        FuzzyKMeansClusterer transformer = new FuzzyKMeansClusterer(3, 2.0);
        List clusters = transformer.cluster(points);
        Assert.assertEquals((long)3L, (long)clusters.size());
    }
}

