/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.Array2DRowRealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.ArrayRealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.DecompositionSolver;
import com.hazelcast.shaded.org.apache.commons.math3.linear.HilbertMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.InverseHilbertMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.IterativeLinearSolverEvent;
import com.hazelcast.shaded.org.apache.commons.math3.linear.JacobiPreconditioner;
import com.hazelcast.shaded.org.apache.commons.math3.linear.LUDecomposition;
import com.hazelcast.shaded.org.apache.commons.math3.linear.NonPositiveDefiniteOperatorException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.NonSelfAdjointOperatorException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.NonSquareOperatorException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealLinearOperator;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.SymmLQ;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.IterationEvent;
import com.hazelcast.shaded.org.apache.commons.math3.util.IterationListener;
import java.util.Arrays;
import org.junit.Assert;
import org.junit.Test;

public class SymmLQTest {
    public void saundersTest(final int n, boolean goodb, boolean precon, double shift, double pertbn) {
        RealLinearOperator a = new RealLinearOperator(){

            public RealVector operate(RealVector x) {
                if (x.getDimension() != n) {
                    throw new DimensionMismatchException(x.getDimension(), n);
                }
                double[] y = new double[n];
                for (int i = 0; i < n; ++i) {
                    y[i] = (double)(i + 1) * 1.1 / (double)n * x.getEntry(i);
                }
                return new ArrayRealVector(y, false);
            }

            public int getRowDimension() {
                return n;
            }

            public int getColumnDimension() {
                return n;
            }
        };
        final double shiftm = shift;
        final double pertm = FastMath.abs((double)pertbn);
        RealLinearOperator minv = precon ? new RealLinearOperator(){

            public int getRowDimension() {
                return n;
            }

            public int getColumnDimension() {
                return n;
            }

            public RealVector operate(RealVector x) {
                if (x.getDimension() != n) {
                    throw new DimensionMismatchException(x.getDimension(), n);
                }
                double[] y = new double[n];
                for (int i = 0; i < n; ++i) {
                    double d = (double)(i + 1) * 1.1 / (double)n;
                    d = FastMath.abs((double)(d - shiftm));
                    if (i % 10 == 0) {
                        d += pertm;
                    }
                    y[i] = x.getEntry(i) / d;
                }
                return new ArrayRealVector(y, false);
            }
        } : null;
        ArrayRealVector xtrue = new ArrayRealVector(n);
        for (int i = 0; i < n; ++i) {
            xtrue.setEntry(i, (double)(n - i));
        }
        RealVector b = a.operate((RealVector)xtrue);
        b.combineToSelf(1.0, -shift, (RealVector)xtrue);
        SymmLQ solver = new SymmLQ(2 * n, 1.0E-12, true);
        RealVector x = solver.solve(a, minv, b, goodb, shift);
        RealVector y = a.operate(x);
        ArrayRealVector r1 = new ArrayRealVector(n);
        for (int i = 0; i < n; ++i) {
            double bi = b.getEntry(i);
            double yi = y.getEntry(i);
            double xi = x.getEntry(i);
            r1.setEntry(i, bi - yi + shift * xi);
        }
        double enorm = x.subtract((RealVector)xtrue).getNorm() / xtrue.getNorm();
        double etol = 1.0E-5;
        Assert.assertTrue((String)("enorm=" + enorm + ", " + solver.getIterationManager().getIterations()), (enorm <= 1.0E-5 ? 1 : 0) != 0);
    }

    @Test
    public void testSolveSaunders1() {
        this.saundersTest(1, false, false, 0.0, 0.0);
    }

    @Test
    public void testSolveSaunders2() {
        this.saundersTest(2, false, false, 0.0, 0.0);
    }

    @Test
    public void testSolveSaunders3() {
        this.saundersTest(1, false, true, 0.0, 0.0);
    }

    @Test
    public void testSolveSaunders4() {
        this.saundersTest(2, false, true, 0.0, 0.0);
    }

    @Test
    public void testSolveSaunders5() {
        this.saundersTest(5, false, true, 0.0, 0.0);
    }

    @Test
    public void testSolveSaunders6() {
        this.saundersTest(5, false, true, 0.25, 0.0);
    }

    @Test
    public void testSolveSaunders7() {
        this.saundersTest(50, false, false, 0.0, 0.0);
    }

    @Test
    public void testSolveSaunders8() {
        this.saundersTest(50, false, false, 0.25, 0.0);
    }

    @Test
    public void testSolveSaunders9() {
        this.saundersTest(50, false, true, 0.0, 0.1);
    }

    @Test
    public void testSolveSaunders10() {
        this.saundersTest(50, false, true, 0.25, 0.1);
    }

    @Test
    public void testSolveSaunders11() {
        this.saundersTest(1, true, false, 0.0, 0.0);
    }

    @Test
    public void testSolveSaunders12() {
        this.saundersTest(2, true, false, 0.0, 0.0);
    }

    @Test
    public void testSolveSaunders13() {
        this.saundersTest(1, true, true, 0.0, 0.0);
    }

    @Test
    public void testSolveSaunders14() {
        this.saundersTest(2, true, true, 0.0, 0.0);
    }

    @Test
    public void testSolveSaunders15() {
        this.saundersTest(5, true, true, 0.0, 0.0);
    }

    @Test
    public void testSolveSaunders16() {
        this.saundersTest(5, true, true, 0.25, 0.0);
    }

    @Test
    public void testSolveSaunders17() {
        this.saundersTest(50, true, false, 0.0, 0.0);
    }

    @Test
    public void testSolveSaunders18() {
        this.saundersTest(50, true, false, 0.25, 0.0);
    }

    @Test
    public void testSolveSaunders19() {
        this.saundersTest(50, true, true, 0.0, 0.1);
    }

    @Test
    public void testSolveSaunders20() {
        this.saundersTest(50, true, true, 0.25, 0.1);
    }

    @Test(expected=NonSquareOperatorException.class)
    public void testNonSquareOperator() {
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(2, 3);
        SymmLQ solver = new SymmLQ(10, 0.0, false);
        ArrayRealVector b = new ArrayRealVector(a.getRowDimension());
        ArrayRealVector x = new ArrayRealVector(a.getColumnDimension());
        solver.solve((RealLinearOperator)a, (RealVector)b, (RealVector)x);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testDimensionMismatchRightHandSide() {
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(3, 3);
        SymmLQ solver = new SymmLQ(10, 0.0, false);
        ArrayRealVector b = new ArrayRealVector(2);
        solver.solve((RealLinearOperator)a, (RealVector)b);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testDimensionMismatchSolution() {
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(3, 3);
        SymmLQ solver = new SymmLQ(10, 0.0, false);
        ArrayRealVector b = new ArrayRealVector(3);
        ArrayRealVector x = new ArrayRealVector(2);
        solver.solve((RealLinearOperator)a, (RealVector)b, (RealVector)x);
    }

    @Test
    public void testUnpreconditionedSolution() {
        int n = 5;
        int maxIterations = 100;
        HilbertMatrix a = new HilbertMatrix(5);
        InverseHilbertMatrix ainv = new InverseHilbertMatrix(5);
        SymmLQ solver = new SymmLQ(100, 1.0E-10, true);
        ArrayRealVector b = new ArrayRealVector(5);
        for (int j = 0; j < 5; ++j) {
            b.set(0.0);
            b.setEntry(j, 1.0);
            RealVector x = solver.solve((RealLinearOperator)a, (RealVector)b);
            for (int i = 0; i < 5; ++i) {
                double actual = x.getEntry(i);
                double expected = ainv.getEntry(i, j);
                double delta = 1.0E-6 * FastMath.abs((double)expected);
                String msg = String.format("entry[%d][%d]", i, j);
                Assert.assertEquals((String)msg, (double)expected, (double)actual, (double)delta);
            }
        }
    }

    @Test
    public void testUnpreconditionedInPlaceSolutionWithInitialGuess() {
        int n = 5;
        int maxIterations = 100;
        HilbertMatrix a = new HilbertMatrix(5);
        InverseHilbertMatrix ainv = new InverseHilbertMatrix(5);
        SymmLQ solver = new SymmLQ(100, 1.0E-10, true);
        ArrayRealVector b = new ArrayRealVector(5);
        for (int j = 0; j < 5; ++j) {
            b.set(0.0);
            b.setEntry(j, 1.0);
            ArrayRealVector x0 = new ArrayRealVector(5);
            x0.set(1.0);
            RealVector x = solver.solveInPlace((RealLinearOperator)a, (RealVector)b, (RealVector)x0);
            Assert.assertSame((String)"x should be a reference to x0", (Object)x0, (Object)x);
            for (int i = 0; i < 5; ++i) {
                double actual = x.getEntry(i);
                double expected = ainv.getEntry(i, j);
                double delta = 1.0E-6 * FastMath.abs((double)expected);
                String msg = String.format("entry[%d][%d)", i, j);
                Assert.assertEquals((String)msg, (double)expected, (double)actual, (double)delta);
            }
        }
    }

    @Test
    public void testUnpreconditionedSolutionWithInitialGuess() {
        int n = 5;
        int maxIterations = 100;
        HilbertMatrix a = new HilbertMatrix(5);
        InverseHilbertMatrix ainv = new InverseHilbertMatrix(5);
        SymmLQ solver = new SymmLQ(100, 1.0E-10, true);
        ArrayRealVector b = new ArrayRealVector(5);
        for (int j = 0; j < 5; ++j) {
            b.set(0.0);
            b.setEntry(j, 1.0);
            ArrayRealVector x0 = new ArrayRealVector(5);
            x0.set(1.0);
            RealVector x = solver.solve((RealLinearOperator)a, (RealVector)b, (RealVector)x0);
            Assert.assertNotSame((String)"x should not be a reference to x0", (Object)x0, (Object)x);
            for (int i = 0; i < 5; ++i) {
                double actual = x.getEntry(i);
                double expected = ainv.getEntry(i, j);
                double delta = 1.0E-6 * FastMath.abs((double)expected);
                String msg = String.format("entry[%d][%d]", i, j);
                Assert.assertEquals((String)msg, (double)expected, (double)actual, (double)delta);
                Assert.assertEquals((String)msg, (double)x0.getEntry(i), (double)1.0, (double)Math.ulp(1.0));
            }
        }
    }

    @Test(expected=NonSquareOperatorException.class)
    public void testNonSquarePreconditioner() {
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(2, 2);
        RealLinearOperator m = new RealLinearOperator(){

            public RealVector operate(RealVector x) {
                throw new UnsupportedOperationException();
            }

            public int getRowDimension() {
                return 2;
            }

            public int getColumnDimension() {
                return 3;
            }
        };
        SymmLQ solver = new SymmLQ(10, 0.0, false);
        ArrayRealVector b = new ArrayRealVector(a.getRowDimension());
        solver.solve((RealLinearOperator)a, m, (RealVector)b);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testMismatchedOperatorDimensions() {
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(2, 2);
        RealLinearOperator m = new RealLinearOperator(){

            public RealVector operate(RealVector x) {
                throw new UnsupportedOperationException();
            }

            public int getRowDimension() {
                return 3;
            }

            public int getColumnDimension() {
                return 3;
            }
        };
        SymmLQ solver = new SymmLQ(10, 0.0, false);
        ArrayRealVector b = new ArrayRealVector(a.getRowDimension());
        solver.solve((RealLinearOperator)a, m, (RealVector)b);
    }

    @Test(expected=NonPositiveDefiniteOperatorException.class)
    public void testNonPositiveDefinitePreconditioner() {
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(2, 2);
        a.setEntry(0, 0, 1.0);
        a.setEntry(0, 1, 2.0);
        a.setEntry(1, 0, 3.0);
        a.setEntry(1, 1, 4.0);
        RealLinearOperator m = new RealLinearOperator(){

            public RealVector operate(RealVector x) {
                ArrayRealVector y = new ArrayRealVector(2);
                y.setEntry(0, -x.getEntry(0));
                y.setEntry(1, -x.getEntry(1));
                return y;
            }

            public int getRowDimension() {
                return 2;
            }

            public int getColumnDimension() {
                return 2;
            }
        };
        SymmLQ solver = new SymmLQ(10, 0.0, true);
        ArrayRealVector b = new ArrayRealVector(2);
        b.setEntry(0, -1.0);
        b.setEntry(1, -1.0);
        solver.solve((RealLinearOperator)a, m, (RealVector)b);
    }

    @Test
    public void testPreconditionedSolution() {
        int n = 8;
        int maxIterations = 100;
        HilbertMatrix a = new HilbertMatrix(8);
        InverseHilbertMatrix ainv = new InverseHilbertMatrix(8);
        JacobiPreconditioner m = JacobiPreconditioner.create((RealLinearOperator)a);
        SymmLQ solver = new SymmLQ(100, 1.0E-15, true);
        ArrayRealVector b = new ArrayRealVector(8);
        for (int j = 0; j < 8; ++j) {
            b.set(0.0);
            b.setEntry(j, 1.0);
            RealVector x = solver.solve((RealLinearOperator)a, (RealLinearOperator)m, (RealVector)b);
            for (int i = 0; i < 8; ++i) {
                double actual = x.getEntry(i);
                double expected = ainv.getEntry(i, j);
                double delta = 1.0E-6 * FastMath.abs((double)expected);
                String msg = String.format("coefficient (%d, %d)", i, j);
                Assert.assertEquals((String)msg, (double)expected, (double)actual, (double)delta);
            }
        }
    }

    @Test
    public void testPreconditionedSolution2() {
        int n = 100;
        int maxIterations = 100000;
        Array2DRowRealMatrix a = new Array2DRowRealMatrix(100, 100);
        double daux = 1.0;
        for (int i = 0; i < 100; ++i) {
            a.setEntry(i, i, daux);
            daux *= 1.2;
            for (int j = i + 1; j < 100; ++j) {
                if (i == j) continue;
                double value = 1.0;
                a.setEntry(i, j, 1.0);
                a.setEntry(j, i, 1.0);
            }
        }
        JacobiPreconditioner m = JacobiPreconditioner.create((RealLinearOperator)a);
        SymmLQ prec = new SymmLQ(100000, 1.0E-15, true);
        SymmLQ unprec = new SymmLQ(100000, 1.0E-15, true);
        ArrayRealVector b = new ArrayRealVector(100);
        String pattern = "preconditioned SymmLQ (%d iterations) should have been faster than unpreconditioned (%d iterations)";
        for (int j = 0; j < 1; ++j) {
            b.set(0.0);
            b.setEntry(j, 1.0);
            RealVector px = prec.solve((RealLinearOperator)a, (RealLinearOperator)m, (RealVector)b);
            RealVector x = unprec.solve((RealLinearOperator)a, (RealVector)b);
            int np = prec.getIterationManager().getIterations();
            int nup = unprec.getIterationManager().getIterations();
            String msg = String.format("preconditioned SymmLQ (%d iterations) should have been faster than unpreconditioned (%d iterations)", np, nup);
            for (int i = 0; i < 100; ++i) {
                msg = String.format("row %d, column %d", i, j);
                double expected = x.getEntry(i);
                double actual = px.getEntry(i);
                double delta = 5.0E-5 * FastMath.abs((double)expected);
                Assert.assertEquals((String)msg, (double)expected, (double)actual, (double)delta);
            }
        }
    }

    @Test
    public void testEventManagement() {
        int n = 5;
        int maxIterations = 100;
        HilbertMatrix a = new HilbertMatrix(5);
        final int[] count = new int[]{0, 0, 0, 0};
        ArrayRealVector xFromListener = new ArrayRealVector(5);
        IterationListener listener = new IterationListener((RealVector)xFromListener){
            final /* synthetic */ RealVector val$xFromListener;
            {
                this.val$xFromListener = realVector;
            }

            public void initializationPerformed(IterationEvent e) {
                count[0] = count[0] + 1;
            }

            public void iterationPerformed(IterationEvent e) {
                count[2] = count[2] + 1;
                Assert.assertEquals((String)"iteration performed", (long)count[2], (long)(e.getIterations() - 1));
            }

            public void iterationStarted(IterationEvent e) {
                count[1] = count[1] + 1;
                Assert.assertEquals((String)"iteration started", (long)count[1], (long)(e.getIterations() - 1));
            }

            public void terminationPerformed(IterationEvent e) {
                count[3] = count[3] + 1;
                IterativeLinearSolverEvent ilse = (IterativeLinearSolverEvent)e;
                this.val$xFromListener.setSubVector(0, ilse.getSolution());
            }
        };
        SymmLQ solver = new SymmLQ(100, 1.0E-10, true);
        solver.getIterationManager().addIterationListener(listener);
        ArrayRealVector b = new ArrayRealVector(5);
        for (int j = 0; j < 5; ++j) {
            Arrays.fill(count, 0);
            b.set(0.0);
            b.setEntry(j, 1.0);
            RealVector xFromSolver = solver.solve((RealLinearOperator)a, (RealVector)b);
            String msg = String.format("column %d (initialization)", j);
            Assert.assertEquals((String)msg, (long)1L, (long)count[0]);
            msg = String.format("column %d (finalization)", j);
            Assert.assertEquals((String)msg, (long)1L, (long)count[3]);
            for (int i = 0; i < 5; ++i) {
                msg = String.format("row %d, column %d", i, j);
                double expected = xFromSolver.getEntry(i);
                double actual = xFromListener.getEntry(i);
                Assert.assertEquals((String)msg, (double)expected, (double)actual, (double)0.0);
            }
        }
    }

    @Test(expected=NonSelfAdjointOperatorException.class)
    public void testNonSelfAdjointOperator() {
        Array2DRowRealMatrix a = new Array2DRowRealMatrix((double[][])new double[][]{{1.0, 2.0, 3.0}, {2.0, 4.0, 5.0}, {2.999, 5.0, 6.0}});
        ArrayRealVector b = new ArrayRealVector(new double[]{1.0, 1.0, 1.0});
        new SymmLQ(100, 1.0, true).solve((RealLinearOperator)a, (RealVector)b);
    }

    @Test(expected=NonSelfAdjointOperatorException.class)
    public void testNonSelfAdjointPreconditioner() {
        Array2DRowRealMatrix a = new Array2DRowRealMatrix((double[][])new double[][]{{1.0, 2.0, 3.0}, {2.0, 4.0, 5.0}, {3.0, 5.0, 6.0}});
        final Array2DRowRealMatrix mMat = new Array2DRowRealMatrix((double[][])new double[][]{{1.0, 0.0, 1.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}});
        final DecompositionSolver mSolver = new LUDecomposition((RealMatrix)mMat).getSolver();
        RealLinearOperator minv = new RealLinearOperator(){

            public RealVector operate(RealVector x) {
                return mSolver.solve(x);
            }

            public int getRowDimension() {
                return mMat.getRowDimension();
            }

            public int getColumnDimension() {
                return mMat.getColumnDimension();
            }
        };
        ArrayRealVector b = new ArrayRealVector(new double[]{1.0, 1.0, 1.0});
        new SymmLQ(100, 1.0, true).solve((RealLinearOperator)a, minv, (RealVector)b);
    }

    @Test
    public void testUnpreconditionedNormOfResidual() {
        int n = 5;
        int maxIterations = 100;
        final HilbertMatrix a = new HilbertMatrix(5);
        IterationListener listener = new IterationListener(){

            private void doTestNormOfResidual(IterationEvent e) {
                IterativeLinearSolverEvent evt = (IterativeLinearSolverEvent)e;
                RealVector x = evt.getSolution();
                RealVector b = evt.getRightHandSideVector();
                RealVector r = b.subtract(a.operate(x));
                double rnorm = r.getNorm();
                Assert.assertEquals((String)"iteration performed (residual)", (double)rnorm, (double)evt.getNormOfResidual(), (double)FastMath.max((double)(1.0E-5 * rnorm), (double)1.0E-10));
            }

            public void initializationPerformed(IterationEvent e) {
                this.doTestNormOfResidual(e);
            }

            public void iterationPerformed(IterationEvent e) {
                this.doTestNormOfResidual(e);
            }

            public void iterationStarted(IterationEvent e) {
                this.doTestNormOfResidual(e);
            }

            public void terminationPerformed(IterationEvent e) {
                this.doTestNormOfResidual(e);
            }
        };
        SymmLQ solver = new SymmLQ(100, 1.0E-10, true);
        solver.getIterationManager().addIterationListener(listener);
        ArrayRealVector b = new ArrayRealVector(5);
        for (int j = 0; j < 5; ++j) {
            b.set(0.0);
            b.setEntry(j, 1.0);
            solver.solve((RealLinearOperator)a, (RealVector)b);
        }
    }

    @Test
    public void testPreconditionedNormOfResidual() {
        int n = 5;
        int maxIterations = 100;
        final HilbertMatrix a = new HilbertMatrix(5);
        JacobiPreconditioner m = JacobiPreconditioner.create((RealLinearOperator)a);
        final RealLinearOperator p = m.sqrt();
        IterationListener listener = new IterationListener(){

            private void doTestNormOfResidual(IterationEvent e) {
                IterativeLinearSolverEvent evt = (IterativeLinearSolverEvent)e;
                RealVector x = evt.getSolution();
                RealVector b = evt.getRightHandSideVector();
                RealVector r = b.subtract(a.operate(x));
                double rnorm = p.operate(r).getNorm();
                Assert.assertEquals((String)"iteration performed (residual)", (double)rnorm, (double)evt.getNormOfResidual(), (double)FastMath.max((double)(1.0E-5 * rnorm), (double)1.0E-10));
            }

            public void initializationPerformed(IterationEvent e) {
                this.doTestNormOfResidual(e);
            }

            public void iterationPerformed(IterationEvent e) {
                this.doTestNormOfResidual(e);
            }

            public void iterationStarted(IterationEvent e) {
                this.doTestNormOfResidual(e);
            }

            public void terminationPerformed(IterationEvent e) {
                this.doTestNormOfResidual(e);
            }
        };
        SymmLQ solver = new SymmLQ(100, 1.0E-10, true);
        solver.getIterationManager().addIterationListener(listener);
        ArrayRealVector b = new ArrayRealVector(5);
        for (int j = 0; j < 5; ++j) {
            b.set(0.0);
            b.setEntry(j, 1.0);
            solver.solve((RealLinearOperator)a, (RealLinearOperator)m, (RealVector)b);
        }
    }
}

