/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoDataException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.ArrayRealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.BlockRealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.LUDecomposition;
import com.hazelcast.shaded.org.apache.commons.math3.linear.NonSquareMatrixException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.OpenMapRealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import org.junit.Assert;
import org.junit.Test;

public final class SparseRealMatrixTest {
    protected double[][] id = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    protected double[][] testData = new double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 3.0}, {1.0, 0.0, 8.0}};
    protected double[][] testDataLU = new double[][]{{2.0, 5.0, 3.0}, {0.5, -2.5, 6.5}, {0.5, 0.2, 0.2}};
    protected double[][] testDataPlus2 = new double[][]{{3.0, 4.0, 5.0}, {4.0, 7.0, 5.0}, {3.0, 2.0, 10.0}};
    protected double[][] testDataMinus = new double[][]{{-1.0, -2.0, -3.0}, {-2.0, -5.0, -3.0}, {-1.0, 0.0, -8.0}};
    protected double[] testDataRow1 = new double[]{1.0, 2.0, 3.0};
    protected double[] testDataCol3 = new double[]{3.0, 3.0, 8.0};
    protected double[][] testDataInv = new double[][]{{-40.0, 16.0, 9.0}, {13.0, -5.0, -3.0}, {5.0, -2.0, -1.0}};
    protected double[] preMultTest = new double[]{8.0, 12.0, 33.0};
    protected double[][] testData2 = new double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 3.0}};
    protected double[][] testData2T = new double[][]{{1.0, 2.0}, {2.0, 5.0}, {3.0, 3.0}};
    protected double[][] testDataPlusInv = new double[][]{{-39.0, 18.0, 12.0}, {15.0, 0.0, 0.0}, {6.0, -2.0, 7.0}};
    protected double[][] luData = new double[][]{{2.0, 3.0, 3.0}, {0.0, 5.0, 7.0}, {6.0, 9.0, 8.0}};
    protected double[][] luDataLUDecomposition = new double[][]{{6.0, 9.0, 8.0}, {0.0, 5.0, 7.0}, {0.33333333333333, 0.0, 0.33333333333333}};
    protected double[][] singular = new double[][]{{2.0, 3.0}, {2.0, 3.0}};
    protected double[][] bigSingular = new double[][]{{1.0, 2.0, 3.0, 4.0}, {2.0, 5.0, 3.0, 4.0}, {7.0, 3.0, 256.0, 1930.0}, {3.0, 7.0, 6.0, 8.0}};
    protected double[][] detData = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 10.0}};
    protected double[][] detData2 = new double[][]{{1.0, 3.0}, {2.0, 4.0}};
    protected double[] testVector = new double[]{1.0, 2.0, 3.0};
    protected double[] testVector2 = new double[]{1.0, 2.0, 3.0, 4.0};
    protected double[][] subTestData = new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.5, 2.5, 3.5, 4.5}, {2.0, 4.0, 6.0, 8.0}, {4.0, 5.0, 6.0, 7.0}};
    protected double[][] subRows02Cols13 = new double[][]{{2.0, 4.0}, {4.0, 8.0}};
    protected double[][] subRows03Cols12 = new double[][]{{2.0, 3.0}, {5.0, 6.0}};
    protected double[][] subRows03Cols123 = new double[][]{{2.0, 3.0, 4.0}, {5.0, 6.0, 7.0}};
    protected double[][] subRows20Cols123 = new double[][]{{4.0, 6.0, 8.0}, {2.0, 3.0, 4.0}};
    protected double[][] subRows31Cols31 = new double[][]{{7.0, 5.0}, {4.5, 2.5}};
    protected double[][] subRows01Cols23 = new double[][]{{3.0, 4.0}, {3.5, 4.5}};
    protected double[][] subRows23Cols00 = new double[][]{{2.0}, {4.0}};
    protected double[][] subRows00Cols33 = new double[][]{{4.0}};
    protected double[][] subRow0 = new double[][]{{1.0, 2.0, 3.0, 4.0}};
    protected double[][] subRow3 = new double[][]{{4.0, 5.0, 6.0, 7.0}};
    protected double[][] subColumn1 = new double[][]{{2.0}, {2.5}, {4.0}, {5.0}};
    protected double[][] subColumn3 = new double[][]{{4.0}, {4.5}, {8.0}, {7.0}};
    protected double entryTolerance = 1.0E-15;
    protected double normTolerance = 1.0E-13;
    private double[][] d3 = new double[][]{{1.0, 2.0, 3.0, 4.0}, {5.0, 6.0, 7.0, 8.0}};
    private double[][] d4 = new double[][]{{1.0}, {2.0}, {3.0}, {4.0}};
    private double[][] d5 = new double[][]{{30.0}, {70.0}};

    @Test
    public void testDimensions() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.testData);
        OpenMapRealMatrix m2 = this.createSparseMatrix(this.testData2);
        Assert.assertEquals((String)"testData row dimension", (long)3L, (long)m.getRowDimension());
        Assert.assertEquals((String)"testData column dimension", (long)3L, (long)m.getColumnDimension());
        Assert.assertTrue((String)"testData is square", (boolean)m.isSquare());
        Assert.assertEquals((String)"testData2 row dimension", (long)m2.getRowDimension(), (long)2L);
        Assert.assertEquals((String)"testData2 column dimension", (long)m2.getColumnDimension(), (long)3L);
        Assert.assertTrue((String)"testData2 is not square", (!m2.isSquare() ? 1 : 0) != 0);
    }

    @Test
    public void testCopyFunctions() {
        OpenMapRealMatrix m1 = this.createSparseMatrix(this.testData);
        OpenMapRealMatrix m2 = m1.copy();
        Assert.assertEquals(m1.getClass(), m2.getClass());
        Assert.assertEquals((Object)m2, (Object)m1);
        OpenMapRealMatrix m3 = this.createSparseMatrix(this.testData);
        OpenMapRealMatrix m4 = m3.copy();
        Assert.assertEquals(m3.getClass(), m4.getClass());
        Assert.assertEquals((Object)m4, (Object)m3);
    }

    @Test
    public void testAdd() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.testData);
        OpenMapRealMatrix mInv = this.createSparseMatrix(this.testDataInv);
        OpenMapRealMatrix mDataPlusInv = this.createSparseMatrix(this.testDataPlusInv);
        OpenMapRealMatrix mPlusMInv = m.add(mInv);
        for (int row = 0; row < m.getRowDimension(); ++row) {
            for (int col = 0; col < m.getColumnDimension(); ++col) {
                Assert.assertEquals((String)"sum entry entry", (double)mDataPlusInv.getEntry(row, col), (double)mPlusMInv.getEntry(row, col), (double)this.entryTolerance);
            }
        }
    }

    @Test
    public void testAddFail() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.testData);
        OpenMapRealMatrix m2 = this.createSparseMatrix(this.testData2);
        try {
            m.add(m2);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNorm() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.testData);
        OpenMapRealMatrix m2 = this.createSparseMatrix(this.testData2);
        Assert.assertEquals((String)"testData norm", (double)14.0, (double)m.getNorm(), (double)this.entryTolerance);
        Assert.assertEquals((String)"testData2 norm", (double)7.0, (double)m2.getNorm(), (double)this.entryTolerance);
    }

    @Test
    public void testPlusMinus() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.testData);
        OpenMapRealMatrix n = this.createSparseMatrix(this.testDataInv);
        this.assertClose("m-n = m + -n", (RealMatrix)m.subtract(n), n.scalarMultiply(-1.0).add((RealMatrix)m), this.entryTolerance);
        try {
            m.subtract(this.createSparseMatrix(this.testData2));
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMultiply() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.testData);
        OpenMapRealMatrix mInv = this.createSparseMatrix(this.testDataInv);
        OpenMapRealMatrix identity = this.createSparseMatrix(this.id);
        OpenMapRealMatrix m2 = this.createSparseMatrix(this.testData2);
        this.assertClose("inverse multiply", (RealMatrix)m.multiply(mInv), (RealMatrix)identity, this.entryTolerance);
        this.assertClose("inverse multiply", m.multiply((RealMatrix)new BlockRealMatrix(this.testDataInv)), (RealMatrix)identity, this.entryTolerance);
        this.assertClose("inverse multiply", (RealMatrix)mInv.multiply(m), (RealMatrix)identity, this.entryTolerance);
        this.assertClose("identity multiply", (RealMatrix)m.multiply(identity), (RealMatrix)m, this.entryTolerance);
        this.assertClose("identity multiply", (RealMatrix)identity.multiply(mInv), (RealMatrix)mInv, this.entryTolerance);
        this.assertClose("identity multiply", (RealMatrix)m2.multiply(identity), (RealMatrix)m2, this.entryTolerance);
        try {
            m.multiply(this.createSparseMatrix(this.bigSingular));
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMultiply2() {
        OpenMapRealMatrix m3 = this.createSparseMatrix(this.d3);
        OpenMapRealMatrix m4 = this.createSparseMatrix(this.d4);
        OpenMapRealMatrix m5 = this.createSparseMatrix(this.d5);
        this.assertClose("m3*m4=m5", m3.multiply((RealMatrix)m4), (RealMatrix)m5, this.entryTolerance);
    }

    @Test
    public void testTrace() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.id);
        Assert.assertEquals((String)"identity trace", (double)3.0, (double)m.getTrace(), (double)this.entryTolerance);
        m = this.createSparseMatrix(this.testData2);
        try {
            m.getTrace();
            Assert.fail((String)"Expecting NonSquareMatrixException");
        }
        catch (NonSquareMatrixException nonSquareMatrixException) {
            // empty catch block
        }
    }

    @Test
    public void testScalarAdd() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.testData);
        this.assertClose("scalar add", (RealMatrix)this.createSparseMatrix(this.testDataPlus2), m.scalarAdd(2.0), this.entryTolerance);
    }

    @Test
    public void testOperate() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.id);
        this.assertClose("identity operate", this.testVector, m.operate(this.testVector), this.entryTolerance);
        this.assertClose("identity operate", this.testVector, m.operate((RealVector)new ArrayRealVector(this.testVector)).toArray(), this.entryTolerance);
        m = this.createSparseMatrix(this.bigSingular);
        try {
            m.operate(this.testVector);
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMath209() {
        OpenMapRealMatrix a = this.createSparseMatrix(new double[][]{{1.0, 2.0}, {3.0, 4.0}, {5.0, 6.0}});
        double[] b = a.operate(new double[]{1.0, 1.0});
        Assert.assertEquals((long)a.getRowDimension(), (long)b.length);
        Assert.assertEquals((double)3.0, (double)b[0], (double)1.0E-12);
        Assert.assertEquals((double)7.0, (double)b[1], (double)1.0E-12);
        Assert.assertEquals((double)11.0, (double)b[2], (double)1.0E-12);
    }

    @Test
    public void testTranspose() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.testData);
        RealMatrix mIT = new LUDecomposition((RealMatrix)m).getSolver().getInverse().transpose();
        RealMatrix mTI = new LUDecomposition(m.transpose()).getSolver().getInverse();
        this.assertClose("inverse-transpose", mIT, mTI, this.normTolerance);
        m = this.createSparseMatrix(this.testData2);
        OpenMapRealMatrix mt = this.createSparseMatrix(this.testData2T);
        this.assertClose("transpose", (RealMatrix)mt, m.transpose(), this.normTolerance);
    }

    @Test
    public void testPremultiplyVector() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.testData);
        this.assertClose("premultiply", m.preMultiply(this.testVector), this.preMultTest, this.normTolerance);
        this.assertClose("premultiply", m.preMultiply(new ArrayRealVector(this.testVector).toArray()), this.preMultTest, this.normTolerance);
        m = this.createSparseMatrix(this.bigSingular);
        try {
            m.preMultiply(this.testVector);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPremultiply() {
        OpenMapRealMatrix m3 = this.createSparseMatrix(this.d3);
        OpenMapRealMatrix m4 = this.createSparseMatrix(this.d4);
        OpenMapRealMatrix m5 = this.createSparseMatrix(this.d5);
        this.assertClose("m3*m4=m5", m4.preMultiply((RealMatrix)m3), (RealMatrix)m5, this.entryTolerance);
        OpenMapRealMatrix m = this.createSparseMatrix(this.testData);
        OpenMapRealMatrix mInv = this.createSparseMatrix(this.testDataInv);
        OpenMapRealMatrix identity = this.createSparseMatrix(this.id);
        this.assertClose("inverse multiply", m.preMultiply((RealMatrix)mInv), (RealMatrix)identity, this.entryTolerance);
        this.assertClose("inverse multiply", mInv.preMultiply((RealMatrix)m), (RealMatrix)identity, this.entryTolerance);
        this.assertClose("identity multiply", m.preMultiply((RealMatrix)identity), (RealMatrix)m, this.entryTolerance);
        this.assertClose("identity multiply", identity.preMultiply((RealMatrix)mInv), (RealMatrix)mInv, this.entryTolerance);
        try {
            m.preMultiply((RealMatrix)this.createSparseMatrix(this.bigSingular));
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetVectors() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.testData);
        this.assertClose("get row", m.getRow(0), this.testDataRow1, this.entryTolerance);
        this.assertClose("get col", m.getColumn(2), this.testDataCol3, this.entryTolerance);
        try {
            m.getRow(10);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumn(-1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetEntry() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.testData);
        Assert.assertEquals((String)"get entry", (double)m.getEntry(0, 1), (double)2.0, (double)this.entryTolerance);
        try {
            m.getEntry(10, 4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testExamples() {
        double[][] matrixData = new double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 3.0}};
        OpenMapRealMatrix m = this.createSparseMatrix(matrixData);
        double[][] matrixData2 = new double[][]{{1.0, 2.0}, {2.0, 5.0}, {1.0, 7.0}};
        OpenMapRealMatrix n = this.createSparseMatrix(matrixData2);
        RealMatrix p = m.multiply((RealMatrix)n);
        Assert.assertEquals((long)2L, (long)p.getRowDimension());
        Assert.assertEquals((long)2L, (long)p.getColumnDimension());
        RealMatrix pInverse = new LUDecomposition(p).getSolver().getInverse();
        Assert.assertEquals((long)2L, (long)pInverse.getRowDimension());
        Assert.assertEquals((long)2L, (long)pInverse.getColumnDimension());
        double[][] coefficientsData = new double[][]{{2.0, 3.0, -2.0}, {-1.0, 7.0, 6.0}, {4.0, -3.0, -5.0}};
        OpenMapRealMatrix coefficients = this.createSparseMatrix(coefficientsData);
        ArrayRealVector constants = new ArrayRealVector(new double[]{1.0, -2.0, 1.0}, false);
        RealVector solution = new LUDecomposition((RealMatrix)coefficients).getSolver().solve((RealVector)constants);
        double cst0 = constants.getEntry(0);
        double cst1 = constants.getEntry(1);
        double cst2 = constants.getEntry(2);
        double sol0 = solution.getEntry(0);
        double sol1 = solution.getEntry(1);
        double sol2 = solution.getEntry(2);
        Assert.assertEquals((double)(2.0 * sol0 + 3.0 * sol1 - 2.0 * sol2), (double)cst0, (double)1.0E-12);
        Assert.assertEquals((double)(-1.0 * sol0 + 7.0 * sol1 + 6.0 * sol2), (double)cst1, (double)1.0E-12);
        Assert.assertEquals((double)(4.0 * sol0 - 3.0 * sol1 - 5.0 * sol2), (double)cst2, (double)1.0E-12);
    }

    @Test
    public void testSubMatrix() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.subTestData);
        OpenMapRealMatrix mRows23Cols00 = this.createSparseMatrix(this.subRows23Cols00);
        OpenMapRealMatrix mRows00Cols33 = this.createSparseMatrix(this.subRows00Cols33);
        OpenMapRealMatrix mRows01Cols23 = this.createSparseMatrix(this.subRows01Cols23);
        OpenMapRealMatrix mRows02Cols13 = this.createSparseMatrix(this.subRows02Cols13);
        OpenMapRealMatrix mRows03Cols12 = this.createSparseMatrix(this.subRows03Cols12);
        OpenMapRealMatrix mRows03Cols123 = this.createSparseMatrix(this.subRows03Cols123);
        OpenMapRealMatrix mRows20Cols123 = this.createSparseMatrix(this.subRows20Cols123);
        OpenMapRealMatrix mRows31Cols31 = this.createSparseMatrix(this.subRows31Cols31);
        Assert.assertEquals((String)"Rows23Cols00", (Object)mRows23Cols00, (Object)m.getSubMatrix(2, 3, 0, 0));
        Assert.assertEquals((String)"Rows00Cols33", (Object)mRows00Cols33, (Object)m.getSubMatrix(0, 0, 3, 3));
        Assert.assertEquals((String)"Rows01Cols23", (Object)mRows01Cols23, (Object)m.getSubMatrix(0, 1, 2, 3));
        Assert.assertEquals((String)"Rows02Cols13", (Object)mRows02Cols13, (Object)m.getSubMatrix(new int[]{0, 2}, new int[]{1, 3}));
        Assert.assertEquals((String)"Rows03Cols12", (Object)mRows03Cols12, (Object)m.getSubMatrix(new int[]{0, 3}, new int[]{1, 2}));
        Assert.assertEquals((String)"Rows03Cols123", (Object)mRows03Cols123, (Object)m.getSubMatrix(new int[]{0, 3}, new int[]{1, 2, 3}));
        Assert.assertEquals((String)"Rows20Cols123", (Object)mRows20Cols123, (Object)m.getSubMatrix(new int[]{2, 0}, new int[]{1, 2, 3}));
        Assert.assertEquals((String)"Rows31Cols31", (Object)mRows31Cols31, (Object)m.getSubMatrix(new int[]{3, 1}, new int[]{3, 1}));
        Assert.assertEquals((String)"Rows31Cols31", (Object)mRows31Cols31, (Object)m.getSubMatrix(new int[]{3, 1}, new int[]{3, 1}));
        try {
            m.getSubMatrix(1, 0, 2, 4);
            Assert.fail((String)"Expecting NumberIsTooSmallException");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            m.getSubMatrix(-1, 1, 2, 2);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getSubMatrix(1, 0, 2, 2);
            Assert.fail((String)"Expecting NumberIsTooSmallException");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            m.getSubMatrix(1, 0, 2, 4);
            Assert.fail((String)"Expecting NumberIsTooSmallException");
        }
        catch (NumberIsTooSmallException numberIsTooSmallException) {
            // empty catch block
        }
        try {
            m.getSubMatrix(new int[0], new int[]{0});
            Assert.fail((String)"Expecting NoDataException");
        }
        catch (NoDataException noDataException) {
            // empty catch block
        }
        try {
            m.getSubMatrix(new int[]{0}, new int[]{4});
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetRowMatrix() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.subTestData);
        OpenMapRealMatrix mRow0 = this.createSparseMatrix(this.subRow0);
        OpenMapRealMatrix mRow3 = this.createSparseMatrix(this.subRow3);
        Assert.assertEquals((String)"Row0", (Object)mRow0, (Object)m.getRowMatrix(0));
        Assert.assertEquals((String)"Row3", (Object)mRow3, (Object)m.getRowMatrix(3));
        try {
            m.getRowMatrix(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getRowMatrix(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetColumnMatrix() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.subTestData);
        OpenMapRealMatrix mColumn1 = this.createSparseMatrix(this.subColumn1);
        OpenMapRealMatrix mColumn3 = this.createSparseMatrix(this.subColumn3);
        Assert.assertEquals((String)"Column1", (Object)mColumn1, (Object)m.getColumnMatrix(1));
        Assert.assertEquals((String)"Column3", (Object)mColumn3, (Object)m.getColumnMatrix(3));
        try {
            m.getColumnMatrix(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumnMatrix(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetRowVector() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.subTestData);
        ArrayRealVector mRow0 = new ArrayRealVector(this.subRow0[0]);
        ArrayRealVector mRow3 = new ArrayRealVector(this.subRow3[0]);
        Assert.assertEquals((String)"Row0", (Object)mRow0, (Object)m.getRowVector(0));
        Assert.assertEquals((String)"Row3", (Object)mRow3, (Object)m.getRowVector(3));
        try {
            m.getRowVector(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getRowVector(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetColumnVector() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.subTestData);
        RealVector mColumn1 = this.columnToVector(this.subColumn1);
        RealVector mColumn3 = this.columnToVector(this.subColumn3);
        Assert.assertEquals((String)"Column1", (Object)mColumn1, (Object)m.getColumnVector(1));
        Assert.assertEquals((String)"Column3", (Object)mColumn3, (Object)m.getColumnVector(3));
        try {
            m.getColumnVector(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumnVector(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    private RealVector columnToVector(double[][] column) {
        double[] data = new double[column.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = column[i][0];
        }
        return new ArrayRealVector(data, false);
    }

    @Test
    public void testEqualsAndHashCode() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.testData);
        OpenMapRealMatrix m1 = m.copy();
        OpenMapRealMatrix mt = (OpenMapRealMatrix)m.transpose();
        Assert.assertTrue((m.hashCode() != mt.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((long)m.hashCode(), (long)m1.hashCode());
        Assert.assertEquals((Object)m, (Object)m);
        Assert.assertEquals((Object)m, (Object)m1);
        Assert.assertFalse((boolean)m.equals(null));
        Assert.assertFalse((boolean)m.equals((Object)mt));
        Assert.assertFalse((boolean)m.equals((Object)this.createSparseMatrix(this.bigSingular)));
    }

    @Test
    public void testToString() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.testData);
        Assert.assertEquals((Object)"OpenMapRealMatrix{{1.0,2.0,3.0},{2.0,5.0,3.0},{1.0,0.0,8.0}}", (Object)m.toString());
        m = new OpenMapRealMatrix(1, 1);
        Assert.assertEquals((Object)"OpenMapRealMatrix{{0.0}}", (Object)m.toString());
    }

    @Test
    public void testSetSubMatrix() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.testData);
        m.setSubMatrix(this.detData2, 1, 1);
        OpenMapRealMatrix expected = this.createSparseMatrix(new double[][]{{1.0, 2.0, 3.0}, {2.0, 1.0, 3.0}, {1.0, 2.0, 4.0}});
        Assert.assertEquals((Object)expected, (Object)m);
        m.setSubMatrix(this.detData2, 0, 0);
        expected = this.createSparseMatrix(new double[][]{{1.0, 3.0, 3.0}, {2.0, 4.0, 3.0}, {1.0, 2.0, 4.0}});
        Assert.assertEquals((Object)expected, (Object)m);
        m.setSubMatrix(this.testDataPlus2, 0, 0);
        expected = this.createSparseMatrix(new double[][]{{3.0, 4.0, 5.0}, {4.0, 7.0, 5.0}, {3.0, 2.0, 10.0}});
        Assert.assertEquals((Object)expected, (Object)m);
        OpenMapRealMatrix matrix = this.createSparseMatrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {5.0, 6.0, 7.0, 8.0}, {9.0, 0.0, 1.0, 2.0}});
        matrix.setSubMatrix((double[][])new double[][]{{3.0, 4.0}, {5.0, 6.0}}, 1, 1);
        expected = this.createSparseMatrix(new double[][]{{1.0, 2.0, 3.0, 4.0}, {5.0, 3.0, 4.0, 8.0}, {9.0, 5.0, 6.0, 2.0}});
        Assert.assertEquals((Object)expected, (Object)matrix);
        try {
            m.setSubMatrix(this.testData, 1, 1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setSubMatrix(this.testData, -1, 1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setSubMatrix(this.testData, 1, -1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((double[][])null, 1, 1);
            Assert.fail((String)"expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            new OpenMapRealMatrix(0, 0);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((double[][])new double[][]{{1.0}, {2.0, 3.0}}, 0, 0);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((double[][])new double[][]{new double[0]}, 0, 0);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSerial() {
        OpenMapRealMatrix m = this.createSparseMatrix(this.testData);
        Assert.assertEquals((Object)m, (Object)TestUtils.serializeAndRecover(m));
    }

    protected void assertClose(String msg, RealMatrix m, RealMatrix n, double tolerance) {
        Assert.assertTrue((String)msg, (m.subtract(n).getNorm() < tolerance ? 1 : 0) != 0);
    }

    protected void assertClose(String msg, double[] m, double[] n, double tolerance) {
        if (m.length != n.length) {
            Assert.fail((String)"vectors not same length");
        }
        for (int i = 0; i < m.length; ++i) {
            Assert.assertEquals((String)(msg + " " + i + " elements differ"), (double)m[i], (double)n[i], (double)tolerance);
        }
    }

    private OpenMapRealMatrix createSparseMatrix(double[][] data) {
        OpenMapRealMatrix matrix = new OpenMapRealMatrix(data.length, data[0].length);
        for (int row = 0; row < data.length; ++row) {
            for (int col = 0; col < data[row].length; ++col) {
                matrix.setEntry(row, col, data[row][col]);
            }
        }
        return matrix;
    }
}

