/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.OpenMapRealMatrix;
import org.junit.Assert;
import org.junit.Test;

public final class OpenMapRealMatrixTest {
    @Test(expected=NumberIsTooLargeException.class)
    public void testMath679() {
        new OpenMapRealMatrix(3, Integer.MAX_VALUE);
    }

    @Test
    public void testMath870() {
        OpenMapRealMatrix a = new OpenMapRealMatrix(3, 3);
        OpenMapRealMatrix x = new OpenMapRealMatrix(3, 1);
        x.setEntry(0, 0, Double.NaN);
        x.setEntry(2, 0, Double.NEGATIVE_INFINITY);
        OpenMapRealMatrix b = a.multiply(x);
        for (int i = 0; i < b.getRowDimension(); ++i) {
            for (int j = 0; j < b.getColumnDimension(); ++j) {
                Assert.assertEquals((double)0.0, (double)b.getEntry(i, j), (double)1.0E-20);
            }
        }
    }
}

