/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.linear;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NoDataException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.OutOfRangeException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.ArrayRealVector;
import com.hazelcast.shaded.org.apache.commons.math3.linear.BlockRealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.DefaultRealMatrixChangingVisitor;
import com.hazelcast.shaded.org.apache.commons.math3.linear.DefaultRealMatrixPreservingVisitor;
import com.hazelcast.shaded.org.apache.commons.math3.linear.LUDecomposition;
import com.hazelcast.shaded.org.apache.commons.math3.linear.MatrixDimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.NonSquareMatrixException;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrixChangingVisitor;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrixPreservingVisitor;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealVector;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.util.Arrays;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public final class BlockRealMatrixTest {
    protected double[][] id = new double[][]{{1.0, 0.0, 0.0}, {0.0, 1.0, 0.0}, {0.0, 0.0, 1.0}};
    protected double[][] testData = new double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 3.0}, {1.0, 0.0, 8.0}};
    protected double[][] testDataLU = new double[][]{{2.0, 5.0, 3.0}, {0.5, -2.5, 6.5}, {0.5, 0.2, 0.2}};
    protected double[][] testDataPlus2 = new double[][]{{3.0, 4.0, 5.0}, {4.0, 7.0, 5.0}, {3.0, 2.0, 10.0}};
    protected double[][] testDataMinus = new double[][]{{-1.0, -2.0, -3.0}, {-2.0, -5.0, -3.0}, {-1.0, 0.0, -8.0}};
    protected double[] testDataRow1 = new double[]{1.0, 2.0, 3.0};
    protected double[] testDataCol3 = new double[]{3.0, 3.0, 8.0};
    protected double[][] testDataInv = new double[][]{{-40.0, 16.0, 9.0}, {13.0, -5.0, -3.0}, {5.0, -2.0, -1.0}};
    protected double[] preMultTest = new double[]{8.0, 12.0, 33.0};
    protected double[][] testData2 = new double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 3.0}};
    protected double[][] testData2T = new double[][]{{1.0, 2.0}, {2.0, 5.0}, {3.0, 3.0}};
    protected double[][] testDataPlusInv = new double[][]{{-39.0, 18.0, 12.0}, {15.0, 0.0, 0.0}, {6.0, -2.0, 7.0}};
    protected double[][] luData = new double[][]{{2.0, 3.0, 3.0}, {0.0, 5.0, 7.0}, {6.0, 9.0, 8.0}};
    protected double[][] luDataLUDecomposition = new double[][]{{6.0, 9.0, 8.0}, {0.0, 5.0, 7.0}, {0.33333333333333, 0.0, 0.33333333333333}};
    protected double[][] singular = new double[][]{{2.0, 3.0}, {2.0, 3.0}};
    protected double[][] bigSingular = new double[][]{{1.0, 2.0, 3.0, 4.0}, {2.0, 5.0, 3.0, 4.0}, {7.0, 3.0, 256.0, 1930.0}, {3.0, 7.0, 6.0, 8.0}};
    protected double[][] detData = new double[][]{{1.0, 2.0, 3.0}, {4.0, 5.0, 6.0}, {7.0, 8.0, 10.0}};
    protected double[][] detData2 = new double[][]{{1.0, 3.0}, {2.0, 4.0}};
    protected double[] testVector = new double[]{1.0, 2.0, 3.0};
    protected double[] testVector2 = new double[]{1.0, 2.0, 3.0, 4.0};
    protected double[][] subTestData = new double[][]{{1.0, 2.0, 3.0, 4.0}, {1.5, 2.5, 3.5, 4.5}, {2.0, 4.0, 6.0, 8.0}, {4.0, 5.0, 6.0, 7.0}};
    protected double[][] subRows02Cols13 = new double[][]{{2.0, 4.0}, {4.0, 8.0}};
    protected double[][] subRows03Cols12 = new double[][]{{2.0, 3.0}, {5.0, 6.0}};
    protected double[][] subRows03Cols123 = new double[][]{{2.0, 3.0, 4.0}, {5.0, 6.0, 7.0}};
    protected double[][] subRows20Cols123 = new double[][]{{4.0, 6.0, 8.0}, {2.0, 3.0, 4.0}};
    protected double[][] subRows31Cols31 = new double[][]{{7.0, 5.0}, {4.5, 2.5}};
    protected double[][] subRows01Cols23 = new double[][]{{3.0, 4.0}, {3.5, 4.5}};
    protected double[][] subRows23Cols00 = new double[][]{{2.0}, {4.0}};
    protected double[][] subRows00Cols33 = new double[][]{{4.0}};
    protected double[][] subRow0 = new double[][]{{1.0, 2.0, 3.0, 4.0}};
    protected double[][] subRow3 = new double[][]{{4.0, 5.0, 6.0, 7.0}};
    protected double[][] subColumn1 = new double[][]{{2.0}, {2.5}, {4.0}, {5.0}};
    protected double[][] subColumn3 = new double[][]{{4.0}, {4.5}, {8.0}, {7.0}};
    protected double entryTolerance = 1.0E-15;
    protected double normTolerance = 1.0E-13;
    private double[][] d3 = new double[][]{{1.0, 2.0, 3.0, 4.0}, {5.0, 6.0, 7.0, 8.0}};
    private double[][] d4 = new double[][]{{1.0}, {2.0}, {3.0}, {4.0}};
    private double[][] d5 = new double[][]{{30.0}, {70.0}};

    @Test
    public void testDimensions() {
        BlockRealMatrix m = new BlockRealMatrix(this.testData);
        BlockRealMatrix m2 = new BlockRealMatrix(this.testData2);
        Assert.assertEquals((String)"testData row dimension", (long)3L, (long)m.getRowDimension());
        Assert.assertEquals((String)"testData column dimension", (long)3L, (long)m.getColumnDimension());
        Assert.assertTrue((String)"testData is square", (boolean)m.isSquare());
        Assert.assertEquals((String)"testData2 row dimension", (long)m2.getRowDimension(), (long)2L);
        Assert.assertEquals((String)"testData2 column dimension", (long)m2.getColumnDimension(), (long)3L);
        Assert.assertTrue((String)"testData2 is not square", (!m2.isSquare() ? 1 : 0) != 0);
    }

    @Test
    public void testCopyFunctions() {
        Random r = new Random(66636328996002L);
        BlockRealMatrix m1 = this.createRandomMatrix(r, 47, 83);
        BlockRealMatrix m2 = new BlockRealMatrix(m1.getData());
        Assert.assertEquals((Object)m1, (Object)m2);
        BlockRealMatrix m3 = new BlockRealMatrix(this.testData);
        BlockRealMatrix m4 = new BlockRealMatrix(m3.getData());
        Assert.assertEquals((Object)m3, (Object)m4);
    }

    @Test
    public void testAdd() {
        BlockRealMatrix m = new BlockRealMatrix(this.testData);
        BlockRealMatrix mInv = new BlockRealMatrix(this.testDataInv);
        BlockRealMatrix mPlusMInv = m.add(mInv);
        double[][] sumEntries = mPlusMInv.getData();
        for (int row = 0; row < m.getRowDimension(); ++row) {
            for (int col = 0; col < m.getColumnDimension(); ++col) {
                Assert.assertEquals((String)"sum entry entry", (double)this.testDataPlusInv[row][col], (double)sumEntries[row][col], (double)this.entryTolerance);
            }
        }
    }

    @Test
    public void testAddFail() {
        BlockRealMatrix m = new BlockRealMatrix(this.testData);
        BlockRealMatrix m2 = new BlockRealMatrix(this.testData2);
        try {
            m.add(m2);
            Assert.fail((String)"MathIllegalArgumentException expected");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testNorm() {
        BlockRealMatrix m = new BlockRealMatrix(this.testData);
        BlockRealMatrix m2 = new BlockRealMatrix(this.testData2);
        Assert.assertEquals((String)"testData norm", (double)14.0, (double)m.getNorm(), (double)this.entryTolerance);
        Assert.assertEquals((String)"testData2 norm", (double)7.0, (double)m2.getNorm(), (double)this.entryTolerance);
    }

    @Test
    public void testFrobeniusNorm() {
        BlockRealMatrix m = new BlockRealMatrix(this.testData);
        BlockRealMatrix m2 = new BlockRealMatrix(this.testData2);
        Assert.assertEquals((String)"testData Frobenius norm", (double)FastMath.sqrt((double)117.0), (double)m.getFrobeniusNorm(), (double)this.entryTolerance);
        Assert.assertEquals((String)"testData2 Frobenius norm", (double)FastMath.sqrt((double)52.0), (double)m2.getFrobeniusNorm(), (double)this.entryTolerance);
    }

    @Test
    public void testPlusMinus() {
        BlockRealMatrix m = new BlockRealMatrix(this.testData);
        BlockRealMatrix m2 = new BlockRealMatrix(this.testDataInv);
        this.assertClose((RealMatrix)m.subtract(m2), m2.scalarMultiply(-1.0).add((RealMatrix)m), this.entryTolerance);
        try {
            m.subtract(new BlockRealMatrix(this.testData2));
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMultiply() {
        BlockRealMatrix m = new BlockRealMatrix(this.testData);
        BlockRealMatrix mInv = new BlockRealMatrix(this.testDataInv);
        BlockRealMatrix identity = new BlockRealMatrix(this.id);
        BlockRealMatrix m2 = new BlockRealMatrix(this.testData2);
        this.assertClose((RealMatrix)m.multiply(mInv), (RealMatrix)identity, this.entryTolerance);
        this.assertClose((RealMatrix)mInv.multiply(m), (RealMatrix)identity, this.entryTolerance);
        this.assertClose((RealMatrix)m.multiply(identity), (RealMatrix)m, this.entryTolerance);
        this.assertClose((RealMatrix)identity.multiply(mInv), (RealMatrix)mInv, this.entryTolerance);
        this.assertClose((RealMatrix)m2.multiply(identity), (RealMatrix)m2, this.entryTolerance);
        try {
            m.multiply(new BlockRealMatrix(this.bigSingular));
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testSeveralBlocks() {
        BlockRealMatrix m = new BlockRealMatrix(35, 71);
        for (int i = 0; i < m.getRowDimension(); ++i) {
            for (int j = 0; j < m.getColumnDimension(); ++j) {
                m.setEntry(i, j, (double)i + (double)j / 1024.0);
            }
        }
        RealMatrix mT = m.transpose();
        Assert.assertEquals((long)m.getRowDimension(), (long)mT.getColumnDimension());
        Assert.assertEquals((long)m.getColumnDimension(), (long)mT.getRowDimension());
        for (int i = 0; i < mT.getRowDimension(); ++i) {
            for (int j = 0; j < mT.getColumnDimension(); ++j) {
                Assert.assertEquals((double)m.getEntry(j, i), (double)mT.getEntry(i, j), (double)0.0);
            }
        }
        RealMatrix mPm = m.add((RealMatrix)m);
        for (int i = 0; i < mPm.getRowDimension(); ++i) {
            for (int j = 0; j < mPm.getColumnDimension(); ++j) {
                Assert.assertEquals((double)(2.0 * m.getEntry(i, j)), (double)mPm.getEntry(i, j), (double)0.0);
            }
        }
        RealMatrix mPmMm = mPm.subtract((RealMatrix)m);
        for (int i = 0; i < mPmMm.getRowDimension(); ++i) {
            for (int j = 0; j < mPmMm.getColumnDimension(); ++j) {
                Assert.assertEquals((double)m.getEntry(i, j), (double)mPmMm.getEntry(i, j), (double)0.0);
            }
        }
        RealMatrix mTm = mT.multiply((RealMatrix)m);
        for (int i = 0; i < mTm.getRowDimension(); ++i) {
            for (int j = 0; j < mTm.getColumnDimension(); ++j) {
                double sum = 0.0;
                for (int k = 0; k < mT.getColumnDimension(); ++k) {
                    sum += ((double)k + (double)i / 1024.0) * ((double)k + (double)j / 1024.0);
                }
                Assert.assertEquals((double)sum, (double)mTm.getEntry(i, j), (double)0.0);
            }
        }
        RealMatrix mmT = m.multiply(mT);
        for (int i = 0; i < mmT.getRowDimension(); ++i) {
            for (int j = 0; j < mmT.getColumnDimension(); ++j) {
                double sum = 0.0;
                for (int k = 0; k < m.getColumnDimension(); ++k) {
                    sum += ((double)i + (double)k / 1024.0) * ((double)j + (double)k / 1024.0);
                }
                Assert.assertEquals((double)sum, (double)mmT.getEntry(i, j), (double)0.0);
            }
        }
        RealMatrix sub1 = m.getSubMatrix(2, 9, 5, 20);
        for (int i = 0; i < sub1.getRowDimension(); ++i) {
            for (int j = 0; j < sub1.getColumnDimension(); ++j) {
                Assert.assertEquals((double)((double)(i + 2) + (double)(j + 5) / 1024.0), (double)sub1.getEntry(i, j), (double)0.0);
            }
        }
        RealMatrix sub2 = m.getSubMatrix(10, 12, 3, 70);
        for (int i = 0; i < sub2.getRowDimension(); ++i) {
            for (int j = 0; j < sub2.getColumnDimension(); ++j) {
                Assert.assertEquals((double)((double)(i + 10) + (double)(j + 3) / 1024.0), (double)sub2.getEntry(i, j), (double)0.0);
            }
        }
        RealMatrix sub3 = m.getSubMatrix(30, 34, 0, 5);
        for (int i = 0; i < sub3.getRowDimension(); ++i) {
            for (int j = 0; j < sub3.getColumnDimension(); ++j) {
                Assert.assertEquals((double)((double)(i + 30) + (double)(j + 0) / 1024.0), (double)sub3.getEntry(i, j), (double)0.0);
            }
        }
        RealMatrix sub4 = m.getSubMatrix(30, 32, 62, 65);
        for (int i = 0; i < sub4.getRowDimension(); ++i) {
            for (int j = 0; j < sub4.getColumnDimension(); ++j) {
                Assert.assertEquals((double)((double)(i + 30) + (double)(j + 62) / 1024.0), (double)sub4.getEntry(i, j), (double)0.0);
            }
        }
    }

    @Test
    public void testMultiply2() {
        BlockRealMatrix m3 = new BlockRealMatrix(this.d3);
        BlockRealMatrix m4 = new BlockRealMatrix(this.d4);
        BlockRealMatrix m5 = new BlockRealMatrix(this.d5);
        this.assertClose(m3.multiply((RealMatrix)m4), (RealMatrix)m5, this.entryTolerance);
    }

    @Test
    public void testTrace() {
        BlockRealMatrix m = new BlockRealMatrix(this.id);
        Assert.assertEquals((String)"identity trace", (double)3.0, (double)m.getTrace(), (double)this.entryTolerance);
        m = new BlockRealMatrix(this.testData2);
        try {
            m.getTrace();
            Assert.fail((String)"Expecting NonSquareMatrixException");
        }
        catch (NonSquareMatrixException nonSquareMatrixException) {
            // empty catch block
        }
    }

    @Test
    public void testScalarAdd() {
        BlockRealMatrix m = new BlockRealMatrix(this.testData);
        this.assertClose((RealMatrix)new BlockRealMatrix(this.testDataPlus2), m.scalarAdd(2.0), this.entryTolerance);
    }

    @Test
    public void testOperate() {
        BlockRealMatrix m = new BlockRealMatrix(this.id);
        this.assertClose(this.testVector, m.operate(this.testVector), this.entryTolerance);
        this.assertClose(this.testVector, m.operate((RealVector)new ArrayRealVector(this.testVector)).toArray(), this.entryTolerance);
        m = new BlockRealMatrix(this.bigSingular);
        try {
            m.operate(this.testVector);
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testOperateLarge() {
        int p = 182;
        int q = 130;
        int r = 156;
        Random random = new Random(111007463902334L);
        BlockRealMatrix m1 = this.createRandomMatrix(random, p, q);
        BlockRealMatrix m2 = this.createRandomMatrix(random, q, r);
        RealMatrix m1m2 = m1.multiply((RealMatrix)m2);
        for (int i = 0; i < r; ++i) {
            this.checkArrays(m1m2.getColumn(i), m1.operate(m2.getColumn(i)));
        }
    }

    @Test
    public void testOperatePremultiplyLarge() {
        int p = 182;
        int q = 130;
        int r = 156;
        Random random = new Random(111007463902334L);
        BlockRealMatrix m1 = this.createRandomMatrix(random, p, q);
        BlockRealMatrix m2 = this.createRandomMatrix(random, q, r);
        RealMatrix m1m2 = m1.multiply((RealMatrix)m2);
        for (int i = 0; i < p; ++i) {
            this.checkArrays(m1m2.getRow(i), m2.preMultiply(m1.getRow(i)));
        }
    }

    @Test
    public void testMath209() {
        BlockRealMatrix a = new BlockRealMatrix((double[][])new double[][]{{1.0, 2.0}, {3.0, 4.0}, {5.0, 6.0}});
        double[] b = a.operate(new double[]{1.0, 1.0});
        Assert.assertEquals((long)a.getRowDimension(), (long)b.length);
        Assert.assertEquals((double)3.0, (double)b[0], (double)1.0E-12);
        Assert.assertEquals((double)7.0, (double)b[1], (double)1.0E-12);
        Assert.assertEquals((double)11.0, (double)b[2], (double)1.0E-12);
    }

    @Test
    public void testTranspose() {
        BlockRealMatrix m = new BlockRealMatrix(this.testData);
        RealMatrix mIT = new LUDecomposition((RealMatrix)m).getSolver().getInverse().transpose();
        RealMatrix mTI = new LUDecomposition(m.transpose()).getSolver().getInverse();
        this.assertClose(mIT, mTI, this.normTolerance);
        m = new BlockRealMatrix(this.testData2);
        BlockRealMatrix mt = new BlockRealMatrix(this.testData2T);
        this.assertClose((RealMatrix)mt, m.transpose(), this.normTolerance);
    }

    @Test
    public void testPremultiplyVector() {
        BlockRealMatrix m = new BlockRealMatrix(this.testData);
        this.assertClose(m.preMultiply(this.testVector), this.preMultTest, this.normTolerance);
        this.assertClose(m.preMultiply(new ArrayRealVector(this.testVector).toArray()), this.preMultTest, this.normTolerance);
        m = new BlockRealMatrix(this.bigSingular);
        try {
            m.preMultiply(this.testVector);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPremultiply() {
        BlockRealMatrix m3 = new BlockRealMatrix(this.d3);
        BlockRealMatrix m4 = new BlockRealMatrix(this.d4);
        BlockRealMatrix m5 = new BlockRealMatrix(this.d5);
        this.assertClose(m4.preMultiply((RealMatrix)m3), (RealMatrix)m5, this.entryTolerance);
        BlockRealMatrix m = new BlockRealMatrix(this.testData);
        BlockRealMatrix mInv = new BlockRealMatrix(this.testDataInv);
        BlockRealMatrix identity = new BlockRealMatrix(this.id);
        this.assertClose(m.preMultiply((RealMatrix)mInv), (RealMatrix)identity, this.entryTolerance);
        this.assertClose(mInv.preMultiply((RealMatrix)m), (RealMatrix)identity, this.entryTolerance);
        this.assertClose(m.preMultiply((RealMatrix)identity), (RealMatrix)m, this.entryTolerance);
        this.assertClose(identity.preMultiply((RealMatrix)mInv), (RealMatrix)mInv, this.entryTolerance);
        try {
            m.preMultiply((RealMatrix)new BlockRealMatrix(this.bigSingular));
            Assert.fail((String)"Expecting illegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testGetVectors() {
        BlockRealMatrix m = new BlockRealMatrix(this.testData);
        this.assertClose(m.getRow(0), this.testDataRow1, this.entryTolerance);
        this.assertClose(m.getColumn(2), this.testDataCol3, this.entryTolerance);
        try {
            m.getRow(10);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumn(-1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testGetEntry() {
        BlockRealMatrix m = new BlockRealMatrix(this.testData);
        Assert.assertEquals((String)"get entry", (double)m.getEntry(0, 1), (double)2.0, (double)this.entryTolerance);
        try {
            m.getEntry(10, 4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testExamples() {
        double[][] matrixData = new double[][]{{1.0, 2.0, 3.0}, {2.0, 5.0, 3.0}};
        BlockRealMatrix m = new BlockRealMatrix((double[][])matrixData);
        double[][] matrixData2 = new double[][]{{1.0, 2.0}, {2.0, 5.0}, {1.0, 7.0}};
        BlockRealMatrix n = new BlockRealMatrix((double[][])matrixData2);
        RealMatrix p = m.multiply((RealMatrix)n);
        Assert.assertEquals((long)2L, (long)p.getRowDimension());
        Assert.assertEquals((long)2L, (long)p.getColumnDimension());
        RealMatrix pInverse = new LUDecomposition(p).getSolver().getInverse();
        Assert.assertEquals((long)2L, (long)pInverse.getRowDimension());
        Assert.assertEquals((long)2L, (long)pInverse.getColumnDimension());
        double[][] coefficientsData = new double[][]{{2.0, 3.0, -2.0}, {-1.0, 7.0, 6.0}, {4.0, -3.0, -5.0}};
        BlockRealMatrix coefficients = new BlockRealMatrix((double[][])coefficientsData);
        ArrayRealVector constants = new ArrayRealVector(new double[]{1.0, -2.0, 1.0}, false);
        RealVector solution = new LUDecomposition((RealMatrix)coefficients).getSolver().solve((RealVector)constants);
        double cst0 = constants.getEntry(0);
        double cst1 = constants.getEntry(1);
        double cst2 = constants.getEntry(2);
        double sol0 = solution.getEntry(0);
        double sol1 = solution.getEntry(1);
        double sol2 = solution.getEntry(2);
        Assert.assertEquals((double)(2.0 * sol0 + 3.0 * sol1 - 2.0 * sol2), (double)cst0, (double)1.0E-12);
        Assert.assertEquals((double)(-1.0 * sol0 + 7.0 * sol1 + 6.0 * sol2), (double)cst1, (double)1.0E-12);
        Assert.assertEquals((double)(4.0 * sol0 - 3.0 * sol1 - 5.0 * sol2), (double)cst2, (double)1.0E-12);
    }

    @Test
    public void testGetSubMatrix() {
        BlockRealMatrix m = new BlockRealMatrix(this.subTestData);
        this.checkGetSubMatrix((RealMatrix)m, this.subRows23Cols00, 2, 3, 0, 0);
        this.checkGetSubMatrix((RealMatrix)m, this.subRows00Cols33, 0, 0, 3, 3);
        this.checkGetSubMatrix((RealMatrix)m, this.subRows01Cols23, 0, 1, 2, 3);
        this.checkGetSubMatrix((RealMatrix)m, this.subRows02Cols13, new int[]{0, 2}, new int[]{1, 3});
        this.checkGetSubMatrix((RealMatrix)m, this.subRows03Cols12, new int[]{0, 3}, new int[]{1, 2});
        this.checkGetSubMatrix((RealMatrix)m, this.subRows03Cols123, new int[]{0, 3}, new int[]{1, 2, 3});
        this.checkGetSubMatrix((RealMatrix)m, this.subRows20Cols123, new int[]{2, 0}, new int[]{1, 2, 3});
        this.checkGetSubMatrix((RealMatrix)m, this.subRows31Cols31, new int[]{3, 1}, new int[]{3, 1});
        this.checkGetSubMatrix((RealMatrix)m, this.subRows31Cols31, new int[]{3, 1}, new int[]{3, 1});
        this.checkGetSubMatrix((RealMatrix)m, null, 1, 0, 2, 4);
        this.checkGetSubMatrix((RealMatrix)m, null, -1, 1, 2, 2);
        this.checkGetSubMatrix((RealMatrix)m, null, 1, 0, 2, 2);
        this.checkGetSubMatrix((RealMatrix)m, null, 1, 0, 2, 4);
        this.checkGetSubMatrix((RealMatrix)m, null, new int[0], new int[]{0});
        this.checkGetSubMatrix((RealMatrix)m, null, new int[]{0}, new int[]{4});
    }

    private void checkGetSubMatrix(RealMatrix m, double[][] reference, int startRow, int endRow, int startColumn, int endColumn) {
        block8: {
            try {
                RealMatrix sub = m.getSubMatrix(startRow, endRow, startColumn, endColumn);
                if (reference != null) {
                    Assert.assertEquals((Object)new BlockRealMatrix(reference), (Object)sub);
                } else {
                    Assert.fail((String)"Expecting OutOfRangeException or NumberIsTooSmallException or NoDataException");
                }
            }
            catch (OutOfRangeException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NumberIsTooSmallException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NoDataException e) {
                if (reference == null) break block8;
                throw e;
            }
        }
    }

    private void checkGetSubMatrix(RealMatrix m, double[][] reference, int[] selectedRows, int[] selectedColumns) {
        block8: {
            try {
                RealMatrix sub = m.getSubMatrix(selectedRows, selectedColumns);
                if (reference != null) {
                    Assert.assertEquals((Object)new BlockRealMatrix(reference), (Object)sub);
                } else {
                    Assert.fail((String)"Expecting OutOfRangeException or NumberIsTooSmallExceptiono r NoDataException");
                }
            }
            catch (OutOfRangeException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NumberIsTooSmallException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NoDataException e) {
                if (reference == null) break block8;
                throw e;
            }
        }
    }

    @Test
    public void testGetSetMatrixLarge() {
        int n = 156;
        BlockRealMatrix m = new BlockRealMatrix(n, n);
        BlockRealMatrix sub = new BlockRealMatrix(n - 4, n - 4).scalarAdd(1.0);
        m.setSubMatrix(sub.getData(), 2, 2);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i < 2 || i > n - 3 || j < 2 || j > n - 3) {
                    Assert.assertEquals((double)0.0, (double)m.getEntry(i, j), (double)0.0);
                    continue;
                }
                Assert.assertEquals((double)1.0, (double)m.getEntry(i, j), (double)0.0);
            }
        }
        Assert.assertEquals((Object)sub, (Object)m.getSubMatrix(2, n - 3, 2, n - 3));
    }

    @Test
    public void testCopySubMatrix() {
        BlockRealMatrix m = new BlockRealMatrix(this.subTestData);
        this.checkCopy((RealMatrix)m, this.subRows23Cols00, 2, 3, 0, 0);
        this.checkCopy((RealMatrix)m, this.subRows00Cols33, 0, 0, 3, 3);
        this.checkCopy((RealMatrix)m, this.subRows01Cols23, 0, 1, 2, 3);
        this.checkCopy((RealMatrix)m, this.subRows02Cols13, new int[]{0, 2}, new int[]{1, 3});
        this.checkCopy((RealMatrix)m, this.subRows03Cols12, new int[]{0, 3}, new int[]{1, 2});
        this.checkCopy((RealMatrix)m, this.subRows03Cols123, new int[]{0, 3}, new int[]{1, 2, 3});
        this.checkCopy((RealMatrix)m, this.subRows20Cols123, new int[]{2, 0}, new int[]{1, 2, 3});
        this.checkCopy((RealMatrix)m, this.subRows31Cols31, new int[]{3, 1}, new int[]{3, 1});
        this.checkCopy((RealMatrix)m, this.subRows31Cols31, new int[]{3, 1}, new int[]{3, 1});
        this.checkCopy((RealMatrix)m, null, 1, 0, 2, 4);
        this.checkCopy((RealMatrix)m, null, -1, 1, 2, 2);
        this.checkCopy((RealMatrix)m, null, 1, 0, 2, 2);
        this.checkCopy((RealMatrix)m, null, 1, 0, 2, 4);
        this.checkCopy((RealMatrix)m, null, new int[0], new int[]{0});
        this.checkCopy((RealMatrix)m, null, new int[]{0}, new int[]{4});
    }

    private void checkCopy(RealMatrix m, double[][] reference, int startRow, int endRow, int startColumn, int endColumn) {
        block8: {
            try {
                double[][] sub = reference == null ? new double[1][1] : new double[reference.length][reference[0].length];
                m.copySubMatrix(startRow, endRow, startColumn, endColumn, sub);
                if (reference != null) {
                    Assert.assertEquals((Object)new BlockRealMatrix(reference), (Object)new BlockRealMatrix(sub));
                } else {
                    Assert.fail((String)"Expecting OutOfRangeException or NumberIsTooSmallException or NoDataException");
                }
            }
            catch (OutOfRangeException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NumberIsTooSmallException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NoDataException e) {
                if (reference == null) break block8;
                throw e;
            }
        }
    }

    private void checkCopy(RealMatrix m, double[][] reference, int[] selectedRows, int[] selectedColumns) {
        block8: {
            try {
                double[][] sub = reference == null ? new double[1][1] : new double[reference.length][reference[0].length];
                m.copySubMatrix(selectedRows, selectedColumns, sub);
                if (reference != null) {
                    Assert.assertEquals((Object)new BlockRealMatrix(reference), (Object)new BlockRealMatrix(sub));
                } else {
                    Assert.fail((String)"Expecting OutOfRangeException or NumberIsTooSmallException or NoDataException");
                }
            }
            catch (OutOfRangeException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NumberIsTooSmallException e) {
                if (reference != null) {
                    throw e;
                }
            }
            catch (NoDataException e) {
                if (reference == null) break block8;
                throw e;
            }
        }
    }

    @Test
    public void testGetRowMatrix() {
        BlockRealMatrix m = new BlockRealMatrix(this.subTestData);
        BlockRealMatrix mRow0 = new BlockRealMatrix(this.subRow0);
        BlockRealMatrix mRow3 = new BlockRealMatrix(this.subRow3);
        Assert.assertEquals((String)"Row0", (Object)mRow0, (Object)m.getRowMatrix(0));
        Assert.assertEquals((String)"Row3", (Object)mRow3, (Object)m.getRowMatrix(3));
        try {
            m.getRowMatrix(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getRowMatrix(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetRowMatrix() {
        BlockRealMatrix m = new BlockRealMatrix(this.subTestData);
        BlockRealMatrix mRow3 = new BlockRealMatrix(this.subRow3);
        Assert.assertNotSame((Object)mRow3, (Object)m.getRowMatrix(0));
        m.setRowMatrix(0, (RealMatrix)mRow3);
        Assert.assertEquals((Object)mRow3, (Object)m.getRowMatrix(0));
        try {
            m.setRowMatrix(-1, (RealMatrix)mRow3);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setRowMatrix(0, (RealMatrix)m);
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testGetSetRowMatrixLarge() {
        int n = 156;
        BlockRealMatrix m = new BlockRealMatrix(n, n);
        BlockRealMatrix sub = new BlockRealMatrix(1, n).scalarAdd(1.0);
        m.setRowMatrix(2, (RealMatrix)sub);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i != 2) {
                    Assert.assertEquals((double)0.0, (double)m.getEntry(i, j), (double)0.0);
                    continue;
                }
                Assert.assertEquals((double)1.0, (double)m.getEntry(i, j), (double)0.0);
            }
        }
        Assert.assertEquals((Object)sub, (Object)m.getRowMatrix(2));
    }

    @Test
    public void testGetColumnMatrix() {
        BlockRealMatrix m = new BlockRealMatrix(this.subTestData);
        BlockRealMatrix mColumn1 = new BlockRealMatrix(this.subColumn1);
        BlockRealMatrix mColumn3 = new BlockRealMatrix(this.subColumn3);
        Assert.assertEquals((Object)mColumn1, (Object)m.getColumnMatrix(1));
        Assert.assertEquals((Object)mColumn3, (Object)m.getColumnMatrix(3));
        try {
            m.getColumnMatrix(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumnMatrix(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetColumnMatrix() {
        BlockRealMatrix m = new BlockRealMatrix(this.subTestData);
        BlockRealMatrix mColumn3 = new BlockRealMatrix(this.subColumn3);
        Assert.assertNotSame((Object)mColumn3, (Object)m.getColumnMatrix(1));
        m.setColumnMatrix(1, (RealMatrix)mColumn3);
        Assert.assertEquals((Object)mColumn3, (Object)m.getColumnMatrix(1));
        try {
            m.setColumnMatrix(-1, (RealMatrix)mColumn3);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setColumnMatrix(0, (RealMatrix)m);
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testGetSetColumnMatrixLarge() {
        int n = 156;
        BlockRealMatrix m = new BlockRealMatrix(n, n);
        BlockRealMatrix sub = new BlockRealMatrix(n, 1).scalarAdd(1.0);
        m.setColumnMatrix(2, (RealMatrix)sub);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (j != 2) {
                    Assert.assertEquals((double)0.0, (double)m.getEntry(i, j), (double)0.0);
                    continue;
                }
                Assert.assertEquals((double)1.0, (double)m.getEntry(i, j), (double)0.0);
            }
        }
        Assert.assertEquals((Object)sub, (Object)m.getColumnMatrix(2));
    }

    @Test
    public void testGetRowVector() {
        BlockRealMatrix m = new BlockRealMatrix(this.subTestData);
        ArrayRealVector mRow0 = new ArrayRealVector(this.subRow0[0]);
        ArrayRealVector mRow3 = new ArrayRealVector(this.subRow3[0]);
        Assert.assertEquals((Object)mRow0, (Object)m.getRowVector(0));
        Assert.assertEquals((Object)mRow3, (Object)m.getRowVector(3));
        try {
            m.getRowVector(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getRowVector(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetRowVector() {
        BlockRealMatrix m = new BlockRealMatrix(this.subTestData);
        ArrayRealVector mRow3 = new ArrayRealVector(this.subRow3[0]);
        Assert.assertNotSame((Object)mRow3, (Object)m.getRowMatrix(0));
        m.setRowVector(0, (RealVector)mRow3);
        Assert.assertEquals((Object)mRow3, (Object)m.getRowVector(0));
        try {
            m.setRowVector(-1, (RealVector)mRow3);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setRowVector(0, (RealVector)new ArrayRealVector(5));
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testGetSetRowVectorLarge() {
        int n = 156;
        BlockRealMatrix m = new BlockRealMatrix(n, n);
        ArrayRealVector sub = new ArrayRealVector(n, 1.0);
        m.setRowVector(2, (RealVector)sub);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i != 2) {
                    Assert.assertEquals((double)0.0, (double)m.getEntry(i, j), (double)0.0);
                    continue;
                }
                Assert.assertEquals((double)1.0, (double)m.getEntry(i, j), (double)0.0);
            }
        }
        Assert.assertEquals((Object)sub, (Object)m.getRowVector(2));
    }

    @Test
    public void testGetColumnVector() {
        BlockRealMatrix m = new BlockRealMatrix(this.subTestData);
        RealVector mColumn1 = this.columnToVector(this.subColumn1);
        RealVector mColumn3 = this.columnToVector(this.subColumn3);
        Assert.assertEquals((Object)mColumn1, (Object)m.getColumnVector(1));
        Assert.assertEquals((Object)mColumn3, (Object)m.getColumnVector(3));
        try {
            m.getColumnVector(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumnVector(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetColumnVector() {
        BlockRealMatrix m = new BlockRealMatrix(this.subTestData);
        RealVector mColumn3 = this.columnToVector(this.subColumn3);
        Assert.assertNotSame((Object)mColumn3, (Object)m.getColumnVector(1));
        m.setColumnVector(1, mColumn3);
        Assert.assertEquals((Object)mColumn3, (Object)m.getColumnVector(1));
        try {
            m.setColumnVector(-1, mColumn3);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setColumnVector(0, (RealVector)new ArrayRealVector(5));
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testGetSetColumnVectorLarge() {
        int n = 156;
        BlockRealMatrix m = new BlockRealMatrix(n, n);
        ArrayRealVector sub = new ArrayRealVector(n, 1.0);
        m.setColumnVector(2, (RealVector)sub);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (j != 2) {
                    Assert.assertEquals((double)0.0, (double)m.getEntry(i, j), (double)0.0);
                    continue;
                }
                Assert.assertEquals((double)1.0, (double)m.getEntry(i, j), (double)0.0);
            }
        }
        Assert.assertEquals((Object)sub, (Object)m.getColumnVector(2));
    }

    private RealVector columnToVector(double[][] column) {
        double[] data = new double[column.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = column[i][0];
        }
        return new ArrayRealVector(data, false);
    }

    @Test
    public void testGetRow() {
        BlockRealMatrix m = new BlockRealMatrix(this.subTestData);
        this.checkArrays(this.subRow0[0], m.getRow(0));
        this.checkArrays(this.subRow3[0], m.getRow(3));
        try {
            m.getRow(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getRow(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetRow() {
        BlockRealMatrix m = new BlockRealMatrix(this.subTestData);
        Assert.assertTrue((this.subRow3[0][0] != m.getRow(0)[0] ? 1 : 0) != 0);
        m.setRow(0, this.subRow3[0]);
        this.checkArrays(this.subRow3[0], m.getRow(0));
        try {
            m.setRow(-1, this.subRow3[0]);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setRow(0, new double[5]);
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testGetSetRowLarge() {
        int n = 156;
        BlockRealMatrix m = new BlockRealMatrix(n, n);
        double[] sub = new double[n];
        Arrays.fill(sub, 1.0);
        m.setRow(2, sub);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (i != 2) {
                    Assert.assertEquals((double)0.0, (double)m.getEntry(i, j), (double)0.0);
                    continue;
                }
                Assert.assertEquals((double)1.0, (double)m.getEntry(i, j), (double)0.0);
            }
        }
        this.checkArrays(sub, m.getRow(2));
    }

    @Test
    public void testGetColumn() {
        BlockRealMatrix m = new BlockRealMatrix(this.subTestData);
        double[] mColumn1 = this.columnToArray(this.subColumn1);
        double[] mColumn3 = this.columnToArray(this.subColumn3);
        this.checkArrays(mColumn1, m.getColumn(1));
        this.checkArrays(mColumn3, m.getColumn(3));
        try {
            m.getColumn(-1);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.getColumn(4);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
    }

    @Test
    public void testSetColumn() {
        BlockRealMatrix m = new BlockRealMatrix(this.subTestData);
        double[] mColumn3 = this.columnToArray(this.subColumn3);
        Assert.assertTrue((mColumn3[0] != m.getColumn(1)[0] ? 1 : 0) != 0);
        m.setColumn(1, mColumn3);
        this.checkArrays(mColumn3, m.getColumn(1));
        try {
            m.setColumn(-1, mColumn3);
            Assert.fail((String)"Expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setColumn(0, new double[5]);
            Assert.fail((String)"Expecting MatrixDimensionMismatchException");
        }
        catch (MatrixDimensionMismatchException matrixDimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testGetSetColumnLarge() {
        int n = 156;
        BlockRealMatrix m = new BlockRealMatrix(n, n);
        double[] sub = new double[n];
        Arrays.fill(sub, 1.0);
        m.setColumn(2, sub);
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                if (j != 2) {
                    Assert.assertEquals((double)0.0, (double)m.getEntry(i, j), (double)0.0);
                    continue;
                }
                Assert.assertEquals((double)1.0, (double)m.getEntry(i, j), (double)0.0);
            }
        }
        this.checkArrays(sub, m.getColumn(2));
    }

    private double[] columnToArray(double[][] column) {
        double[] data = new double[column.length];
        for (int i = 0; i < data.length; ++i) {
            data[i] = column[i][0];
        }
        return data;
    }

    private void checkArrays(double[] expected, double[] actual) {
        Assert.assertEquals((long)expected.length, (long)actual.length);
        for (int i = 0; i < expected.length; ++i) {
            Assert.assertEquals((double)expected[i], (double)actual[i], (double)0.0);
        }
    }

    @Test
    public void testEqualsAndHashCode() {
        BlockRealMatrix m = new BlockRealMatrix(this.testData);
        BlockRealMatrix m1 = m.copy();
        BlockRealMatrix mt = m.transpose();
        Assert.assertTrue((m.hashCode() != mt.hashCode() ? 1 : 0) != 0);
        Assert.assertEquals((long)m.hashCode(), (long)m1.hashCode());
        Assert.assertEquals((Object)m, (Object)m);
        Assert.assertEquals((Object)m, (Object)m1);
        Assert.assertFalse((boolean)m.equals(null));
        Assert.assertFalse((boolean)m.equals((Object)mt));
        Assert.assertFalse((boolean)m.equals((Object)new BlockRealMatrix(this.bigSingular)));
    }

    @Test
    public void testToString() {
        BlockRealMatrix m = new BlockRealMatrix(this.testData);
        Assert.assertEquals((Object)"BlockRealMatrix{{1.0,2.0,3.0},{2.0,5.0,3.0},{1.0,0.0,8.0}}", (Object)m.toString());
    }

    @Test
    public void testSetSubMatrix() {
        BlockRealMatrix m = new BlockRealMatrix(this.testData);
        m.setSubMatrix(this.detData2, 1, 1);
        BlockRealMatrix expected = new BlockRealMatrix((double[][])new double[][]{{1.0, 2.0, 3.0}, {2.0, 1.0, 3.0}, {1.0, 2.0, 4.0}});
        Assert.assertEquals((Object)expected, (Object)m);
        m.setSubMatrix(this.detData2, 0, 0);
        expected = new BlockRealMatrix((double[][])new double[][]{{1.0, 3.0, 3.0}, {2.0, 4.0, 3.0}, {1.0, 2.0, 4.0}});
        Assert.assertEquals((Object)expected, (Object)m);
        m.setSubMatrix(this.testDataPlus2, 0, 0);
        expected = new BlockRealMatrix((double[][])new double[][]{{3.0, 4.0, 5.0}, {4.0, 7.0, 5.0}, {3.0, 2.0, 10.0}});
        Assert.assertEquals((Object)expected, (Object)m);
        BlockRealMatrix matrix = new BlockRealMatrix((double[][])new double[][]{{1.0, 2.0, 3.0, 4.0}, {5.0, 6.0, 7.0, 8.0}, {9.0, 0.0, 1.0, 2.0}});
        matrix.setSubMatrix((double[][])new double[][]{{3.0, 4.0}, {5.0, 6.0}}, 1, 1);
        expected = new BlockRealMatrix((double[][])new double[][]{{1.0, 2.0, 3.0, 4.0}, {5.0, 3.0, 4.0, 8.0}, {9.0, 5.0, 6.0, 2.0}});
        Assert.assertEquals((Object)expected, (Object)matrix);
        try {
            m.setSubMatrix(this.testData, 1, 1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setSubMatrix(this.testData, -1, 1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setSubMatrix(this.testData, 1, -1);
            Assert.fail((String)"expecting OutOfRangeException");
        }
        catch (OutOfRangeException outOfRangeException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((double[][])null, 1, 1);
            Assert.fail((String)"expecting NullArgumentException");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((double[][])new double[][]{{1.0}, {2.0, 3.0}}, 0, 0);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        try {
            m.setSubMatrix((double[][])new double[][]{new double[0]}, 0, 0);
            Assert.fail((String)"expecting MathIllegalArgumentException");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testWalk() {
        int j;
        int i;
        int rows = 150;
        int columns = 75;
        BlockRealMatrix m = new BlockRealMatrix(rows, columns);
        m.walkInRowOrder((RealMatrixChangingVisitor)new SetVisitor());
        GetVisitor getVisitor = new GetVisitor();
        m.walkInOptimizedOrder((RealMatrixPreservingVisitor)getVisitor);
        Assert.assertEquals((long)(rows * columns), (long)getVisitor.getCount());
        m = new BlockRealMatrix(rows, columns);
        m.walkInRowOrder((RealMatrixChangingVisitor)new SetVisitor(), 1, rows - 2, 1, columns - 2);
        getVisitor = new GetVisitor();
        m.walkInOptimizedOrder((RealMatrixPreservingVisitor)getVisitor, 1, rows - 2, 1, columns - 2);
        Assert.assertEquals((long)((rows - 2) * (columns - 2)), (long)getVisitor.getCount());
        for (i = 0; i < rows; ++i) {
            Assert.assertEquals((double)0.0, (double)m.getEntry(i, 0), (double)0.0);
            Assert.assertEquals((double)0.0, (double)m.getEntry(i, columns - 1), (double)0.0);
        }
        for (j = 0; j < columns; ++j) {
            Assert.assertEquals((double)0.0, (double)m.getEntry(0, j), (double)0.0);
            Assert.assertEquals((double)0.0, (double)m.getEntry(rows - 1, j), (double)0.0);
        }
        m = new BlockRealMatrix(rows, columns);
        m.walkInColumnOrder((RealMatrixChangingVisitor)new SetVisitor());
        getVisitor = new GetVisitor();
        m.walkInOptimizedOrder((RealMatrixPreservingVisitor)getVisitor);
        Assert.assertEquals((long)(rows * columns), (long)getVisitor.getCount());
        m = new BlockRealMatrix(rows, columns);
        m.walkInColumnOrder((RealMatrixChangingVisitor)new SetVisitor(), 1, rows - 2, 1, columns - 2);
        getVisitor = new GetVisitor();
        m.walkInOptimizedOrder((RealMatrixPreservingVisitor)getVisitor, 1, rows - 2, 1, columns - 2);
        Assert.assertEquals((long)((rows - 2) * (columns - 2)), (long)getVisitor.getCount());
        for (i = 0; i < rows; ++i) {
            Assert.assertEquals((double)0.0, (double)m.getEntry(i, 0), (double)0.0);
            Assert.assertEquals((double)0.0, (double)m.getEntry(i, columns - 1), (double)0.0);
        }
        for (j = 0; j < columns; ++j) {
            Assert.assertEquals((double)0.0, (double)m.getEntry(0, j), (double)0.0);
            Assert.assertEquals((double)0.0, (double)m.getEntry(rows - 1, j), (double)0.0);
        }
        m = new BlockRealMatrix(rows, columns);
        m.walkInOptimizedOrder((RealMatrixChangingVisitor)new SetVisitor());
        getVisitor = new GetVisitor();
        m.walkInRowOrder((RealMatrixPreservingVisitor)getVisitor);
        Assert.assertEquals((long)(rows * columns), (long)getVisitor.getCount());
        m = new BlockRealMatrix(rows, columns);
        m.walkInOptimizedOrder((RealMatrixChangingVisitor)new SetVisitor(), 1, rows - 2, 1, columns - 2);
        getVisitor = new GetVisitor();
        m.walkInRowOrder((RealMatrixPreservingVisitor)getVisitor, 1, rows - 2, 1, columns - 2);
        Assert.assertEquals((long)((rows - 2) * (columns - 2)), (long)getVisitor.getCount());
        for (i = 0; i < rows; ++i) {
            Assert.assertEquals((double)0.0, (double)m.getEntry(i, 0), (double)0.0);
            Assert.assertEquals((double)0.0, (double)m.getEntry(i, columns - 1), (double)0.0);
        }
        for (j = 0; j < columns; ++j) {
            Assert.assertEquals((double)0.0, (double)m.getEntry(0, j), (double)0.0);
            Assert.assertEquals((double)0.0, (double)m.getEntry(rows - 1, j), (double)0.0);
        }
        m = new BlockRealMatrix(rows, columns);
        m.walkInOptimizedOrder((RealMatrixChangingVisitor)new SetVisitor());
        getVisitor = new GetVisitor();
        m.walkInColumnOrder((RealMatrixPreservingVisitor)getVisitor);
        Assert.assertEquals((long)(rows * columns), (long)getVisitor.getCount());
        m = new BlockRealMatrix(rows, columns);
        m.walkInOptimizedOrder((RealMatrixChangingVisitor)new SetVisitor(), 1, rows - 2, 1, columns - 2);
        getVisitor = new GetVisitor();
        m.walkInColumnOrder((RealMatrixPreservingVisitor)getVisitor, 1, rows - 2, 1, columns - 2);
        Assert.assertEquals((long)((rows - 2) * (columns - 2)), (long)getVisitor.getCount());
        for (i = 0; i < rows; ++i) {
            Assert.assertEquals((double)0.0, (double)m.getEntry(i, 0), (double)0.0);
            Assert.assertEquals((double)0.0, (double)m.getEntry(i, columns - 1), (double)0.0);
        }
        for (j = 0; j < columns; ++j) {
            Assert.assertEquals((double)0.0, (double)m.getEntry(0, j), (double)0.0);
            Assert.assertEquals((double)0.0, (double)m.getEntry(rows - 1, j), (double)0.0);
        }
    }

    @Test
    public void testSerial() {
        BlockRealMatrix m = new BlockRealMatrix(this.testData);
        Assert.assertEquals((Object)m, (Object)TestUtils.serializeAndRecover(m));
    }

    protected void assertClose(RealMatrix m, RealMatrix n, double tolerance) {
        Assert.assertTrue((m.subtract(n).getNorm() < tolerance ? 1 : 0) != 0);
    }

    protected void assertClose(double[] m, double[] n, double tolerance) {
        if (m.length != n.length) {
            Assert.fail((String)"vectors not same length");
        }
        for (int i = 0; i < m.length; ++i) {
            Assert.assertEquals((double)m[i], (double)n[i], (double)tolerance);
        }
    }

    private BlockRealMatrix createRandomMatrix(Random r, int rows, int columns) {
        BlockRealMatrix m = new BlockRealMatrix(rows, columns);
        for (int i = 0; i < rows; ++i) {
            for (int j = 0; j < columns; ++j) {
                m.setEntry(i, j, 200.0 * r.nextDouble() - 100.0);
            }
        }
        return m;
    }

    private static class GetVisitor
    extends DefaultRealMatrixPreservingVisitor {
        private int count = 0;

        private GetVisitor() {
        }

        public void visit(int i, int j, double value) {
            ++this.count;
            Assert.assertEquals((double)((double)i + (double)j / 1024.0), (double)value, (double)0.0);
        }

        public int getCount() {
            return this.count;
        }
    }

    private static class SetVisitor
    extends DefaultRealMatrixChangingVisitor {
        private SetVisitor() {
        }

        public double visit(int i, int j, double value) {
            return (double)i + (double)j / 1024.0;
        }
    }
}

