/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.geometry.spherical.twod;

import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Rotation;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.partitioning.Hyperplane;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.partitioning.Region;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.partitioning.RegionFactory;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.partitioning.Side;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.partitioning.SubHyperplane;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.spherical.oned.Arc;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.spherical.oned.ArcsSet;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.spherical.twod.Circle;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.spherical.twod.SubCircle;
import org.junit.Assert;
import org.junit.Test;

public class SubCircleTest {
    @Test
    public void testFullCircle() {
        Circle circle = new Circle(Vector3D.PLUS_K, 1.0E-10);
        SubCircle set = circle.wholeHyperplane();
        Assert.assertEquals((double)(Math.PI * 2), (double)set.getSize(), (double)1.0E-10);
        Assert.assertTrue((circle == set.getHyperplane() ? 1 : 0) != 0);
        Assert.assertTrue((circle != set.copySelf().getHyperplane() ? 1 : 0) != 0);
    }

    @Test
    public void testSide() {
        Circle xzPlane = new Circle(Vector3D.PLUS_J, 1.0E-10);
        SubCircle sc1 = this.create(Vector3D.PLUS_K, Vector3D.PLUS_I, Vector3D.PLUS_J, 1.0E-10, 1.0, 3.0, 5.0, 6.0);
        Assert.assertEquals((Object)Side.BOTH, (Object)sc1.split((Hyperplane)xzPlane).getSide());
        SubCircle sc2 = this.create(Vector3D.PLUS_K, Vector3D.PLUS_I, Vector3D.PLUS_J, 1.0E-10, 1.0, 3.0);
        Assert.assertEquals((Object)Side.MINUS, (Object)sc2.split((Hyperplane)xzPlane).getSide());
        SubCircle sc3 = this.create(Vector3D.PLUS_K, Vector3D.PLUS_I, Vector3D.PLUS_J, 1.0E-10, 5.0, 6.0);
        Assert.assertEquals((Object)Side.PLUS, (Object)sc3.split((Hyperplane)xzPlane).getSide());
        SubCircle sc4 = this.create(Vector3D.PLUS_J, Vector3D.PLUS_K, Vector3D.PLUS_I, 1.0E-10, 5.0, 6.0);
        Assert.assertEquals((Object)Side.HYPER, (Object)sc4.split((Hyperplane)xzPlane).getSide());
        SubCircle sc5 = this.create(Vector3D.MINUS_J, Vector3D.PLUS_I, Vector3D.PLUS_K, 1.0E-10, 5.0, 6.0);
        Assert.assertEquals((Object)Side.HYPER, (Object)sc5.split((Hyperplane)xzPlane).getSide());
    }

    @Test
    public void testSPlit() {
        Circle xzPlane = new Circle(Vector3D.PLUS_J, 1.0E-10);
        SubCircle sc1 = this.create(Vector3D.PLUS_K, Vector3D.PLUS_I, Vector3D.PLUS_J, 1.0E-10, 1.0, 3.0, 5.0, 6.0);
        SubHyperplane.SplitSubHyperplane split1 = sc1.split((Hyperplane)xzPlane);
        ArcsSet plus1 = (ArcsSet)((SubCircle)split1.getPlus()).getRemainingRegion();
        ArcsSet minus1 = (ArcsSet)((SubCircle)split1.getMinus()).getRemainingRegion();
        Assert.assertEquals((long)1L, (long)plus1.asList().size());
        Assert.assertEquals((double)5.0, (double)((Arc)plus1.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)6.0, (double)((Arc)plus1.asList().get(0)).getSup(), (double)1.0E-10);
        Assert.assertEquals((long)1L, (long)minus1.asList().size());
        Assert.assertEquals((double)1.0, (double)((Arc)minus1.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)((Arc)minus1.asList().get(0)).getSup(), (double)1.0E-10);
        SubCircle sc2 = this.create(Vector3D.PLUS_K, Vector3D.PLUS_I, Vector3D.PLUS_J, 1.0E-10, 1.0, 3.0);
        SubHyperplane.SplitSubHyperplane split2 = sc2.split((Hyperplane)xzPlane);
        Assert.assertNull((Object)split2.getPlus());
        ArcsSet minus2 = (ArcsSet)((SubCircle)split2.getMinus()).getRemainingRegion();
        Assert.assertEquals((long)1L, (long)minus2.asList().size());
        Assert.assertEquals((double)1.0, (double)((Arc)minus2.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)3.0, (double)((Arc)minus2.asList().get(0)).getSup(), (double)1.0E-10);
        SubCircle sc3 = this.create(Vector3D.PLUS_K, Vector3D.PLUS_I, Vector3D.PLUS_J, 1.0E-10, 5.0, 6.0);
        SubHyperplane.SplitSubHyperplane split3 = sc3.split((Hyperplane)xzPlane);
        ArcsSet plus3 = (ArcsSet)((SubCircle)split3.getPlus()).getRemainingRegion();
        Assert.assertEquals((long)1L, (long)plus3.asList().size());
        Assert.assertEquals((double)5.0, (double)((Arc)plus3.asList().get(0)).getInf(), (double)1.0E-10);
        Assert.assertEquals((double)6.0, (double)((Arc)plus3.asList().get(0)).getSup(), (double)1.0E-10);
        Assert.assertNull((Object)split3.getMinus());
        SubCircle sc4 = this.create(Vector3D.PLUS_J, Vector3D.PLUS_K, Vector3D.PLUS_I, 1.0E-10, 5.0, 6.0);
        SubHyperplane.SplitSubHyperplane split4 = sc4.split((Hyperplane)xzPlane);
        Assert.assertEquals((Object)Side.HYPER, (Object)sc4.split((Hyperplane)xzPlane).getSide());
        Assert.assertNull((Object)split4.getPlus());
        Assert.assertNull((Object)split4.getMinus());
        SubCircle sc5 = this.create(Vector3D.MINUS_J, Vector3D.PLUS_I, Vector3D.PLUS_K, 1.0E-10, 5.0, 6.0);
        SubHyperplane.SplitSubHyperplane split5 = sc5.split((Hyperplane)xzPlane);
        Assert.assertEquals((Object)Side.HYPER, (Object)sc5.split((Hyperplane)xzPlane).getSide());
        Assert.assertNull((Object)split5.getPlus());
        Assert.assertNull((Object)split5.getMinus());
    }

    @Test
    public void testSideSplitConsistency() {
        double tolerance = 1.0E-6;
        Circle hyperplane = new Circle(new Vector3D(9.738804529764676E-5, -0.6772824575010357, -0.7357230887208355), tolerance);
        SubCircle sub = new SubCircle((Hyperplane)new Circle(new Vector3D(2.1793884139073498E-4, 0.9790647032675541, -0.20354915700704285), tolerance), (Region)new ArcsSet(4.71214416841707, 4.712538663500476, tolerance));
        SubHyperplane.SplitSubHyperplane split = sub.split((Hyperplane)hyperplane);
        Assert.assertNotNull((Object)split.getMinus());
        Assert.assertNull((Object)split.getPlus());
        Assert.assertEquals((Object)Side.MINUS, (Object)sub.split((Hyperplane)hyperplane).getSide());
    }

    private SubCircle create(Vector3D pole, Vector3D x, Vector3D y, double tolerance, double ... limits) {
        RegionFactory factory = new RegionFactory();
        Circle circle = new Circle(pole, tolerance);
        Circle phased = (Circle)Circle.getTransform((Rotation)new Rotation(circle.getXAxis(), circle.getYAxis(), x, y)).apply((Hyperplane)circle);
        ArcsSet set = (ArcsSet)factory.getComplement((Region)new ArcsSet(tolerance));
        for (int i = 0; i < limits.length; i += 2) {
            set = (ArcsSet)factory.union((Region)set, (Region)new ArcsSet(limits[i], limits[i + 1], tolerance));
        }
        return new SubCircle((Hyperplane)phased, (Region)set);
    }
}

