/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.geometry.partitioning.utilities;

import com.hazelcast.shaded.org.apache.commons.math3.geometry.partitioning.utilities.AVLTree;
import org.junit.Assert;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class AVLTreeTest {
    @Test
    public void testInsert() {
        int[] array = new int[]{16, 13, 15, 14, 2, 0, 12, 9, 8, 5, 11, 18, 19, 17, 4, 7, 1, 3, 6, 10};
        AVLTree<Integer> tree = this.buildTree(array);
        Assert.assertEquals((long)array.length, (long)tree.size());
        for (int i = 0; i < array.length; ++i) {
            Assert.assertEquals((long)array[i], (long)this.value(tree.getNotSmaller((Comparable)new Integer(array[i]))));
        }
        this.checkOrder(tree);
    }

    @Test
    public void testDelete1() {
        int[][][] arrays = new int[][][]{new int[][]{{16, 13, 15, 14, 2, 0, 12, 9, 8, 5, 11, 18, 19, 17, 4, 7, 1, 3, 6, 10}, {11, 10, 9, 12, 16, 15, 13, 18, 5, 0, 3, 2, 14, 6, 19, 17, 8, 4, 7, 1}}, new int[][]{{16, 13, 15, 14, 2, 0, 12, 9, 8, 5, 11, 18, 19, 17, 4, 7, 1, 3, 6, 10}, {0, 17, 14, 15, 16, 18, 6}}, new int[][]{{6, 2, 7, 8, 1, 4, 3, 5}, {8}}, new int[][]{{6, 2, 7, 8, 1, 4, 5}, {8}}, new int[][]{{3, 7, 2, 1, 5, 8, 4}, {1}}, new int[][]{{3, 7, 2, 1, 5, 8, 6}, {1}}};
        for (int i = 0; i < arrays.length; ++i) {
            AVLTree<Integer> tree = this.buildTree(arrays[i][0]);
            Assert.assertTrue((!tree.delete((Comparable)new Integer(-2000)) ? 1 : 0) != 0);
            for (int j = 0; j < arrays[i][1].length; ++j) {
                Assert.assertTrue((boolean)tree.delete(tree.getNotSmaller((Comparable)new Integer(arrays[i][1][j])).getElement()));
                Assert.assertEquals((long)(arrays[i][0].length - j - 1), (long)tree.size());
            }
        }
    }

    @Test
    public void testNavigation() {
        int i;
        int[] array = new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
        AVLTree<Integer> tree = this.buildTree(array);
        AVLTree.Node node = tree.getSmallest();
        Assert.assertEquals((long)array[0], (long)this.value(node));
        for (i = 0; i < array.length; ++i) {
            Assert.assertEquals((long)array[i], (long)this.value(node));
            node = node.getNext();
        }
        Assert.assertNull((Object)node);
        node = tree.getLargest();
        Assert.assertEquals((long)array[array.length - 1], (long)this.value(node));
        for (i = array.length - 1; i >= 0; --i) {
            Assert.assertEquals((long)array[i], (long)this.value(node));
            node = node.getPrevious();
        }
        Assert.assertNull((Object)node);
        this.checkOrder(tree);
    }

    @Test
    public void testSearch() {
        int[] array = new int[]{2, 4, 6, 8, 10, 12, 14};
        AVLTree<Integer> tree = this.buildTree(array);
        Assert.assertNull((Object)tree.getNotLarger((Comparable)new Integer(array[0] - 1)));
        Assert.assertNull((Object)tree.getNotSmaller((Comparable)new Integer(array[array.length - 1] + 1)));
        for (int i = 0; i < array.length; ++i) {
            Assert.assertEquals((long)array[i], (long)this.value(tree.getNotSmaller((Comparable)new Integer(array[i] - 1))));
            Assert.assertEquals((long)array[i], (long)this.value(tree.getNotLarger((Comparable)new Integer(array[i] + 1))));
        }
        this.checkOrder(tree);
    }

    @Test
    public void testRepetition() {
        int[] array = new int[]{1, 1, 3, 3, 4, 5, 6, 7, 7, 7, 7, 7};
        AVLTree<Integer> tree = this.buildTree(array);
        Assert.assertEquals((long)array.length, (long)tree.size());
        AVLTree.Node node = tree.getNotSmaller((Comparable)new Integer(3));
        Assert.assertEquals((long)3L, (long)this.value(node));
        Assert.assertEquals((long)1L, (long)this.value(node.getPrevious()));
        Assert.assertEquals((long)3L, (long)this.value(node.getNext()));
        Assert.assertEquals((long)4L, (long)this.value(node.getNext().getNext()));
        node = tree.getNotLarger((Comparable)new Integer(2));
        Assert.assertEquals((long)1L, (long)this.value(node));
        Assert.assertEquals((long)1L, (long)this.value(node.getPrevious()));
        Assert.assertEquals((long)3L, (long)this.value(node.getNext()));
        Assert.assertNull((Object)node.getPrevious().getPrevious());
        AVLTree.Node otherNode = tree.getNotSmaller((Comparable)new Integer(1));
        Assert.assertTrue((node != otherNode ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)this.value(otherNode));
        Assert.assertNull((Object)otherNode.getPrevious());
        node = tree.getNotLarger((Comparable)new Integer(10));
        Assert.assertEquals((long)7L, (long)this.value(node));
        Assert.assertNull((Object)node.getNext());
        node = node.getPrevious();
        Assert.assertEquals((long)7L, (long)this.value(node));
        node = node.getPrevious();
        Assert.assertEquals((long)7L, (long)this.value(node));
        node = node.getPrevious();
        Assert.assertEquals((long)7L, (long)this.value(node));
        node = node.getPrevious();
        Assert.assertEquals((long)7L, (long)this.value(node));
        node = node.getPrevious();
        Assert.assertEquals((long)6L, (long)this.value(node));
        this.checkOrder(tree);
    }

    private AVLTree<Integer> buildTree(int[] array) {
        AVLTree tree = new AVLTree();
        for (int i = 0; i < array.length; ++i) {
            tree.insert((Comparable)new Integer(array[i]));
            tree.insert(null);
        }
        return tree;
    }

    private int value(AVLTree.Node node) {
        return (Integer)node.getElement();
    }

    private void checkOrder(AVLTree<Integer> tree) {
        AVLTree.Node next = null;
        AVLTree.Node node = tree.getSmallest();
        while (node != null) {
            next = node.getNext();
            if (next != null) {
                Assert.assertTrue((((Integer)node.getElement()).compareTo((Integer)next.getElement()) <= 0 ? 1 : 0) != 0);
            }
            node = next;
        }
    }
}

