/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.geometry.partitioning;

import com.hazelcast.shaded.org.apache.commons.math3.geometry.Space;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.oned.Euclidean1D;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.oned.IntervalsSet;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.oned.OrientedPoint;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.oned.Vector1D;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Euclidean3D;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Plane;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.PolyhedronsSet;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.twod.Euclidean2D;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.twod.Line;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.twod.PolygonsSet;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.partitioning.BSPTree;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.partitioning.Hyperplane;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.spherical.oned.ArcsSet;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.spherical.oned.LimitAngle;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.spherical.oned.S1Point;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.spherical.oned.Sphere1D;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.spherical.twod.Circle;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.spherical.twod.Sphere2D;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.spherical.twod.SphericalPolygonsSet;
import java.io.IOException;
import java.text.ParseException;
import java.util.StringTokenizer;

public class RegionParser {
    private RegionParser() {
    }

    public static ArcsSet parseArcsSet(String s) throws IOException, ParseException {
        TreeBuilder<Sphere1D> builder = new TreeBuilder<Sphere1D>("ArcsSet", s){

            protected LimitAngle parseHyperplane() throws IOException, ParseException {
                return new LimitAngle(new S1Point(this.getNumber()), this.getBoolean(), this.getNumber());
            }
        };
        return new ArcsSet(builder.getTree(), builder.getTolerance());
    }

    public static SphericalPolygonsSet parseSphericalPolygonsSet(String s) throws IOException, ParseException {
        TreeBuilder<Sphere2D> builder = new TreeBuilder<Sphere2D>("SphericalPolygonsSet", s){

            public Circle parseHyperplane() throws IOException, ParseException {
                return new Circle(new Vector3D(this.getNumber(), this.getNumber(), this.getNumber()), this.getNumber());
            }
        };
        return new SphericalPolygonsSet(builder.getTree(), builder.getTolerance());
    }

    public static IntervalsSet parseIntervalsSet(String s) throws IOException, ParseException {
        TreeBuilder<Euclidean1D> builder = new TreeBuilder<Euclidean1D>("IntervalsSet", s){

            public OrientedPoint parseHyperplane() throws IOException, ParseException {
                return new OrientedPoint(new Vector1D(this.getNumber()), this.getBoolean(), this.getNumber());
            }
        };
        return new IntervalsSet(builder.getTree(), builder.getTolerance());
    }

    public static PolygonsSet parsePolygonsSet(String s) throws IOException, ParseException {
        TreeBuilder<Euclidean2D> builder = new TreeBuilder<Euclidean2D>("PolygonsSet", s){

            public Line parseHyperplane() throws IOException, ParseException {
                return new Line(new Vector2D(this.getNumber(), this.getNumber()), this.getNumber(), this.getNumber());
            }
        };
        return new PolygonsSet(builder.getTree(), builder.getTolerance());
    }

    public static PolyhedronsSet parsePolyhedronsSet(String s) throws IOException, ParseException {
        TreeBuilder<Euclidean3D> builder = new TreeBuilder<Euclidean3D>("PolyhedronsSet", s){

            public Plane parseHyperplane() throws IOException, ParseException {
                return new Plane(new Vector3D(this.getNumber(), this.getNumber(), this.getNumber()), new Vector3D(this.getNumber(), this.getNumber(), this.getNumber()), this.getNumber());
            }
        };
        return new PolyhedronsSet(builder.getTree(), builder.getTolerance());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static abstract class TreeBuilder<S extends Space> {
        private static final String TOLERANCE = "tolerance";
        private static final String INTERNAL = "internal";
        private static final String LEAF = "leaf";
        private static final String PLUS = "plus";
        private static final String MINUS = "minus";
        private static final String TRUE = "true";
        private static final String FALSE = "false";
        private BSPTree<S> root = null;
        private final double tolerance;
        private final StringTokenizer tokenizer;

        public TreeBuilder(String type, String s) throws IOException, ParseException {
            this.tokenizer = new StringTokenizer(s);
            this.getWord(type);
            this.getWord(TOLERANCE);
            this.tolerance = this.getNumber();
            this.getWord(PLUS);
            this.root = new BSPTree();
            this.parseTree(this.root);
            if (this.tokenizer.hasMoreTokens()) {
                throw new ParseException("unexpected " + this.tokenizer.nextToken(), 0);
            }
        }

        private void parseTree(BSPTree<S> node) throws IOException, ParseException {
            if (INTERNAL.equals(this.getWord(INTERNAL, LEAF))) {
                node.insertCut(this.parseHyperplane());
                this.getWord(MINUS);
                this.parseTree(node.getMinus());
                this.getWord(PLUS);
                this.parseTree(node.getPlus());
            } else {
                node.setAttribute((Object)this.getBoolean());
            }
        }

        protected String getWord(String ... allowed) throws IOException, ParseException {
            String token = this.tokenizer.nextToken();
            for (String a : allowed) {
                if (!a.equals(token)) continue;
                return token;
            }
            throw new ParseException(token + " != " + allowed[0], 0);
        }

        protected double getNumber() throws IOException, NumberFormatException {
            return Double.parseDouble(this.tokenizer.nextToken());
        }

        protected boolean getBoolean() throws IOException, ParseException {
            return this.getWord(TRUE, FALSE).equals(TRUE);
        }

        public BSPTree<S> getTree() {
            return this.root;
        }

        public double getTolerance() {
            return this.tolerance;
        }

        protected abstract Hyperplane<S> parseHyperplane() throws IOException, ParseException;
    }
}

