/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.Vector;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.oned.IntervalsSet;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Line;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Segment;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.SubLine;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.partitioning.Region;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.partitioning.RegionFactory;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class SubLineTest {
    @Test
    public void testEndPoints() throws MathIllegalArgumentException {
        Vector3D p1 = new Vector3D(-1.0, -7.0, 2.0);
        Vector3D p2 = new Vector3D(7.0, -1.0, 0.0);
        Segment segment = new Segment(p1, p2, new Line(p1, p2, 1.0E-10));
        SubLine sub = new SubLine(segment);
        List segments = sub.getSegments();
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertEquals((double)0.0, (double)new Vector3D(-1.0, -7.0, 2.0).distance((Vector)((Segment)segments.get(0)).getStart()), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)new Vector3D(7.0, -1.0, 0.0).distance((Vector)((Segment)segments.get(0)).getEnd()), (double)1.0E-10);
    }

    @Test
    public void testNoEndPoints() throws MathIllegalArgumentException {
        SubLine wholeLine = new Line(new Vector3D(-1.0, 7.0, 2.0), new Vector3D(7.0, 1.0, 0.0), 1.0E-10).wholeLine();
        List segments = wholeLine.getSegments();
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getStart().getX()) && ((Segment)segments.get(0)).getStart().getX() < 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getStart().getY()) && ((Segment)segments.get(0)).getStart().getY() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getStart().getZ()) && ((Segment)segments.get(0)).getStart().getZ() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getEnd().getX()) && ((Segment)segments.get(0)).getEnd().getX() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getEnd().getY()) && ((Segment)segments.get(0)).getEnd().getY() < 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getEnd().getZ()) && ((Segment)segments.get(0)).getEnd().getZ() < 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testNoSegments() throws MathIllegalArgumentException {
        SubLine empty = new SubLine(new Line(new Vector3D(-1.0, -7.0, 2.0), new Vector3D(7.0, -1.0, 0.0), 1.0E-10), (IntervalsSet)new RegionFactory().getComplement((Region)new IntervalsSet(1.0E-10)));
        List segments = empty.getSegments();
        Assert.assertEquals((long)0L, (long)segments.size());
    }

    @Test
    public void testSeveralSegments() throws MathIllegalArgumentException {
        SubLine twoSubs = new SubLine(new Line(new Vector3D(-1.0, -7.0, 2.0), new Vector3D(7.0, -1.0, 0.0), 1.0E-10), (IntervalsSet)new RegionFactory().union((Region)new IntervalsSet(1.0, 2.0, 1.0E-10), (Region)new IntervalsSet(3.0, 4.0, 1.0E-10)));
        List segments = twoSubs.getSegments();
        Assert.assertEquals((long)2L, (long)segments.size());
    }

    @Test
    public void testHalfInfiniteNeg() throws MathIllegalArgumentException {
        SubLine empty = new SubLine(new Line(new Vector3D(-1.0, -7.0, 2.0), new Vector3D(7.0, -1.0, -2.0), 1.0E-10), new IntervalsSet(Double.NEGATIVE_INFINITY, 0.0, 1.0E-10));
        List segments = empty.getSegments();
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getStart().getX()) && ((Segment)segments.get(0)).getStart().getX() < 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getStart().getY()) && ((Segment)segments.get(0)).getStart().getY() < 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getStart().getZ()) && ((Segment)segments.get(0)).getStart().getZ() > 0.0 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)new Vector3D(3.0, -4.0, 0.0).distance((Vector)((Segment)segments.get(0)).getEnd()), (double)1.0E-10);
    }

    @Test
    public void testHalfInfinitePos() throws MathIllegalArgumentException {
        SubLine empty = new SubLine(new Line(new Vector3D(-1.0, -7.0, 2.0), new Vector3D(7.0, -1.0, -2.0), 1.0E-10), new IntervalsSet(0.0, Double.POSITIVE_INFINITY, 1.0E-10));
        List segments = empty.getSegments();
        Assert.assertEquals((long)1L, (long)segments.size());
        Assert.assertEquals((double)0.0, (double)new Vector3D(3.0, -4.0, 0.0).distance((Vector)((Segment)segments.get(0)).getStart()), (double)1.0E-10);
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getEnd().getX()) && ((Segment)segments.get(0)).getEnd().getX() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getEnd().getY()) && ((Segment)segments.get(0)).getEnd().getY() > 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((Double.isInfinite(((Segment)segments.get(0)).getEnd().getZ()) && ((Segment)segments.get(0)).getEnd().getZ() < 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testIntersectionInsideInside() throws MathIllegalArgumentException {
        SubLine sub1 = new SubLine(new Vector3D(1.0, 1.0, 1.0), new Vector3D(3.0, 1.0, 1.0), 1.0E-10);
        SubLine sub2 = new SubLine(new Vector3D(2.0, 0.0, 0.0), new Vector3D(2.0, 2.0, 2.0), 1.0E-10);
        Assert.assertEquals((double)0.0, (double)new Vector3D(2.0, 1.0, 1.0).distance((Vector)sub1.intersection(sub2, true)), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)new Vector3D(2.0, 1.0, 1.0).distance((Vector)sub1.intersection(sub2, false)), (double)1.0E-12);
    }

    @Test
    public void testIntersectionInsideBoundary() throws MathIllegalArgumentException {
        SubLine sub1 = new SubLine(new Vector3D(1.0, 1.0, 1.0), new Vector3D(3.0, 1.0, 1.0), 1.0E-10);
        SubLine sub2 = new SubLine(new Vector3D(2.0, 0.0, 0.0), new Vector3D(2.0, 1.0, 1.0), 1.0E-10);
        Assert.assertEquals((double)0.0, (double)new Vector3D(2.0, 1.0, 1.0).distance((Vector)sub1.intersection(sub2, true)), (double)1.0E-12);
        Assert.assertNull((Object)sub1.intersection(sub2, false));
    }

    @Test
    public void testIntersectionInsideOutside() throws MathIllegalArgumentException {
        SubLine sub1 = new SubLine(new Vector3D(1.0, 1.0, 1.0), new Vector3D(3.0, 1.0, 1.0), 1.0E-10);
        SubLine sub2 = new SubLine(new Vector3D(2.0, 0.0, 0.0), new Vector3D(2.0, 0.5, 0.5), 1.0E-10);
        Assert.assertNull((Object)sub1.intersection(sub2, true));
        Assert.assertNull((Object)sub1.intersection(sub2, false));
    }

    @Test
    public void testIntersectionBoundaryBoundary() throws MathIllegalArgumentException {
        SubLine sub1 = new SubLine(new Vector3D(1.0, 1.0, 1.0), new Vector3D(2.0, 1.0, 1.0), 1.0E-10);
        SubLine sub2 = new SubLine(new Vector3D(2.0, 0.0, 0.0), new Vector3D(2.0, 1.0, 1.0), 1.0E-10);
        Assert.assertEquals((double)0.0, (double)new Vector3D(2.0, 1.0, 1.0).distance((Vector)sub1.intersection(sub2, true)), (double)1.0E-12);
        Assert.assertNull((Object)sub1.intersection(sub2, false));
    }

    @Test
    public void testIntersectionBoundaryOutside() throws MathIllegalArgumentException {
        SubLine sub1 = new SubLine(new Vector3D(1.0, 1.0, 1.0), new Vector3D(2.0, 1.0, 1.0), 1.0E-10);
        SubLine sub2 = new SubLine(new Vector3D(2.0, 0.0, 0.0), new Vector3D(2.0, 0.5, 0.5), 1.0E-10);
        Assert.assertNull((Object)sub1.intersection(sub2, true));
        Assert.assertNull((Object)sub1.intersection(sub2, false));
    }

    @Test
    public void testIntersectionOutsideOutside() throws MathIllegalArgumentException {
        SubLine sub1 = new SubLine(new Vector3D(1.0, 1.0, 1.0), new Vector3D(1.5, 1.0, 1.0), 1.0E-10);
        SubLine sub2 = new SubLine(new Vector3D(2.0, 0.0, 0.0), new Vector3D(2.0, 0.5, 0.5), 1.0E-10);
        Assert.assertNull((Object)sub1.intersection(sub2, true));
        Assert.assertNull((Object)sub1.intersection(sub2, false));
    }

    @Test
    public void testIntersectionNotIntersecting() throws MathIllegalArgumentException {
        SubLine sub1 = new SubLine(new Vector3D(1.0, 1.0, 1.0), new Vector3D(1.5, 1.0, 1.0), 1.0E-10);
        SubLine sub2 = new SubLine(new Vector3D(2.0, 3.0, 0.0), new Vector3D(2.0, 3.0, 0.5), 1.0E-10);
        Assert.assertNull((Object)sub1.intersection(sub2, true));
        Assert.assertNull((Object)sub1.intersection(sub2, false));
    }
}

