/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.Vector;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.SphericalCoordinates;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class SphericalCoordinatesTest {
    @Test
    public void testCoordinatesStoC() throws DimensionMismatchException {
        double piO2 = 1.5707963267948966;
        SphericalCoordinates sc1 = new SphericalCoordinates(2.0, 0.0, piO2);
        Assert.assertEquals((double)0.0, (double)sc1.getCartesian().distance((Vector)new Vector3D(2.0, 0.0, 0.0)), (double)1.0E-10);
        SphericalCoordinates sc2 = new SphericalCoordinates(2.0, piO2, piO2);
        Assert.assertEquals((double)0.0, (double)sc2.getCartesian().distance((Vector)new Vector3D(0.0, 2.0, 0.0)), (double)1.0E-10);
        SphericalCoordinates sc3 = new SphericalCoordinates(2.0, Math.PI, piO2);
        Assert.assertEquals((double)0.0, (double)sc3.getCartesian().distance((Vector)new Vector3D(-2.0, 0.0, 0.0)), (double)1.0E-10);
        SphericalCoordinates sc4 = new SphericalCoordinates(2.0, -piO2, piO2);
        Assert.assertEquals((double)0.0, (double)sc4.getCartesian().distance((Vector)new Vector3D(0.0, -2.0, 0.0)), (double)1.0E-10);
        SphericalCoordinates sc5 = new SphericalCoordinates(2.0, 1.23456, 0.0);
        Assert.assertEquals((double)0.0, (double)sc5.getCartesian().distance((Vector)new Vector3D(0.0, 0.0, 2.0)), (double)1.0E-10);
        SphericalCoordinates sc6 = new SphericalCoordinates(2.0, 6.54321, Math.PI);
        Assert.assertEquals((double)0.0, (double)sc6.getCartesian().distance((Vector)new Vector3D(0.0, 0.0, -2.0)), (double)1.0E-10);
    }

    @Test
    public void testCoordinatesCtoS() throws DimensionMismatchException {
        double piO2 = 1.5707963267948966;
        SphericalCoordinates sc1 = new SphericalCoordinates(new Vector3D(2.0, 0.0, 0.0));
        Assert.assertEquals((double)2.0, (double)sc1.getR(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)sc1.getTheta(), (double)1.0E-10);
        Assert.assertEquals((double)piO2, (double)sc1.getPhi(), (double)1.0E-10);
        SphericalCoordinates sc2 = new SphericalCoordinates(new Vector3D(0.0, 2.0, 0.0));
        Assert.assertEquals((double)2.0, (double)sc2.getR(), (double)1.0E-10);
        Assert.assertEquals((double)piO2, (double)sc2.getTheta(), (double)1.0E-10);
        Assert.assertEquals((double)piO2, (double)sc2.getPhi(), (double)1.0E-10);
        SphericalCoordinates sc3 = new SphericalCoordinates(new Vector3D(-2.0, 0.0, 0.0));
        Assert.assertEquals((double)2.0, (double)sc3.getR(), (double)1.0E-10);
        Assert.assertEquals((double)Math.PI, (double)sc3.getTheta(), (double)1.0E-10);
        Assert.assertEquals((double)piO2, (double)sc3.getPhi(), (double)1.0E-10);
        SphericalCoordinates sc4 = new SphericalCoordinates(new Vector3D(0.0, -2.0, 0.0));
        Assert.assertEquals((double)2.0, (double)sc4.getR(), (double)1.0E-10);
        Assert.assertEquals((double)(-piO2), (double)sc4.getTheta(), (double)1.0E-10);
        Assert.assertEquals((double)piO2, (double)sc4.getPhi(), (double)1.0E-10);
        SphericalCoordinates sc5 = new SphericalCoordinates(new Vector3D(0.0, 0.0, 2.0));
        Assert.assertEquals((double)2.0, (double)sc5.getR(), (double)1.0E-10);
        Assert.assertEquals((double)0.0, (double)sc5.getPhi(), (double)1.0E-10);
        SphericalCoordinates sc6 = new SphericalCoordinates(new Vector3D(0.0, 0.0, -2.0));
        Assert.assertEquals((double)2.0, (double)sc6.getR(), (double)1.0E-10);
        Assert.assertEquals((double)Math.PI, (double)sc6.getPhi(), (double)1.0E-10);
    }

    @Test
    public void testGradient() {
        for (double r = 0.2; r < 10.0; r += 0.5) {
            for (double theta = 0.0; theta < Math.PI * 2; theta += 0.1) {
                for (double phi = 0.1; phi < Math.PI; phi += 0.1) {
                    SphericalCoordinates sc = new SphericalCoordinates(r, theta, phi);
                    DerivativeStructure svalue = this.valueSpherical(new DerivativeStructure(3, 1, 0, r), new DerivativeStructure(3, 1, 1, theta), new DerivativeStructure(3, 1, 2, phi));
                    double[] sGradient = new double[]{svalue.getPartialDerivative(new int[]{1, 0, 0}), svalue.getPartialDerivative(new int[]{0, 1, 0}), svalue.getPartialDerivative(new int[]{0, 0, 1})};
                    DerivativeStructure cvalue = this.valueCartesian(new DerivativeStructure(3, 1, 0, sc.getCartesian().getX()), new DerivativeStructure(3, 1, 1, sc.getCartesian().getY()), new DerivativeStructure(3, 1, 2, sc.getCartesian().getZ()));
                    Vector3D refCGradient = new Vector3D(cvalue.getPartialDerivative(new int[]{1, 0, 0}), cvalue.getPartialDerivative(new int[]{0, 1, 0}), cvalue.getPartialDerivative(new int[]{0, 0, 1}));
                    Vector3D testCGradient = new Vector3D(sc.toCartesianGradient(sGradient));
                    Assert.assertEquals((double)0.0, (double)(testCGradient.distance((Vector)refCGradient) / refCGradient.getNorm()), (double)5.0E-14);
                }
            }
        }
    }

    @Test
    public void testHessian() {
        for (double r = 0.2; r < 10.0; r += 0.5) {
            for (double theta = 0.0; theta < Math.PI * 2; theta += 0.2) {
                for (double phi = 0.1; phi < Math.PI; phi += 0.2) {
                    SphericalCoordinates sc = new SphericalCoordinates(r, theta, phi);
                    DerivativeStructure svalue = this.valueSpherical(new DerivativeStructure(3, 2, 0, r), new DerivativeStructure(3, 2, 1, theta), new DerivativeStructure(3, 2, 2, phi));
                    double[] sGradient = new double[]{svalue.getPartialDerivative(new int[]{1, 0, 0}), svalue.getPartialDerivative(new int[]{0, 1, 0}), svalue.getPartialDerivative(new int[]{0, 0, 1})};
                    double[][] sHessian = new double[3][3];
                    sHessian[0][0] = svalue.getPartialDerivative(new int[]{2, 0, 0});
                    sHessian[1][0] = svalue.getPartialDerivative(new int[]{1, 1, 0});
                    sHessian[2][0] = svalue.getPartialDerivative(new int[]{1, 0, 1});
                    sHessian[0][1] = Double.NaN;
                    sHessian[1][1] = svalue.getPartialDerivative(new int[]{0, 2, 0});
                    sHessian[2][1] = svalue.getPartialDerivative(new int[]{0, 1, 1});
                    sHessian[0][2] = Double.NaN;
                    sHessian[1][2] = Double.NaN;
                    sHessian[2][2] = svalue.getPartialDerivative(new int[]{0, 0, 2});
                    DerivativeStructure cvalue = this.valueCartesian(new DerivativeStructure(3, 2, 0, sc.getCartesian().getX()), new DerivativeStructure(3, 2, 1, sc.getCartesian().getY()), new DerivativeStructure(3, 2, 2, sc.getCartesian().getZ()));
                    double[][] refCHessian = new double[3][3];
                    refCHessian[0][0] = cvalue.getPartialDerivative(new int[]{2, 0, 0});
                    refCHessian[1][0] = cvalue.getPartialDerivative(new int[]{1, 1, 0});
                    refCHessian[2][0] = cvalue.getPartialDerivative(new int[]{1, 0, 1});
                    refCHessian[0][1] = refCHessian[1][0];
                    refCHessian[1][1] = cvalue.getPartialDerivative(new int[]{0, 2, 0});
                    refCHessian[2][1] = cvalue.getPartialDerivative(new int[]{0, 1, 1});
                    refCHessian[0][2] = refCHessian[2][0];
                    refCHessian[1][2] = refCHessian[2][1];
                    refCHessian[2][2] = cvalue.getPartialDerivative(new int[]{0, 0, 2});
                    double norm = 0.0;
                    for (int i = 0; i < 3; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            norm = FastMath.max((double)norm, (double)FastMath.abs((double)refCHessian[i][j]));
                        }
                    }
                    double[][] testCHessian = sc.toCartesianHessian(sHessian, sGradient);
                    for (int i = 0; i < 3; ++i) {
                        for (int j = 0; j < 3; ++j) {
                            Assert.assertEquals((String)("" + FastMath.abs((double)((refCHessian[i][j] - testCHessian[i][j]) / norm))), (double)refCHessian[i][j], (double)testCHessian[i][j], (double)(1.0E-14 * norm));
                        }
                    }
                }
            }
        }
    }

    public DerivativeStructure valueCartesian(DerivativeStructure x, DerivativeStructure y, DerivativeStructure z) {
        return x.divide(y.multiply(5).add(10.0)).multiply(z.pow(3));
    }

    public DerivativeStructure valueSpherical(DerivativeStructure r, DerivativeStructure theta, DerivativeStructure phi) {
        return this.valueCartesian(r.multiply(theta.cos()).multiply(phi.sin()), r.multiply(theta.sin()).multiply(phi.sin()), r.multiply(phi.cos()));
    }

    @Test
    public void testSerialization() {
        SphericalCoordinates a = new SphericalCoordinates(3.0, 2.0, 1.0);
        SphericalCoordinates b = (SphericalCoordinates)TestUtils.serializeAndRecover(a);
        Assert.assertEquals((double)0.0, (double)a.getCartesian().distance((Vector)b.getCartesian()), (double)1.0E-10);
        Assert.assertEquals((double)a.getR(), (double)b.getR(), (double)1.0E-10);
        Assert.assertEquals((double)a.getTheta(), (double)b.getTheta(), (double)1.0E-10);
        Assert.assertEquals((double)a.getPhi(), (double)b.getPhi(), (double)1.0E-10);
    }
}

