/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.genetics;

import com.hazelcast.shaded.org.apache.commons.math3.exception.NotPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.BinaryChromosome;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.Chromosome;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.DummyBinaryChromosome;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.ListPopulation;
import com.hazelcast.shaded.org.apache.commons.math3.genetics.Population;
import java.util.ArrayList;
import java.util.Iterator;
import org.junit.Assert;
import org.junit.Test;

public class ListPopulationTest {
    @Test
    public void testGetFittestChromosome() {
        Chromosome c1 = new Chromosome(){

            public double fitness() {
                return 0.0;
            }
        };
        Chromosome c2 = new Chromosome(){

            public double fitness() {
                return 10.0;
            }
        };
        Chromosome c3 = new Chromosome(){

            public double fitness() {
                return 15.0;
            }
        };
        ArrayList<Chromosome> chromosomes = new ArrayList<Chromosome>();
        chromosomes.add(c1);
        chromosomes.add(c2);
        chromosomes.add(c3);
        ListPopulation population = new ListPopulation(chromosomes, 10){

            public Population nextGeneration() {
                return null;
            }
        };
        Assert.assertEquals((Object)c3, (Object)population.getFittestChromosome());
    }

    @Test
    public void testChromosomes() {
        ArrayList<DummyBinaryChromosome> chromosomes = new ArrayList<DummyBinaryChromosome>();
        chromosomes.add(new DummyBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)3)));
        chromosomes.add(new DummyBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)3)));
        chromosomes.add(new DummyBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)3)));
        ListPopulation population = new ListPopulation(10){

            public Population nextGeneration() {
                return null;
            }
        };
        population.addChromosomes(chromosomes);
        Assert.assertEquals(chromosomes, (Object)population.getChromosomes());
        Assert.assertEquals((Object)chromosomes.toString(), (Object)population.toString());
        population.setPopulationLimit(50);
        Assert.assertEquals((long)50L, (long)population.getPopulationLimit());
    }

    @Test(expected=NotPositiveException.class)
    public void testSetPopulationLimit() {
        ListPopulation population = new ListPopulation(10){

            public Population nextGeneration() {
                return null;
            }
        };
        population.setPopulationLimit(-50);
    }

    @Test(expected=NotPositiveException.class)
    public void testConstructorPopulationLimitNotPositive() {
        new ListPopulation(-10){

            public Population nextGeneration() {
                return null;
            }
        };
    }

    @Test(expected=NotPositiveException.class)
    public void testChromosomeListConstructorPopulationLimitNotPositive() {
        ArrayList<DummyBinaryChromosome> chromosomes = new ArrayList<DummyBinaryChromosome>();
        chromosomes.add(new DummyBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)3)));
        new ListPopulation(chromosomes, -10){

            public Population nextGeneration() {
                return null;
            }
        };
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testConstructorListOfChromosomesBiggerThanPopulationSize() {
        ArrayList<DummyBinaryChromosome> chromosomes = new ArrayList<DummyBinaryChromosome>();
        chromosomes.add(new DummyBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)3)));
        chromosomes.add(new DummyBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)3)));
        chromosomes.add(new DummyBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)3)));
        new ListPopulation(chromosomes, 1){

            public Population nextGeneration() {
                return null;
            }
        };
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testAddTooManyChromosomes() {
        ArrayList<DummyBinaryChromosome> chromosomes = new ArrayList<DummyBinaryChromosome>();
        chromosomes.add(new DummyBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)3)));
        chromosomes.add(new DummyBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)3)));
        chromosomes.add(new DummyBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)3)));
        ListPopulation population = new ListPopulation(2){

            public Population nextGeneration() {
                return null;
            }
        };
        population.addChromosomes(chromosomes);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testAddTooManyChromosomesSingleCall() {
        ListPopulation population = new ListPopulation(2){

            public Population nextGeneration() {
                return null;
            }
        };
        for (int i = 0; i <= population.getPopulationLimit(); ++i) {
            population.addChromosome((Chromosome)new DummyBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)3)));
        }
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testIterator() {
        ArrayList<DummyBinaryChromosome> chromosomes = new ArrayList<DummyBinaryChromosome>();
        chromosomes.add(new DummyBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)3)));
        chromosomes.add(new DummyBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)3)));
        chromosomes.add(new DummyBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)3)));
        ListPopulation population = new ListPopulation(10){

            public Population nextGeneration() {
                return null;
            }
        };
        population.addChromosomes(chromosomes);
        Iterator iter = population.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
        }
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testSetPopulationLimitTooSmall() {
        ArrayList<DummyBinaryChromosome> chromosomes = new ArrayList<DummyBinaryChromosome>();
        chromosomes.add(new DummyBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)3)));
        chromosomes.add(new DummyBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)3)));
        chromosomes.add(new DummyBinaryChromosome(BinaryChromosome.randomBinaryRepresentation((int)3)));
        ListPopulation population = new ListPopulation(chromosomes, 3){

            public Population nextGeneration() {
                return null;
            }
        };
        population.setPopulationLimit(2);
    }
}

