/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.fraction;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathParseException;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.Fraction;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.FractionFormat;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.ProperFractionFormat;
import java.text.NumberFormat;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class FractionFormatTest {
    FractionFormat properFormat = null;
    FractionFormat improperFormat = null;

    protected Locale getLocale() {
        return Locale.getDefault();
    }

    @Before
    public void setUp() {
        this.properFormat = FractionFormat.getProperInstance((Locale)this.getLocale());
        this.improperFormat = FractionFormat.getImproperInstance((Locale)this.getLocale());
    }

    @Test
    public void testFormat() {
        Fraction c = new Fraction(1, 2);
        String expected = "1 / 2";
        String actual = this.properFormat.format((Object)c);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = this.improperFormat.format((Object)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFormatNegative() {
        Fraction c = new Fraction(-1, 2);
        String expected = "-1 / 2";
        String actual = this.properFormat.format((Object)c);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = this.improperFormat.format((Object)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFormatZero() {
        Fraction c = new Fraction(0, 1);
        String expected = "0 / 1";
        String actual = this.properFormat.format((Object)c);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = this.improperFormat.format((Object)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFormatImproper() {
        Fraction c = new Fraction(5, 3);
        String actual = this.properFormat.format((Object)c);
        Assert.assertEquals((Object)"1 2 / 3", (Object)actual);
        actual = this.improperFormat.format((Object)c);
        Assert.assertEquals((Object)"5 / 3", (Object)actual);
    }

    @Test
    public void testFormatImproperNegative() {
        Fraction c = new Fraction(-5, 3);
        String actual = this.properFormat.format((Object)c);
        Assert.assertEquals((Object)"-1 2 / 3", (Object)actual);
        actual = this.improperFormat.format((Object)c);
        Assert.assertEquals((Object)"-5 / 3", (Object)actual);
    }

    @Test
    public void testParse() {
        String source = "1 / 2";
        try {
            Fraction c = this.properFormat.parse(source);
            Assert.assertNotNull((Object)c);
            Assert.assertEquals((long)1L, (long)c.getNumerator());
            Assert.assertEquals((long)2L, (long)c.getDenominator());
            c = this.improperFormat.parse(source);
            Assert.assertNotNull((Object)c);
            Assert.assertEquals((long)1L, (long)c.getNumerator());
            Assert.assertEquals((long)2L, (long)c.getDenominator());
        }
        catch (MathParseException ex) {
            Assert.fail((String)ex.getMessage());
        }
    }

    @Test
    public void testParseInteger() {
        String source = "10";
        Fraction c = this.properFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)10L, (long)c.getNumerator());
        Assert.assertEquals((long)1L, (long)c.getDenominator());
        c = this.improperFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)10L, (long)c.getNumerator());
        Assert.assertEquals((long)1L, (long)c.getDenominator());
    }

    @Test
    public void testParseOne1() {
        String source = "1 / 1";
        Fraction c = this.properFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)1L, (long)c.getNumerator());
        Assert.assertEquals((long)1L, (long)c.getDenominator());
    }

    @Test
    public void testParseOne2() {
        String source = "10 / 10";
        Fraction c = this.properFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)1L, (long)c.getNumerator());
        Assert.assertEquals((long)1L, (long)c.getDenominator());
    }

    @Test
    public void testParseZero1() {
        String source = "0 / 1";
        Fraction c = this.properFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)0L, (long)c.getNumerator());
        Assert.assertEquals((long)1L, (long)c.getDenominator());
    }

    @Test
    public void testParseZero2() {
        String source = "-0 / 1";
        Fraction c = this.properFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)0L, (long)c.getNumerator());
        Assert.assertEquals((long)1L, (long)c.getDenominator());
        Assert.assertEquals((double)Double.POSITIVE_INFINITY, (double)(1.0 / c.doubleValue()), (double)0.0);
    }

    @Test
    public void testParseInvalid() {
        String source = "a";
        String msg = "should not be able to parse '10 / a'.";
        try {
            this.properFormat.parse(source);
            Assert.fail((String)msg);
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
        try {
            this.improperFormat.parse(source);
            Assert.fail((String)msg);
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
    }

    @Test
    public void testParseInvalidDenominator() {
        String source = "10 / a";
        String msg = "should not be able to parse '10 / a'.";
        try {
            this.properFormat.parse(source);
            Assert.fail((String)msg);
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
        try {
            this.improperFormat.parse(source);
            Assert.fail((String)msg);
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
    }

    @Test
    public void testParseNegative() {
        String source = "-1 / 2";
        Fraction c = this.properFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)-1L, (long)c.getNumerator());
        Assert.assertEquals((long)2L, (long)c.getDenominator());
        c = this.improperFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)-1L, (long)c.getNumerator());
        Assert.assertEquals((long)2L, (long)c.getDenominator());
        source = "1 / -2";
        c = this.properFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)-1L, (long)c.getNumerator());
        Assert.assertEquals((long)2L, (long)c.getDenominator());
        c = this.improperFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)-1L, (long)c.getNumerator());
        Assert.assertEquals((long)2L, (long)c.getDenominator());
    }

    @Test
    public void testParseProper() {
        String source = "1 2 / 3";
        Fraction c = this.properFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)5L, (long)c.getNumerator());
        Assert.assertEquals((long)3L, (long)c.getDenominator());
        try {
            this.improperFormat.parse(source);
            Assert.fail((String)"invalid improper fraction.");
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
    }

    @Test
    public void testParseProperNegative() {
        String source = "-1 2 / 3";
        Fraction c = this.properFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)-5L, (long)c.getNumerator());
        Assert.assertEquals((long)3L, (long)c.getDenominator());
        try {
            this.improperFormat.parse(source);
            Assert.fail((String)"invalid improper fraction.");
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
    }

    @Test
    public void testParseProperInvalidMinus() {
        String source = "2 -2 / 3";
        try {
            this.properFormat.parse(source);
            Assert.fail((String)"invalid minus in improper fraction.");
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
        source = "2 2 / -3";
        try {
            this.properFormat.parse(source);
            Assert.fail((String)"invalid minus in improper fraction.");
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
    }

    @Test
    public void testNumeratorFormat() {
        NumberFormat old = this.properFormat.getNumeratorFormat();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setParseIntegerOnly(true);
        this.properFormat.setNumeratorFormat(nf);
        Assert.assertEquals((Object)nf, (Object)this.properFormat.getNumeratorFormat());
        this.properFormat.setNumeratorFormat(old);
        old = this.improperFormat.getNumeratorFormat();
        nf = NumberFormat.getInstance();
        nf.setParseIntegerOnly(true);
        this.improperFormat.setNumeratorFormat(nf);
        Assert.assertEquals((Object)nf, (Object)this.improperFormat.getNumeratorFormat());
        this.improperFormat.setNumeratorFormat(old);
    }

    @Test
    public void testDenominatorFormat() {
        NumberFormat old = this.properFormat.getDenominatorFormat();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setParseIntegerOnly(true);
        this.properFormat.setDenominatorFormat(nf);
        Assert.assertEquals((Object)nf, (Object)this.properFormat.getDenominatorFormat());
        this.properFormat.setDenominatorFormat(old);
        old = this.improperFormat.getDenominatorFormat();
        nf = NumberFormat.getInstance();
        nf.setParseIntegerOnly(true);
        this.improperFormat.setDenominatorFormat(nf);
        Assert.assertEquals((Object)nf, (Object)this.improperFormat.getDenominatorFormat());
        this.improperFormat.setDenominatorFormat(old);
    }

    @Test
    public void testWholeFormat() {
        ProperFractionFormat format = (ProperFractionFormat)this.properFormat;
        NumberFormat old = format.getWholeFormat();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setParseIntegerOnly(true);
        format.setWholeFormat(nf);
        Assert.assertEquals((Object)nf, (Object)format.getWholeFormat());
        format.setWholeFormat(old);
    }

    @Test
    public void testLongFormat() {
        Assert.assertEquals((Object)"10 / 1", (Object)this.improperFormat.format(10L));
    }

    @Test
    public void testDoubleFormat() {
        Assert.assertEquals((Object)"355 / 113", (Object)this.improperFormat.format(Math.PI));
    }
}

