/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.fraction;

import com.hazelcast.shaded.org.apache.commons.math3.exception.MathParseException;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.BigFraction;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.BigFractionFormat;
import com.hazelcast.shaded.org.apache.commons.math3.fraction.ProperBigFractionFormat;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.NumberFormat;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BigFractionFormatTest {
    BigFractionFormat properFormat = null;
    BigFractionFormat improperFormat = null;

    protected Locale getLocale() {
        return Locale.getDefault();
    }

    @Before
    public void setUp() {
        this.properFormat = BigFractionFormat.getProperInstance((Locale)this.getLocale());
        this.improperFormat = BigFractionFormat.getImproperInstance((Locale)this.getLocale());
    }

    @Test
    public void testFormat() {
        BigFraction c = new BigFraction(1, 2);
        String expected = "1 / 2";
        String actual = this.properFormat.format((Object)c);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = this.improperFormat.format((Object)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFormatNegative() {
        BigFraction c = new BigFraction(-1, 2);
        String expected = "-1 / 2";
        String actual = this.properFormat.format((Object)c);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = this.improperFormat.format((Object)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFormatZero() {
        BigFraction c = new BigFraction(0, 1);
        String expected = "0 / 1";
        String actual = this.properFormat.format((Object)c);
        Assert.assertEquals((Object)expected, (Object)actual);
        actual = this.improperFormat.format((Object)c);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testFormatImproper() {
        BigFraction c = new BigFraction(5, 3);
        String actual = this.properFormat.format((Object)c);
        Assert.assertEquals((Object)"1 2 / 3", (Object)actual);
        actual = this.improperFormat.format((Object)c);
        Assert.assertEquals((Object)"5 / 3", (Object)actual);
    }

    @Test
    public void testFormatImproperNegative() {
        BigFraction c = new BigFraction(-5, 3);
        String actual = this.properFormat.format((Object)c);
        Assert.assertEquals((Object)"-1 2 / 3", (Object)actual);
        actual = this.improperFormat.format((Object)c);
        Assert.assertEquals((Object)"-5 / 3", (Object)actual);
    }

    @Test
    public void testParse() {
        String source = "1 / 2";
        BigFraction c = this.properFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)BigInteger.ONE, (Object)c.getNumerator());
        Assert.assertEquals((Object)BigInteger.valueOf(2L), (Object)c.getDenominator());
        c = this.improperFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)BigInteger.ONE, (Object)c.getNumerator());
        Assert.assertEquals((Object)BigInteger.valueOf(2L), (Object)c.getDenominator());
    }

    @Test
    public void testParseInteger() {
        String source = "10";
        BigFraction c = this.properFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)BigInteger.TEN, (Object)c.getNumerator());
        Assert.assertEquals((Object)BigInteger.ONE, (Object)c.getDenominator());
        c = this.improperFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((Object)BigInteger.TEN, (Object)c.getNumerator());
        Assert.assertEquals((Object)BigInteger.ONE, (Object)c.getDenominator());
    }

    @Test
    public void testParseInvalid() {
        String source = "a";
        String msg = "should not be able to parse '10 / a'.";
        try {
            this.properFormat.parse(source);
            Assert.fail((String)msg);
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
        try {
            this.improperFormat.parse(source);
            Assert.fail((String)msg);
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
    }

    @Test
    public void testParseInvalidDenominator() {
        String source = "10 / a";
        String msg = "should not be able to parse '10 / a'.";
        try {
            this.properFormat.parse(source);
            Assert.fail((String)msg);
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
        try {
            this.improperFormat.parse(source);
            Assert.fail((String)msg);
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
    }

    @Test
    public void testParseNegative() {
        String source = "-1 / 2";
        BigFraction c = this.properFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)-1L, (long)c.getNumeratorAsInt());
        Assert.assertEquals((long)2L, (long)c.getDenominatorAsInt());
        c = this.improperFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)-1L, (long)c.getNumeratorAsInt());
        Assert.assertEquals((long)2L, (long)c.getDenominatorAsInt());
        source = "1 / -2";
        c = this.properFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)-1L, (long)c.getNumeratorAsInt());
        Assert.assertEquals((long)2L, (long)c.getDenominatorAsInt());
        c = this.improperFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)-1L, (long)c.getNumeratorAsInt());
        Assert.assertEquals((long)2L, (long)c.getDenominatorAsInt());
    }

    @Test
    public void testParseProper() {
        String source = "1 2 / 3";
        BigFraction c = this.properFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)5L, (long)c.getNumeratorAsInt());
        Assert.assertEquals((long)3L, (long)c.getDenominatorAsInt());
        try {
            this.improperFormat.parse(source);
            Assert.fail((String)"invalid improper fraction.");
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
    }

    @Test
    public void testParseProperNegative() {
        String source = "-1 2 / 3";
        BigFraction c = this.properFormat.parse(source);
        Assert.assertNotNull((Object)c);
        Assert.assertEquals((long)-5L, (long)c.getNumeratorAsInt());
        Assert.assertEquals((long)3L, (long)c.getDenominatorAsInt());
        try {
            this.improperFormat.parse(source);
            Assert.fail((String)"invalid improper fraction.");
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
    }

    @Test
    public void testParseProperInvalidMinus() {
        String source = "2 -2 / 3";
        try {
            this.properFormat.parse(source);
            Assert.fail((String)"invalid minus in improper fraction.");
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
        source = "2 2 / -3";
        try {
            this.properFormat.parse(source);
            Assert.fail((String)"invalid minus in improper fraction.");
        }
        catch (MathParseException mathParseException) {
            // empty catch block
        }
    }

    @Test
    public void testParseBig() {
        BigFraction f1 = this.improperFormat.parse("167213075789791382630275400487886041651764456874403 / 53225575123090058458126718248444563466137046489291");
        Assert.assertEquals((double)Math.PI, (double)f1.doubleValue(), (double)0.0);
        BigFraction f2 = this.properFormat.parse("3 7536350420521207255895245742552351253353317406530 / 53225575123090058458126718248444563466137046489291");
        Assert.assertEquals((double)Math.PI, (double)f2.doubleValue(), (double)0.0);
        Assert.assertEquals((Object)f1, (Object)f2);
        BigDecimal pi = new BigDecimal("3.141592653589793238462643383279502884197169399375105820974944592307816406286208998628034825342117068");
        Assert.assertEquals((Object)pi, (Object)f1.bigDecimalValue(99, 6));
    }

    @Test
    public void testNumeratorFormat() {
        NumberFormat old = this.properFormat.getNumeratorFormat();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setParseIntegerOnly(true);
        this.properFormat.setNumeratorFormat(nf);
        Assert.assertEquals((Object)nf, (Object)this.properFormat.getNumeratorFormat());
        this.properFormat.setNumeratorFormat(old);
        old = this.improperFormat.getNumeratorFormat();
        nf = NumberFormat.getInstance();
        nf.setParseIntegerOnly(true);
        this.improperFormat.setNumeratorFormat(nf);
        Assert.assertEquals((Object)nf, (Object)this.improperFormat.getNumeratorFormat());
        this.improperFormat.setNumeratorFormat(old);
    }

    @Test
    public void testDenominatorFormat() {
        NumberFormat old = this.properFormat.getDenominatorFormat();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setParseIntegerOnly(true);
        this.properFormat.setDenominatorFormat(nf);
        Assert.assertEquals((Object)nf, (Object)this.properFormat.getDenominatorFormat());
        this.properFormat.setDenominatorFormat(old);
        old = this.improperFormat.getDenominatorFormat();
        nf = NumberFormat.getInstance();
        nf.setParseIntegerOnly(true);
        this.improperFormat.setDenominatorFormat(nf);
        Assert.assertEquals((Object)nf, (Object)this.improperFormat.getDenominatorFormat());
        this.improperFormat.setDenominatorFormat(old);
    }

    @Test
    public void testWholeFormat() {
        ProperBigFractionFormat format = (ProperBigFractionFormat)this.properFormat;
        NumberFormat old = format.getWholeFormat();
        NumberFormat nf = NumberFormat.getInstance();
        nf.setParseIntegerOnly(true);
        format.setWholeFormat(nf);
        Assert.assertEquals((Object)nf, (Object)format.getWholeFormat());
        format.setWholeFormat(old);
    }

    @Test
    public void testLongFormat() {
        Assert.assertEquals((Object)"10 / 1", (Object)this.improperFormat.format(10L));
    }

    @Test
    public void testDoubleFormat() {
        Assert.assertEquals((Object)"1 / 16", (Object)this.improperFormat.format(0.0625));
    }
}

