/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.fitting.leastsquares;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.MultivariateMatrixFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.MultivariateVectorFunction;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.Vector;
import com.hazelcast.shaded.org.apache.commons.math3.geometry.euclidean.twod.Vector2D;
import java.util.ArrayList;

class CircleVectorial {
    private ArrayList<Vector2D> points = new ArrayList();

    public void addPoint(double px, double py) {
        this.points.add(new Vector2D(px, py));
    }

    public int getN() {
        return this.points.size();
    }

    public double getRadius(Vector2D center) {
        double r = 0.0;
        for (Vector2D point : this.points) {
            r += point.distance((Vector)center);
        }
        return r / (double)this.points.size();
    }

    public MultivariateVectorFunction getModelFunction() {
        return new MultivariateVectorFunction(){

            public double[] value(double[] params) {
                Vector2D center = new Vector2D(params[0], params[1]);
                double radius = CircleVectorial.this.getRadius(center);
                double[] residuals = new double[CircleVectorial.this.points.size()];
                for (int i = 0; i < residuals.length; ++i) {
                    residuals[i] = ((Vector2D)CircleVectorial.this.points.get(i)).distance((Vector)center) - radius;
                }
                return residuals;
            }
        };
    }

    public MultivariateMatrixFunction getModelFunctionJacobian() {
        return new MultivariateMatrixFunction(){

            public double[][] value(double[] params) {
                int n = CircleVectorial.this.points.size();
                Vector2D center = new Vector2D(params[0], params[1]);
                double dRdX = 0.0;
                double dRdY = 0.0;
                for (Vector2D pk : CircleVectorial.this.points) {
                    double dk = pk.distance((Vector)center);
                    dRdX += (center.getX() - pk.getX()) / dk;
                    dRdY += (center.getY() - pk.getY()) / dk;
                }
                dRdX /= (double)n;
                dRdY /= (double)n;
                double[][] jacobian = new double[n][2];
                for (int i = 0; i < n; ++i) {
                    Vector2D pi = (Vector2D)CircleVectorial.this.points.get(i);
                    double di = pi.distance((Vector)center);
                    jacobian[i][0] = (center.getX() - pi.getX()) / di - dRdX;
                    jacobian[i][1] = (center.getY() - pi.getY()) / di - dRdY;
                }
                return jacobian;
            }
        };
    }
}

