/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.exception.util;

import com.hazelcast.shaded.org.apache.commons.math3.exception.util.ExceptionContext;
import com.hazelcast.shaded.org.apache.commons.math3.exception.util.Localizable;
import com.hazelcast.shaded.org.apache.commons.math3.exception.util.LocalizedFormats;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Locale;
import org.junit.Assert;
import org.junit.Test;

public class ExceptionContextTest {
    @Test
    public void testMessageChain() {
        ExceptionContext c = new ExceptionContext((Throwable)new Exception("oops"));
        String sep = " | ";
        String m1 = "column index (0)";
        c.addMessage((Localizable)LocalizedFormats.COLUMN_INDEX, new Object[]{0});
        String m2 = "got 1x2 but expected 3x4";
        c.addMessage((Localizable)LocalizedFormats.DIMENSIONS_MISMATCH_2x2, new Object[]{1, 2, 3, 4});
        String m3 = "It didn't work out";
        c.addMessage((Localizable)LocalizedFormats.SIMPLE_MESSAGE, new Object[]{"It didn't work out"});
        Assert.assertEquals((Object)c.getMessage(Locale.US, " | "), (Object)"column index (0) | got 1x2 but expected 3x4 | It didn't work out");
    }

    @Test
    public void testNoArgAddMessage() {
        ExceptionContext c = new ExceptionContext((Throwable)new Exception("hello"));
        c.addMessage((Localizable)LocalizedFormats.SIMPLE_MESSAGE, new Object[0]);
        Assert.assertEquals((Object)c.getMessage(), (Object)"{0}");
    }

    @Test
    public void testContext() {
        int i;
        ExceptionContext c = new ExceptionContext((Throwable)new Exception("bye"));
        String[] keys = new String[]{"Key 1", "Key 2"};
        Object[] values = new Object[]{"Value 1", 2};
        for (i = 0; i < keys.length; ++i) {
            c.setValue(keys[i], values[i]);
        }
        Assert.assertTrue((boolean)c.getKeys().containsAll(Arrays.asList(keys)));
        for (i = 0; i < keys.length; ++i) {
            Assert.assertEquals((Object)values[i], (Object)c.getValue(keys[i]));
        }
        Assert.assertNull((Object)c.getValue("xyz"));
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        ExceptionContext cOut = new ExceptionContext((Throwable)new Exception("Apache"));
        cOut.addMessage((Localizable)LocalizedFormats.COLUMN_INDEX, new Object[]{0});
        cOut.setValue("Key 1", (Object)0);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(cOut);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        ExceptionContext cIn = (ExceptionContext)ois.readObject();
        Assert.assertTrue((boolean)cOut.getMessage().equals(cIn.getMessage()));
        for (String key : cIn.getKeys()) {
            Assert.assertTrue((boolean)cOut.getValue(key).equals(cIn.getValue(key)));
        }
    }

    @Test
    public void testSerializeUnserializable() throws Exception {
        ExceptionContext cOut = new ExceptionContext((Throwable)new Exception("Apache Commons Math"));
        cOut.addMessage((Localizable)LocalizedFormats.SIMPLE_MESSAGE, new Object[]{"OK"});
        cOut.addMessage((Localizable)LocalizedFormats.SIMPLE_MESSAGE, new Object[]{new Unserializable()});
        String key = "Key 1";
        cOut.setValue(key, (Object)new Unserializable());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeObject(cOut);
        ByteArrayInputStream bis = new ByteArrayInputStream(bos.toByteArray());
        ObjectInputStream ois = new ObjectInputStream(bis);
        ExceptionContext cIn = (ExceptionContext)ois.readObject();
        String nsObjStr = (String)cIn.getValue(key);
        Assert.assertTrue((boolean)nsObjStr.matches(".*could not be serialized.*"));
    }

    private static class Unserializable {
        Unserializable() {
        }
    }
}

