/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.IntegerDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.IntegerDistributionAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.UniformIntegerDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import org.junit.Assert;
import org.junit.Test;

public class UniformIntegerDistributionTest
extends IntegerDistributionAbstractTest {
    public void setUp() {
        super.setUp();
        this.setTolerance(1.0E-9);
    }

    public IntegerDistribution makeDistribution() {
        return new UniformIntegerDistribution(-3, 5);
    }

    public int[] makeDensityTestPoints() {
        return new int[]{-4, -3, -2, -1, 0, 1, 2, 3, 4, 5, 6};
    }

    public double[] makeDensityTestValues() {
        double d = 0.1111111111111111;
        return new double[]{0.0, d, d, d, d, d, d, d, d, d, 0.0};
    }

    public int[] makeCumulativeTestPoints() {
        return this.makeDensityTestPoints();
    }

    public double[] makeCumulativeTestValues() {
        return new double[]{0.0, 0.1111111111111111, 0.2222222222222222, 0.3333333333333333, 0.4444444444444444, 0.5555555555555556, 0.6666666666666666, 0.7777777777777778, 0.8888888888888888, 1.0, 1.0};
    }

    public double[] makeInverseCumulativeTestPoints() {
        return new double[]{0.0, 0.001, 0.01, 0.025, 0.05, 0.1, 0.2, 0.5, 0.999, 0.99, 0.975, 0.95, 0.9, 1.0};
    }

    public int[] makeInverseCumulativeTestValues() {
        return new int[]{-3, -3, -3, -3, -3, -3, -2, 1, 5, 5, 5, 5, 5, 5};
    }

    @Test
    public void testMoments() {
        UniformIntegerDistribution dist = new UniformIntegerDistribution(0, 5);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)2.5, (double)0.0);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)2.9166666666666665, (double)0.0);
        dist = new UniformIntegerDistribution(0, 1);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)0.5, (double)0.0);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)0.25, (double)0.0);
    }

    @Test
    public void testPreconditionUpperBoundInclusive() {
        try {
            new UniformIntegerDistribution(1, 0);
        }
        catch (NumberIsTooLargeException numberIsTooLargeException) {
            // empty catch block
        }
        new UniformIntegerDistribution(0, 0);
    }
}

