/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.RealDistributionAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.TriangularDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooLargeException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import org.junit.Assert;
import org.junit.Test;

public class TriangularDistributionTest
extends RealDistributionAbstractTest {
    public void setUp() {
        super.setUp();
        this.setTolerance(1.0E-4);
    }

    public TriangularDistribution makeDistribution() {
        return new TriangularDistribution(-3.0, 2.0, 12.0);
    }

    public double[] makeCumulativeTestPoints() {
        return new double[]{-3.0001, -3.0, -2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 10.0, 11.0, 12.0, 12.0001};
    }

    public double[] makeCumulativeTestValues() {
        double third = 0.3333333333333333;
        double left = 18.75;
        double area = 56.25;
        return new double[]{0.0, 0.0, 0.75 / area, 3.0 / area, 6.75 / area, 12.0 / area, third, (left + 7.125) / area, (left + 13.5) / area, (left + 36.0) / area, (left + 37.125) / area, 1.0, 1.0};
    }

    public double[] makeInverseCumulativeTestPoints() {
        double[] points = this.makeCumulativeTestValues();
        double[] points2 = new double[points.length - 2];
        System.arraycopy(points, 1, points2, 0, points2.length);
        return points2;
    }

    public double[] makeInverseCumulativeTestValues() {
        double[] points = this.makeCumulativeTestPoints();
        double[] points2 = new double[points.length - 2];
        System.arraycopy(points, 1, points2, 0, points2.length);
        return points2;
    }

    public double[] makeDensityTestValues() {
        return new double[]{0.0, 0.0, 0.02666666666666667, 0.05333333333333334, 0.08, 0.10666666666666667, 0.13333333333333333, 0.12, 0.10666666666666667, 0.02666666666666667, 0.013333333333333334, 0.0, 0.0};
    }

    @Test
    public void testGetLowerBound() {
        TriangularDistribution distribution = this.makeDistribution();
        Assert.assertEquals((double)-3.0, (double)distribution.getSupportLowerBound(), (double)0.0);
    }

    @Test
    public void testGetUpperBound() {
        TriangularDistribution distribution = this.makeDistribution();
        Assert.assertEquals((double)12.0, (double)distribution.getSupportUpperBound(), (double)0.0);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testPreconditions1() {
        new TriangularDistribution(0.0, 0.0, 0.0);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testPreconditions2() {
        new TriangularDistribution(1.0, 1.0, 0.0);
    }

    @Test(expected=NumberIsTooLargeException.class)
    public void testPreconditions3() {
        new TriangularDistribution(0.0, 2.0, 1.0);
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testPreconditions4() {
        new TriangularDistribution(2.0, 1.0, 3.0);
    }

    @Test
    public void testMeanVariance() {
        TriangularDistribution dist = new TriangularDistribution(0.0, 0.5, 1.0);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)0.5, (double)0.0);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)0.041666666666666664, (double)0.0);
        dist = new TriangularDistribution(0.0, 1.0, 1.0);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)0.6666666666666666, (double)0.0);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)0.05555555555555555, (double)0.0);
        dist = new TriangularDistribution(-3.0, 2.0, 12.0);
        Assert.assertEquals((double)dist.getNumericalMean(), (double)3.6666666666666665, (double)0.0);
        Assert.assertEquals((double)dist.getNumericalVariance(), (double)9.722222222222221, (double)0.0);
    }
}

