/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.MultivariateNormalDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.NormalDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.linear.RealMatrix;
import com.hazelcast.shaded.org.apache.commons.math3.stat.correlation.Covariance;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class MultivariateNormalDistributionTest {
    @Test
    public void testGetMean() {
        double[] mu = new double[]{-1.5, 2.0};
        double[][] sigma = new double[][]{{2.0, -1.1}, {-1.1, 2.0}};
        MultivariateNormalDistribution d = new MultivariateNormalDistribution(mu, (double[][])sigma);
        double[] m = d.getMeans();
        for (int i = 0; i < m.length; ++i) {
            Assert.assertEquals((double)mu[i], (double)m[i], (double)0.0);
        }
    }

    @Test
    public void testGetCovarianceMatrix() {
        double[] mu = new double[]{-1.5, 2.0};
        double[][] sigma = new double[][]{{2.0, -1.1}, {-1.1, 2.0}};
        MultivariateNormalDistribution d = new MultivariateNormalDistribution(mu, (double[][])sigma);
        RealMatrix s = d.getCovariances();
        int dim = d.getDimension();
        for (int i = 0; i < dim; ++i) {
            for (int j = 0; j < dim; ++j) {
                Assert.assertEquals((double)sigma[i][j], (double)s.getEntry(i, j), (double)0.0);
            }
        }
    }

    @Test
    public void testSampling() {
        double[] mu = new double[]{-1.5, 2.0};
        double[][] sigma = new double[][]{{2.0, -1.1}, {-1.1, 2.0}};
        MultivariateNormalDistribution d = new MultivariateNormalDistribution(mu, (double[][])sigma);
        d.reseedRandomGenerator(50L);
        int n = 500000;
        double[][] samples = d.sample(500000);
        int dim = d.getDimension();
        double[] sampleMeans = new double[dim];
        for (int i = 0; i < samples.length; ++i) {
            for (int j = 0; j < dim; ++j) {
                int n2 = j;
                sampleMeans[n2] = sampleMeans[n2] + samples[i][j];
            }
        }
        double sampledValueTolerance = 0.01;
        for (int j = 0; j < dim; ++j) {
            int n3 = j;
            sampleMeans[n3] = sampleMeans[n3] / (double)samples.length;
            Assert.assertEquals((double)mu[j], (double)sampleMeans[j], (double)0.01);
        }
        double[][] sampleSigma = new Covariance(samples).getCovarianceMatrix().getData();
        for (int i = 0; i < dim; ++i) {
            for (int j = 0; j < dim; ++j) {
                Assert.assertEquals((double)sigma[i][j], (double)sampleSigma[i][j], (double)0.01);
            }
        }
    }

    @Test
    public void testDensities() {
        double[] mu = new double[]{-1.5, 2.0};
        double[][] sigma = new double[][]{{2.0, -1.1}, {-1.1, 2.0}};
        MultivariateNormalDistribution d = new MultivariateNormalDistribution(mu, (double[][])sigma);
        double[][] testValues = new double[][]{{-1.5, 2.0}, {4.0, 4.0}, {1.5, -2.0}, {0.0, 0.0}};
        double[] densities = new double[testValues.length];
        for (int i = 0; i < densities.length; ++i) {
            densities[i] = d.density(testValues[i]);
        }
        double[] correctDensities = new double[]{0.09528357207691344, 5.80932710124009E-9, 0.001387448895173267, 0.03309922090210541};
        for (int i = 0; i < testValues.length; ++i) {
            Assert.assertEquals((double)correctDensities[i], (double)densities[i], (double)1.0E-16);
        }
    }

    @Test
    public void testUnivariateDistribution() {
        double[] mu = new double[]{-1.5};
        double[][] sigma = new double[][]{{1.0}};
        MultivariateNormalDistribution multi = new MultivariateNormalDistribution(mu, (double[][])sigma);
        NormalDistribution uni = new NormalDistribution(mu[0], sigma[0][0]);
        Random rng = new Random();
        int numCases = 100;
        double tol = Math.ulp(1.0);
        for (int i = 0; i < 100; ++i) {
            double v = rng.nextDouble() * 10.0 - 5.0;
            Assert.assertEquals((double)uni.density(v), (double)multi.density(new double[]{v}), (double)tol);
        }
    }
}

