/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.distribution;

import com.hazelcast.shaded.org.apache.commons.math3.distribution.EnumeratedDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.EnumeratedRealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathArithmeticException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotANumberException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotFiniteNumberException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.Pair;
import java.util.ArrayList;
import org.junit.Assert;
import org.junit.Test;

public class EnumeratedRealDistributionTest {
    private final EnumeratedRealDistribution testDistribution = new EnumeratedRealDistribution(new double[]{3.0, -1.0, 3.0, 7.0, -2.0, 8.0}, new double[]{0.2, 0.2, 0.3, 0.3, 0.0, 0.0});

    @Test
    public void testExceptions() {
        EnumeratedRealDistribution invalid = null;
        try {
            invalid = new EnumeratedRealDistribution(new double[]{1.0, 2.0}, new double[]{0.0});
            Assert.fail((String)"Expected DimensionMismatchException");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        try {
            invalid = new EnumeratedRealDistribution(new double[]{1.0, 2.0}, new double[]{0.0, -1.0});
            Assert.fail((String)"Expected NotPositiveException");
        }
        catch (NotPositiveException notPositiveException) {
            // empty catch block
        }
        try {
            invalid = new EnumeratedRealDistribution(new double[]{1.0, 2.0}, new double[]{0.0, 0.0});
            Assert.fail((String)"Expected MathArithmeticException");
        }
        catch (MathArithmeticException mathArithmeticException) {
            // empty catch block
        }
        try {
            invalid = new EnumeratedRealDistribution(new double[]{1.0, 2.0}, new double[]{0.0, Double.NaN});
            Assert.fail((String)"Expected NotANumberException");
        }
        catch (NotANumberException notANumberException) {
            // empty catch block
        }
        try {
            invalid = new EnumeratedRealDistribution(new double[]{1.0, 2.0}, new double[]{0.0, Double.POSITIVE_INFINITY});
            Assert.fail((String)"Expected NotFiniteNumberException");
        }
        catch (NotFiniteNumberException notFiniteNumberException) {
            // empty catch block
        }
        Assert.assertNull((String)"Expected non-initialized DiscreteRealDistribution", invalid);
    }

    @Test
    public void testProbability() {
        double[] points = new double[]{-2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
        double[] results = new double[]{0.0, 0.2, 0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.0, 0.3, 0.0};
        for (int p = 0; p < points.length; ++p) {
            double density = this.testDistribution.probability(points[p]);
            Assert.assertEquals((double)results[p], (double)density, (double)0.0);
        }
    }

    @Test
    public void testDensity() {
        double[] points = new double[]{-2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
        double[] results = new double[]{0.0, 0.2, 0.0, 0.0, 0.0, 0.5, 0.0, 0.0, 0.0, 0.3, 0.0};
        for (int p = 0; p < points.length; ++p) {
            double density = this.testDistribution.density(points[p]);
            Assert.assertEquals((double)results[p], (double)density, (double)0.0);
        }
    }

    @Test
    public void testCumulativeProbability() {
        double[] points = new double[]{-2.0, -1.0, 0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0, 7.0, 8.0};
        double[] results = new double[]{0.0, 0.2, 0.2, 0.2, 0.2, 0.7, 0.7, 0.7, 0.7, 1.0, 1.0};
        for (int p = 0; p < points.length; ++p) {
            double probability = this.testDistribution.cumulativeProbability(points[p]);
            Assert.assertEquals((double)results[p], (double)probability, (double)1.0E-10);
        }
    }

    @Test
    public void testGetNumericalMean() {
        Assert.assertEquals((double)3.4, (double)this.testDistribution.getNumericalMean(), (double)1.0E-10);
    }

    @Test
    public void testGetNumericalVariance() {
        Assert.assertEquals((double)7.84, (double)this.testDistribution.getNumericalVariance(), (double)1.0E-10);
    }

    @Test
    public void testGetSupportLowerBound() {
        Assert.assertEquals((double)-1.0, (double)this.testDistribution.getSupportLowerBound(), (double)0.0);
    }

    @Test
    public void testGetSupportUpperBound() {
        Assert.assertEquals((double)7.0, (double)this.testDistribution.getSupportUpperBound(), (double)0.0);
    }

    @Test
    public void testIsSupportLowerBoundInclusive() {
        Assert.assertTrue((boolean)this.testDistribution.isSupportLowerBoundInclusive());
    }

    @Test
    public void testIsSupportUpperBoundInclusive() {
        Assert.assertTrue((boolean)this.testDistribution.isSupportUpperBoundInclusive());
    }

    @Test
    public void testIsSupportConnected() {
        Assert.assertTrue((boolean)this.testDistribution.isSupportConnected());
    }

    @Test
    public void testSample() {
        int n = 1000000;
        this.testDistribution.reseedRandomGenerator(-334759360L);
        double[] samples = this.testDistribution.sample(1000000);
        Assert.assertEquals((long)1000000L, (long)samples.length);
        double sum = 0.0;
        double sumOfSquares = 0.0;
        for (int i = 0; i < samples.length; ++i) {
            sum += samples[i];
            sumOfSquares += samples[i] * samples[i];
        }
        Assert.assertEquals((double)this.testDistribution.getNumericalMean(), (double)(sum / 1000000.0), (double)0.01);
        Assert.assertEquals((double)this.testDistribution.getNumericalVariance(), (double)(sumOfSquares / 1000000.0 - FastMath.pow((double)(sum / 1000000.0), (int)2)), (double)0.01);
    }

    @Test
    public void testIssue942() {
        ArrayList<Pair> list = new ArrayList<Pair>();
        list.add(new Pair(new Object(){}, (Object)new Double(0.0)));
        list.add(new Pair(new Object(){}, (Object)new Double(1.0)));
        Assert.assertEquals((long)1L, (long)new EnumeratedDistribution(list).sample(1).length);
    }

    @Test
    public void testIssue1065() {
        EnumeratedRealDistribution distribution = new EnumeratedRealDistribution(new double[]{14.0, 18.0, 21.0, 28.0, 31.0, 33.0}, new double[]{0.25, 0.3125, 0.0, 0.1875, 0.0625, 0.1875});
        Assert.assertEquals((double)14.0, (double)distribution.inverseCumulativeProbability(0.0), (double)0.0);
        Assert.assertEquals((double)14.0, (double)distribution.inverseCumulativeProbability(0.25), (double)0.0);
        Assert.assertEquals((double)33.0, (double)distribution.inverseCumulativeProbability(1.0), (double)0.0);
        Assert.assertEquals((double)18.0, (double)distribution.inverseCumulativeProbability(0.5), (double)0.0);
        Assert.assertEquals((double)18.0, (double)distribution.inverseCumulativeProbability(0.5624), (double)0.0);
        Assert.assertEquals((double)28.0, (double)distribution.inverseCumulativeProbability(0.5626), (double)0.0);
        Assert.assertEquals((double)31.0, (double)distribution.inverseCumulativeProbability(0.76), (double)0.0);
        Assert.assertEquals((double)18.0, (double)distribution.inverseCumulativeProbability(0.5625), (double)0.0);
        Assert.assertEquals((double)28.0, (double)distribution.inverseCumulativeProbability(0.75), (double)0.0);
    }

    @Test
    public void testCreateFromDoubles() {
        double[] data = new double[]{0.0, 1.0, 1.0, 2.0, 2.0, 2.0};
        EnumeratedRealDistribution distribution = new EnumeratedRealDistribution(data);
        Assert.assertEquals((double)0.5, (double)distribution.probability(2.0), (double)0.0);
        Assert.assertEquals((double)0.5, (double)distribution.cumulativeProbability(1.0), (double)0.0);
    }
}

