/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.dfp;

import com.hazelcast.shaded.org.apache.commons.math3.dfp.Dfp;
import com.hazelcast.shaded.org.apache.commons.math3.dfp.DfpField;
import com.hazelcast.shaded.org.apache.commons.math3.dfp.DfpMath;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DfpMathTest {
    private DfpField factory;
    private Dfp pinf;
    private Dfp ninf;
    private Dfp nan;
    private Dfp qnan;

    @Before
    public void setUp() {
        this.factory = new DfpField(20);
        this.pinf = this.factory.newDfp("1").divide(this.factory.newDfp("0"));
        this.ninf = this.factory.newDfp("-1").divide(this.factory.newDfp("0"));
        this.nan = this.factory.newDfp("0").divide(this.factory.newDfp("0"));
        this.qnan = this.factory.newDfp((byte)1, (byte)3);
        this.ninf.getField().clearIEEEFlags();
        Dfp pi = this.factory.getPi();
        pi.getField().clearIEEEFlags();
    }

    @After
    public void tearDown() {
        this.pinf = null;
        this.ninf = null;
        this.nan = null;
        this.qnan = null;
    }

    private void test(Dfp x, Dfp y, int flags, String desc) {
        boolean b = x.equals((Object)y);
        if (!x.equals((Object)y) && !x.unequal(y)) {
            b = x.toString().equals(y.toString());
        }
        if (x.equals((Object)this.factory.newDfp("0"))) {
            b = b && x.toString().equals(y.toString());
        }
        boolean bl = b = b && x.getField().getIEEEFlags() == flags;
        if (!b) {
            Assert.assertTrue((String)("assersion failed " + desc + " x = " + x.toString() + " flags = " + x.getField().getIEEEFlags()), (boolean)b);
        }
        x.getField().clearIEEEFlags();
    }

    @Test
    public void testPow() {
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("0"), (Dfp)this.factory.newDfp("0")), this.factory.newDfp("1"), 0, "pow #1");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("0"), (Dfp)this.factory.newDfp("-0")), this.factory.newDfp("1"), 0, "pow #2");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("2"), (Dfp)this.factory.newDfp("0")), this.factory.newDfp("1"), 0, "pow #3");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-2"), (Dfp)this.factory.newDfp("-0")), this.factory.newDfp("1"), 0, "pow #4");
        this.test(DfpMath.pow((Dfp)this.pinf, (Dfp)this.factory.newDfp("-0")), this.factory.newDfp("1"), 0, "pow #5");
        this.test(DfpMath.pow((Dfp)this.pinf, (Dfp)this.factory.newDfp("0")), this.factory.newDfp("1"), 0, "pow #6");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.factory.newDfp("-0")), this.factory.newDfp("1"), 0, "pow #7");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.factory.newDfp("0")), this.factory.newDfp("1"), 0, "pow #8");
        this.test(DfpMath.pow((Dfp)this.qnan, (Dfp)this.factory.newDfp("0")), this.factory.newDfp("1"), 0, "pow #8");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("0"), (Dfp)this.factory.newDfp("1")), this.factory.newDfp("0"), 0, "pow #9");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-0"), (Dfp)this.factory.newDfp("1")), this.factory.newDfp("-0"), 0, "pow #10");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("2"), (Dfp)this.factory.newDfp("1")), this.factory.newDfp("2"), 0, "pow #11");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-2"), (Dfp)this.factory.newDfp("1")), this.factory.newDfp("-2"), 0, "pow #12");
        this.test(DfpMath.pow((Dfp)this.pinf, (Dfp)this.factory.newDfp("1")), this.pinf, 0, "pow #13");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.factory.newDfp("1")), this.ninf, 0, "pow #14");
        this.test(DfpMath.pow((Dfp)this.qnan, (Dfp)this.factory.newDfp("1")), this.qnan, 1, "pow #14.1");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("0"), (Dfp)this.qnan), this.qnan, 1, "pow #15");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-0"), (Dfp)this.qnan), this.qnan, 1, "pow #16");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("2"), (Dfp)this.qnan), this.qnan, 1, "pow #17");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-2"), (Dfp)this.qnan), this.qnan, 1, "pow #18");
        this.test(DfpMath.pow((Dfp)this.pinf, (Dfp)this.qnan), this.qnan, 1, "pow #19");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.qnan), this.qnan, 1, "pow #20");
        this.test(DfpMath.pow((Dfp)this.qnan, (Dfp)this.qnan), this.qnan, 1, "pow #21");
        this.test(DfpMath.pow((Dfp)this.qnan, (Dfp)this.factory.newDfp("1")), this.qnan, 1, "pow #22");
        this.test(DfpMath.pow((Dfp)this.qnan, (Dfp)this.factory.newDfp("-1")), this.qnan, 1, "pow #23");
        this.test(DfpMath.pow((Dfp)this.qnan, (Dfp)this.pinf), this.qnan, 1, "pow #24");
        this.test(DfpMath.pow((Dfp)this.qnan, (Dfp)this.ninf), this.qnan, 1, "pow #25");
        this.test(DfpMath.pow((Dfp)this.qnan, (Dfp)this.qnan), this.qnan, 1, "pow #26");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("2"), (Dfp)this.pinf), this.pinf, 0, "pow #27");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-2"), (Dfp)this.pinf), this.pinf, 0, "pow #28");
        this.test(DfpMath.pow((Dfp)this.pinf, (Dfp)this.pinf), this.pinf, 0, "pow #29");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.pinf), this.pinf, 0, "pow #30");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("2"), (Dfp)this.ninf), this.factory.getZero(), 0, "pow #31");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-2"), (Dfp)this.ninf), this.factory.getZero(), 0, "pow #32");
        this.test(DfpMath.pow((Dfp)this.pinf, (Dfp)this.ninf), this.factory.getZero(), 0, "pow #33");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.ninf), this.factory.getZero(), 0, "pow #34");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("0.5"), (Dfp)this.pinf), this.factory.getZero(), 0, "pow #35");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-0.5"), (Dfp)this.pinf), this.factory.getZero(), 0, "pow #36");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("0.5"), (Dfp)this.ninf), this.pinf, 0, "pow #37");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-0.5"), (Dfp)this.ninf), this.pinf, 0, "pow #38");
        this.test(DfpMath.pow((Dfp)this.factory.getOne(), (Dfp)this.pinf), this.qnan, 1, "pow #39");
        this.test(DfpMath.pow((Dfp)this.factory.getOne(), (Dfp)this.ninf), this.qnan, 1, "pow #40");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-1"), (Dfp)this.pinf), this.qnan, 1, "pow #41");
        this.test(DfpMath.pow((Dfp)this.factory.getOne().negate(), (Dfp)this.ninf), this.qnan, 1, "pow #42");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("0"), (Dfp)this.factory.newDfp("1")), this.factory.newDfp("0"), 0, "pow #43");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("0"), (Dfp)this.factory.newDfp("1e30")), this.factory.newDfp("0"), 0, "pow #44");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("0"), (Dfp)this.factory.newDfp("1e-30")), this.factory.newDfp("0"), 0, "pow #45");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("0"), (Dfp)this.pinf), this.factory.newDfp("0"), 0, "pow #46");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-0"), (Dfp)this.factory.newDfp("2")), this.factory.newDfp("0"), 0, "pow #47");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-0"), (Dfp)this.factory.newDfp("1e30")), this.factory.newDfp("0"), 0, "pow #48");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-0"), (Dfp)this.factory.newDfp("1e-30")), this.factory.newDfp("0"), 16, "pow #49");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-0"), (Dfp)this.pinf), this.factory.newDfp("0"), 0, "pow #50");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("0"), (Dfp)this.factory.newDfp("-1")), this.pinf, 0, "pow #51");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("0"), (Dfp)this.factory.newDfp("-1e30")), this.pinf, 0, "pow #52");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("0"), (Dfp)this.factory.newDfp("-1e-30")), this.pinf, 0, "pow #53");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("0"), (Dfp)this.ninf), this.pinf, 0, "pow #54");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-0"), (Dfp)this.factory.newDfp("-2")), this.pinf, 0, "pow #55");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-0"), (Dfp)this.factory.newDfp("-1e30")), this.pinf, 0, "pow #56");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-0"), (Dfp)this.factory.newDfp("-1e-30")), this.pinf, 16, "pow #57");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-0"), (Dfp)this.ninf), this.pinf, 0, "pow #58");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-0"), (Dfp)this.factory.newDfp("-1")), this.ninf, 16, "pow #59");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-0"), (Dfp)this.factory.newDfp("-12345")), this.ninf, 16, "pow #60");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-0"), (Dfp)this.factory.newDfp("3")), this.factory.newDfp("-0"), 16, "pow #61");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-0"), (Dfp)this.factory.newDfp("12345")), this.factory.newDfp("-0"), 16, "pow #62");
        this.test(DfpMath.pow((Dfp)this.pinf, (Dfp)this.factory.newDfp("3")), this.pinf, 0, "pow #63");
        this.test(DfpMath.pow((Dfp)this.pinf, (Dfp)this.factory.newDfp("1e30")), this.pinf, 0, "pow #64");
        this.test(DfpMath.pow((Dfp)this.pinf, (Dfp)this.factory.newDfp("1e-30")), this.pinf, 0, "pow #65");
        this.test(DfpMath.pow((Dfp)this.pinf, (Dfp)this.pinf), this.pinf, 0, "pow #66");
        this.test(DfpMath.pow((Dfp)this.pinf, (Dfp)this.factory.newDfp("-3")), this.factory.getZero(), 0, "pow #67");
        this.test(DfpMath.pow((Dfp)this.pinf, (Dfp)this.factory.newDfp("-1e30")), this.factory.getZero(), 0, "pow #68");
        this.test(DfpMath.pow((Dfp)this.pinf, (Dfp)this.factory.newDfp("-1e-30")), this.factory.getZero(), 0, "pow #69");
        this.test(DfpMath.pow((Dfp)this.pinf, (Dfp)this.ninf), this.factory.getZero(), 0, "pow #70");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.factory.newDfp("-2")), this.factory.newDfp("0"), 0, "pow #71");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.factory.newDfp("-1e30")), this.factory.newDfp("0"), 0, "pow #72");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.factory.newDfp("-1e-30")), this.factory.newDfp("0"), 16, "pow #73");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.ninf), this.factory.newDfp("0"), 0, "pow #74");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.factory.newDfp("2")), this.pinf, 0, "pow #75");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.factory.newDfp("1e30")), this.pinf, 0, "pow #76");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.factory.newDfp("1e-30")), this.pinf, 16, "pow #77");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.pinf), this.pinf, 0, "pow #78");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.factory.newDfp("3")), this.ninf, 16, "pow #79");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.factory.newDfp("12345")), this.ninf, 16, "pow #80");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.factory.newDfp("-3")), this.factory.newDfp("-0"), 16, "pow #81");
        this.test(DfpMath.pow((Dfp)this.ninf, (Dfp)this.factory.newDfp("-12345")), this.factory.newDfp("-0"), 16, "pow #82");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-2"), (Dfp)this.factory.newDfp("3")), this.factory.newDfp("-8"), 16, "pow #83");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-2"), (Dfp)this.factory.newDfp("16")), this.factory.newDfp("65536"), 0, "pow #84");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-2"), (Dfp)this.factory.newDfp("-3")), this.factory.newDfp("-0.125"), 16, "pow #85");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-2"), (Dfp)this.factory.newDfp("-4")), this.factory.newDfp("0.0625"), 0, "pow #86");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("-2"), (Dfp)this.factory.newDfp("-4.1")), this.qnan, 17, "pow #87");
        this.test(DfpMath.pow((Dfp)this.factory.newDfp("2"), (Dfp)this.factory.newDfp("1.5")), this.factory.newDfp("2.8284271247461901"), 16, "pow #88");
    }

    @Test
    public void testSin() {
        this.test(DfpMath.sin((Dfp)this.pinf), this.nan, 17, "sin #1");
        this.test(DfpMath.sin((Dfp)this.nan), this.nan, 17, "sin #2");
        this.test(DfpMath.sin((Dfp)this.factory.getZero()), this.factory.getZero(), 16, "sin #3");
        this.test(DfpMath.sin((Dfp)this.factory.getPi()), this.factory.getZero(), 16, "sin #4");
        this.test(DfpMath.sin((Dfp)this.factory.getPi().negate()), this.factory.newDfp("-0"), 16, "sin #5");
        this.test(DfpMath.sin((Dfp)this.factory.getPi().multiply(2)), this.factory.getZero(), 16, "sin #6");
        this.test(DfpMath.sin((Dfp)this.factory.getPi().divide(2)), this.factory.getOne(), 16, "sin #7");
        this.test(DfpMath.sin((Dfp)this.factory.getPi().divide(2).negate()), this.factory.getOne().negate(), 16, "sin #8");
        this.test(DfpMath.sin((Dfp)DfpMath.atan((Dfp)this.factory.getOne())), this.factory.newDfp("0.5").sqrt(), 16, "sin #9");
        this.test(DfpMath.sin((Dfp)DfpMath.atan((Dfp)this.factory.getOne())).negate(), this.factory.newDfp("0.5").sqrt().negate(), 16, "sin #10");
        this.test(DfpMath.sin((Dfp)DfpMath.atan((Dfp)this.factory.getOne())).negate(), this.factory.newDfp("0.5").sqrt().negate(), 16, "sin #11");
        this.test(DfpMath.sin((Dfp)this.factory.newDfp("0.1")), this.factory.newDfp("0.0998334166468281523"), 16, "sin #12");
        this.test(DfpMath.sin((Dfp)this.factory.newDfp("0.2")), this.factory.newDfp("0.19866933079506121546"), 16, "sin #13");
        this.test(DfpMath.sin((Dfp)this.factory.newDfp("0.3")), this.factory.newDfp("0.2955202066613395751"), 16, "sin #14");
        this.test(DfpMath.sin((Dfp)this.factory.newDfp("0.4")), this.factory.newDfp("0.38941834230865049166"), 16, "sin #15");
        this.test(DfpMath.sin((Dfp)this.factory.newDfp("0.5")), this.factory.newDfp("0.47942553860420300026"), 16, "sin #16");
        this.test(DfpMath.sin((Dfp)this.factory.newDfp("0.6")), this.factory.newDfp("0.56464247339503535721"), 16, "sin #17");
        this.test(DfpMath.sin((Dfp)this.factory.newDfp("0.7")), this.factory.newDfp("0.64421768723769105367"), 16, "sin #18");
        this.test(DfpMath.sin((Dfp)this.factory.newDfp("0.8")), this.factory.newDfp("0.71735609089952276163"), 16, "sin #19");
        this.test(DfpMath.sin((Dfp)this.factory.newDfp("0.9")), this.factory.newDfp("0.78332690962748338847"), 16, "sin #20");
        this.test(DfpMath.sin((Dfp)this.factory.newDfp("1.0")), this.factory.newDfp("0.84147098480789650666"), 16, "sin #21");
        this.test(DfpMath.sin((Dfp)this.factory.newDfp("1.1")), this.factory.newDfp("0.89120736006143533995"), 16, "sin #22");
        this.test(DfpMath.sin((Dfp)this.factory.newDfp("1.2")), this.factory.newDfp("0.93203908596722634968"), 16, "sin #23");
        this.test(DfpMath.sin((Dfp)this.factory.newDfp("1.3")), this.factory.newDfp("0.9635581854171929647"), 16, "sin #24");
        this.test(DfpMath.sin((Dfp)this.factory.newDfp("1.4")), this.factory.newDfp("0.98544972998846018066"), 16, "sin #25");
        this.test(DfpMath.sin((Dfp)this.factory.newDfp("1.5")), this.factory.newDfp("0.99749498660405443096"), 16, "sin #26");
        this.test(DfpMath.sin((Dfp)this.factory.newDfp("1.6")), this.factory.newDfp("0.99957360304150516323"), 16, "sin #27");
    }
}

