/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.complex;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.complex.Complex;
import com.hazelcast.shaded.org.apache.commons.math3.complex.ComplexUtils;
import org.junit.Assert;
import org.junit.Test;

public class ComplexUtilsTest {
    private double inf = Double.POSITIVE_INFINITY;
    private double negInf = Double.NEGATIVE_INFINITY;
    private double nan = Double.NaN;
    private double pi = Math.PI;
    private Complex negInfInf = new Complex(this.negInf, this.inf);
    private Complex infNegInf = new Complex(this.inf, this.negInf);
    private Complex infInf = new Complex(this.inf, this.inf);
    private Complex negInfNegInf = new Complex(this.negInf, this.negInf);
    private Complex infNaN = new Complex(this.inf, this.nan);

    @Test
    public void testPolar2Complex() {
        TestUtils.assertEquals(Complex.ONE, ComplexUtils.polar2Complex((double)1.0, (double)0.0), 1.0E-11);
        TestUtils.assertEquals(Complex.ZERO, ComplexUtils.polar2Complex((double)0.0, (double)1.0), 1.0E-11);
        TestUtils.assertEquals(Complex.ZERO, ComplexUtils.polar2Complex((double)0.0, (double)-1.0), 1.0E-11);
        TestUtils.assertEquals(Complex.I, ComplexUtils.polar2Complex((double)1.0, (double)(this.pi / 2.0)), 1.0E-11);
        TestUtils.assertEquals(Complex.I.negate(), ComplexUtils.polar2Complex((double)1.0, (double)(-this.pi / 2.0)), 1.0E-11);
        double r = 0.0;
        for (int i = 0; i < 5; ++i) {
            int j;
            r += (double)i;
            double theta = 0.0;
            for (j = 0; j < 20; ++j) {
                TestUtils.assertEquals(this.altPolar(r, theta += this.pi / 6.0), ComplexUtils.polar2Complex((double)r, (double)theta), 1.0E-11);
            }
            theta = -2.0 * this.pi;
            for (j = 0; j < 20; ++j) {
                TestUtils.assertEquals(this.altPolar(r, theta -= this.pi / 6.0), ComplexUtils.polar2Complex((double)r, (double)theta), 1.0E-11);
            }
        }
    }

    protected Complex altPolar(double r, double theta) {
        return Complex.I.multiply(new Complex(theta, 0.0)).exp().multiply(new Complex(r, 0.0));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPolar2ComplexIllegalModulus() {
        ComplexUtils.polar2Complex((double)-1.0, (double)0.0);
    }

    @Test
    public void testPolar2ComplexNaN() {
        TestUtils.assertSame(Complex.NaN, ComplexUtils.polar2Complex((double)this.nan, (double)1.0));
        TestUtils.assertSame(Complex.NaN, ComplexUtils.polar2Complex((double)1.0, (double)this.nan));
        TestUtils.assertSame(Complex.NaN, ComplexUtils.polar2Complex((double)this.nan, (double)this.nan));
    }

    @Test
    public void testPolar2ComplexInf() {
        TestUtils.assertSame(Complex.NaN, ComplexUtils.polar2Complex((double)1.0, (double)this.inf));
        TestUtils.assertSame(Complex.NaN, ComplexUtils.polar2Complex((double)1.0, (double)this.negInf));
        TestUtils.assertSame(Complex.NaN, ComplexUtils.polar2Complex((double)this.inf, (double)this.inf));
        TestUtils.assertSame(Complex.NaN, ComplexUtils.polar2Complex((double)this.inf, (double)this.negInf));
        TestUtils.assertSame(this.infInf, ComplexUtils.polar2Complex((double)this.inf, (double)(this.pi / 4.0)));
        TestUtils.assertSame(this.infNaN, ComplexUtils.polar2Complex((double)this.inf, (double)0.0));
        TestUtils.assertSame(this.infNegInf, ComplexUtils.polar2Complex((double)this.inf, (double)(-this.pi / 4.0)));
        TestUtils.assertSame(this.negInfInf, ComplexUtils.polar2Complex((double)this.inf, (double)(3.0 * this.pi / 4.0)));
        TestUtils.assertSame(this.negInfNegInf, ComplexUtils.polar2Complex((double)this.inf, (double)(5.0 * this.pi / 4.0)));
    }

    @Test
    public void testConvertToComplex() {
        double[] real = new double[]{this.negInf, -123.45, 0.0, 1.0, 234.56, this.pi, this.inf};
        Complex[] complex = ComplexUtils.convertToComplex((double[])real);
        for (int i = 0; i < real.length; ++i) {
            Assert.assertEquals((double)real[i], (double)complex[i].getReal(), (double)0.0);
        }
    }
}

