/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.complex;

import com.hazelcast.shaded.org.apache.commons.math3.TestUtils;
import com.hazelcast.shaded.org.apache.commons.math3.complex.Complex;
import com.hazelcast.shaded.org.apache.commons.math3.complex.ComplexUtils;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;

public class ComplexTest {
    private double inf = Double.POSITIVE_INFINITY;
    private double neginf = Double.NEGATIVE_INFINITY;
    private double nan = Double.NaN;
    private double pi = Math.PI;
    private Complex oneInf = new Complex(1.0, this.inf);
    private Complex oneNegInf = new Complex(1.0, this.neginf);
    private Complex infOne = new Complex(this.inf, 1.0);
    private Complex infZero = new Complex(this.inf, 0.0);
    private Complex infNaN = new Complex(this.inf, this.nan);
    private Complex infNegInf = new Complex(this.inf, this.neginf);
    private Complex infInf = new Complex(this.inf, this.inf);
    private Complex negInfInf = new Complex(this.neginf, this.inf);
    private Complex negInfZero = new Complex(this.neginf, 0.0);
    private Complex negInfOne = new Complex(this.neginf, 1.0);
    private Complex negInfNaN = new Complex(this.neginf, this.nan);
    private Complex negInfNegInf = new Complex(this.neginf, this.neginf);
    private Complex oneNaN = new Complex(1.0, this.nan);
    private Complex zeroInf = new Complex(0.0, this.inf);
    private Complex zeroNaN = new Complex(0.0, this.nan);
    private Complex nanInf = new Complex(this.nan, this.inf);
    private Complex nanNegInf = new Complex(this.nan, this.neginf);
    private Complex nanZero = new Complex(this.nan, 0.0);

    @Test
    public void testConstructor() {
        Complex z = new Complex(3.0, 4.0);
        Assert.assertEquals((double)3.0, (double)z.getReal(), (double)1.0E-5);
        Assert.assertEquals((double)4.0, (double)z.getImaginary(), (double)1.0E-5);
    }

    @Test
    public void testConstructorNaN() {
        Complex z = new Complex(3.0, Double.NaN);
        Assert.assertTrue((boolean)z.isNaN());
        z = new Complex(this.nan, 4.0);
        Assert.assertTrue((boolean)z.isNaN());
        z = new Complex(3.0, 4.0);
        Assert.assertFalse((boolean)z.isNaN());
    }

    @Test
    public void testAbs() {
        Complex z = new Complex(3.0, 4.0);
        Assert.assertEquals((double)5.0, (double)z.abs(), (double)1.0E-5);
    }

    @Test
    public void testAbsNaN() {
        Assert.assertTrue((boolean)Double.isNaN(Complex.NaN.abs()));
        Complex z = new Complex(this.inf, this.nan);
        Assert.assertTrue((boolean)Double.isNaN(z.abs()));
    }

    @Test
    public void testAbsInfinite() {
        Complex z = new Complex(this.inf, 0.0);
        Assert.assertEquals((double)this.inf, (double)z.abs(), (double)0.0);
        z = new Complex(0.0, this.neginf);
        Assert.assertEquals((double)this.inf, (double)z.abs(), (double)0.0);
        z = new Complex(this.inf, this.neginf);
        Assert.assertEquals((double)this.inf, (double)z.abs(), (double)0.0);
    }

    @Test
    public void testAdd() {
        Complex x = new Complex(3.0, 4.0);
        Complex y = new Complex(5.0, 6.0);
        Complex z = x.add(y);
        Assert.assertEquals((double)8.0, (double)z.getReal(), (double)1.0E-5);
        Assert.assertEquals((double)10.0, (double)z.getImaginary(), (double)1.0E-5);
    }

    @Test
    public void testAddNaN() {
        Complex x = new Complex(3.0, 4.0);
        Complex z = x.add(Complex.NaN);
        Assert.assertSame((Object)Complex.NaN, (Object)z);
        z = new Complex(1.0, this.nan);
        Complex w = x.add(z);
        Assert.assertSame((Object)Complex.NaN, (Object)w);
    }

    @Test
    public void testAddInf() {
        Complex x = new Complex(1.0, 1.0);
        Complex z = new Complex(this.inf, 0.0);
        Complex w = x.add(z);
        Assert.assertEquals((double)w.getImaginary(), (double)1.0, (double)0.0);
        Assert.assertEquals((double)this.inf, (double)w.getReal(), (double)0.0);
        x = new Complex(this.neginf, 0.0);
        Assert.assertTrue((boolean)Double.isNaN(x.add(z).getReal()));
    }

    @Test
    public void testScalarAdd() {
        Complex x = new Complex(3.0, 4.0);
        double yDouble = 2.0;
        Complex yComplex = new Complex(yDouble);
        Assert.assertEquals((Object)x.add(yComplex), (Object)x.add(yDouble));
    }

    @Test
    public void testScalarAddNaN() {
        Complex x = new Complex(3.0, 4.0);
        double yDouble = Double.NaN;
        Complex yComplex = new Complex(yDouble);
        Assert.assertEquals((Object)x.add(yComplex), (Object)x.add(yDouble));
    }

    @Test
    public void testScalarAddInf() {
        Complex x = new Complex(1.0, 1.0);
        double yDouble = Double.POSITIVE_INFINITY;
        Complex yComplex = new Complex(yDouble);
        Assert.assertEquals((Object)x.add(yComplex), (Object)x.add(yDouble));
        x = new Complex(this.neginf, 0.0);
        Assert.assertEquals((Object)x.add(yComplex), (Object)x.add(yDouble));
    }

    @Test
    public void testConjugate() {
        Complex x = new Complex(3.0, 4.0);
        Complex z = x.conjugate();
        Assert.assertEquals((double)3.0, (double)z.getReal(), (double)1.0E-5);
        Assert.assertEquals((double)-4.0, (double)z.getImaginary(), (double)1.0E-5);
    }

    @Test
    public void testConjugateNaN() {
        Complex z = Complex.NaN.conjugate();
        Assert.assertTrue((boolean)z.isNaN());
    }

    @Test
    public void testConjugateInfiinite() {
        Complex z = new Complex(0.0, this.inf);
        Assert.assertEquals((double)this.neginf, (double)z.conjugate().getImaginary(), (double)0.0);
        z = new Complex(0.0, this.neginf);
        Assert.assertEquals((double)this.inf, (double)z.conjugate().getImaginary(), (double)0.0);
    }

    @Test
    public void testDivide() {
        Complex x = new Complex(3.0, 4.0);
        Complex y = new Complex(5.0, 6.0);
        Complex z = x.divide(y);
        Assert.assertEquals((double)0.639344262295082, (double)z.getReal(), (double)1.0E-5);
        Assert.assertEquals((double)0.03278688524590164, (double)z.getImaginary(), (double)1.0E-5);
    }

    @Test
    public void testDivideReal() {
        Complex x = new Complex(2.0, 3.0);
        Complex y = new Complex(2.0, 0.0);
        Assert.assertEquals((Object)new Complex(1.0, 1.5), (Object)x.divide(y));
    }

    @Test
    public void testDivideImaginary() {
        Complex x = new Complex(2.0, 3.0);
        Complex y = new Complex(0.0, 2.0);
        Assert.assertEquals((Object)new Complex(1.5, -1.0), (Object)x.divide(y));
    }

    @Test
    public void testDivideInf() {
        Complex x = new Complex(3.0, 4.0);
        Complex w = new Complex(this.neginf, this.inf);
        Assert.assertTrue((boolean)x.divide(w).equals((Object)Complex.ZERO));
        Complex z = w.divide(x);
        Assert.assertTrue((boolean)Double.isNaN(z.getReal()));
        Assert.assertEquals((double)this.inf, (double)z.getImaginary(), (double)0.0);
        w = new Complex(this.inf, this.inf);
        z = w.divide(x);
        Assert.assertTrue((boolean)Double.isNaN(z.getImaginary()));
        Assert.assertEquals((double)this.inf, (double)z.getReal(), (double)0.0);
        w = new Complex(1.0, this.inf);
        z = w.divide(w);
        Assert.assertTrue((boolean)Double.isNaN(z.getReal()));
        Assert.assertTrue((boolean)Double.isNaN(z.getImaginary()));
    }

    @Test
    public void testDivideZero() {
        Complex x = new Complex(3.0, 4.0);
        Complex z = x.divide(Complex.ZERO);
        Assert.assertEquals((Object)z, (Object)Complex.NaN);
    }

    @Test
    public void testDivideZeroZero() {
        Complex x = new Complex(0.0, 0.0);
        Complex z = x.divide(Complex.ZERO);
        Assert.assertEquals((Object)z, (Object)Complex.NaN);
    }

    @Test
    public void testDivideNaN() {
        Complex x = new Complex(3.0, 4.0);
        Complex z = x.divide(Complex.NaN);
        Assert.assertTrue((boolean)z.isNaN());
    }

    @Test
    public void testDivideNaNInf() {
        Complex z = this.oneInf.divide(Complex.ONE);
        Assert.assertTrue((boolean)Double.isNaN(z.getReal()));
        Assert.assertEquals((double)this.inf, (double)z.getImaginary(), (double)0.0);
        z = this.negInfNegInf.divide(this.oneNaN);
        Assert.assertTrue((boolean)Double.isNaN(z.getReal()));
        Assert.assertTrue((boolean)Double.isNaN(z.getImaginary()));
        z = this.negInfInf.divide(Complex.ONE);
        Assert.assertTrue((boolean)Double.isNaN(z.getReal()));
        Assert.assertTrue((boolean)Double.isNaN(z.getImaginary()));
    }

    @Test
    public void testScalarDivide() {
        Complex x = new Complex(3.0, 4.0);
        double yDouble = 2.0;
        Complex yComplex = new Complex(yDouble);
        Assert.assertEquals((Object)x.divide(yComplex), (Object)x.divide(yDouble));
    }

    @Test
    public void testScalarDivideNaN() {
        Complex x = new Complex(3.0, 4.0);
        double yDouble = Double.NaN;
        Complex yComplex = new Complex(yDouble);
        Assert.assertEquals((Object)x.divide(yComplex), (Object)x.divide(yDouble));
    }

    @Test
    public void testScalarDivideInf() {
        Complex x = new Complex(1.0, 1.0);
        double yDouble = Double.POSITIVE_INFINITY;
        Complex yComplex = new Complex(yDouble);
        TestUtils.assertEquals(x.divide(yComplex), x.divide(yDouble), 0.0);
        yDouble = Double.NEGATIVE_INFINITY;
        yComplex = new Complex(yDouble);
        TestUtils.assertEquals(x.divide(yComplex), x.divide(yDouble), 0.0);
        x = new Complex(1.0, Double.NEGATIVE_INFINITY);
        TestUtils.assertEquals(x.divide(yComplex), x.divide(yDouble), 0.0);
    }

    @Test
    public void testScalarDivideZero() {
        Complex x = new Complex(1.0, 1.0);
        TestUtils.assertEquals(x.divide(Complex.ZERO), x.divide(0.0), 0.0);
    }

    @Test
    public void testReciprocal() {
        Complex z = new Complex(5.0, 6.0);
        Complex act = z.reciprocal();
        double expRe = 0.08196721311475409;
        double expIm = -0.09836065573770492;
        Assert.assertEquals((double)expRe, (double)act.getReal(), (double)FastMath.ulp((double)expRe));
        Assert.assertEquals((double)expIm, (double)act.getImaginary(), (double)FastMath.ulp((double)expIm));
    }

    @Test
    public void testReciprocalReal() {
        Complex z = new Complex(-2.0, 0.0);
        Assert.assertTrue((boolean)Complex.equals((Complex)new Complex(-0.5, 0.0), (Complex)z.reciprocal()));
    }

    @Test
    public void testReciprocalImaginary() {
        Complex z = new Complex(0.0, -2.0);
        Assert.assertEquals((Object)new Complex(0.0, 0.5), (Object)z.reciprocal());
    }

    @Test
    public void testReciprocalInf() {
        Complex z = new Complex(this.neginf, this.inf);
        Assert.assertTrue((boolean)z.reciprocal().equals((Object)Complex.ZERO));
        z = new Complex(1.0, this.inf).reciprocal();
        Assert.assertEquals((Object)z, (Object)Complex.ZERO);
    }

    @Test
    public void testReciprocalZero() {
        Assert.assertEquals((Object)Complex.ZERO.reciprocal(), (Object)Complex.INF);
    }

    @Test
    public void testReciprocalNaN() {
        Assert.assertTrue((boolean)Complex.NaN.reciprocal().isNaN());
    }

    @Test
    public void testMultiply() {
        Complex x = new Complex(3.0, 4.0);
        Complex y = new Complex(5.0, 6.0);
        Complex z = x.multiply(y);
        Assert.assertEquals((double)-9.0, (double)z.getReal(), (double)1.0E-5);
        Assert.assertEquals((double)38.0, (double)z.getImaginary(), (double)1.0E-5);
    }

    @Test
    public void testMultiplyNaN() {
        Complex x = new Complex(3.0, 4.0);
        Complex z = x.multiply(Complex.NaN);
        Assert.assertSame((Object)Complex.NaN, (Object)z);
        z = Complex.NaN.multiply(5);
        Assert.assertSame((Object)Complex.NaN, (Object)z);
    }

    @Test
    public void testMultiplyInfInf() {
        Assert.assertTrue((boolean)this.infInf.multiply(this.infInf).isInfinite());
    }

    @Test
    public void testMultiplyNaNInf() {
        Complex z = new Complex(1.0, 1.0);
        Complex w = z.multiply(this.infOne);
        Assert.assertEquals((double)w.getReal(), (double)this.inf, (double)0.0);
        Assert.assertEquals((double)w.getImaginary(), (double)this.inf, (double)0.0);
        Assert.assertTrue((boolean)new Complex(1.0, 0.0).multiply(this.infInf).equals((Object)Complex.INF));
        Assert.assertTrue((boolean)new Complex(-1.0, 0.0).multiply(this.infInf).equals((Object)Complex.INF));
        Assert.assertTrue((boolean)new Complex(1.0, 0.0).multiply(this.negInfZero).equals((Object)Complex.INF));
        w = this.oneInf.multiply(this.oneNegInf);
        Assert.assertEquals((double)w.getReal(), (double)this.inf, (double)0.0);
        Assert.assertEquals((double)w.getImaginary(), (double)this.inf, (double)0.0);
        w = this.negInfNegInf.multiply(this.oneNaN);
        Assert.assertTrue((boolean)Double.isNaN(w.getReal()));
        Assert.assertTrue((boolean)Double.isNaN(w.getImaginary()));
        z = new Complex(1.0, this.neginf);
        Assert.assertSame((Object)Complex.INF, (Object)z.multiply(z));
    }

    @Test
    public void testScalarMultiply() {
        Complex x = new Complex(3.0, 4.0);
        double yDouble = 2.0;
        Complex yComplex = new Complex(yDouble);
        Assert.assertEquals((Object)x.multiply(yComplex), (Object)x.multiply(yDouble));
        int zInt = -5;
        Complex zComplex = new Complex((double)zInt);
        Assert.assertEquals((Object)x.multiply(zComplex), (Object)x.multiply(zInt));
    }

    @Test
    public void testScalarMultiplyNaN() {
        Complex x = new Complex(3.0, 4.0);
        double yDouble = Double.NaN;
        Complex yComplex = new Complex(yDouble);
        Assert.assertEquals((Object)x.multiply(yComplex), (Object)x.multiply(yDouble));
    }

    @Test
    public void testScalarMultiplyInf() {
        Complex x = new Complex(1.0, 1.0);
        double yDouble = Double.POSITIVE_INFINITY;
        Complex yComplex = new Complex(yDouble);
        Assert.assertEquals((Object)x.multiply(yComplex), (Object)x.multiply(yDouble));
        yDouble = Double.NEGATIVE_INFINITY;
        yComplex = new Complex(yDouble);
        Assert.assertEquals((Object)x.multiply(yComplex), (Object)x.multiply(yDouble));
    }

    @Test
    public void testNegate() {
        Complex x = new Complex(3.0, 4.0);
        Complex z = x.negate();
        Assert.assertEquals((double)-3.0, (double)z.getReal(), (double)1.0E-5);
        Assert.assertEquals((double)-4.0, (double)z.getImaginary(), (double)1.0E-5);
    }

    @Test
    public void testNegateNaN() {
        Complex z = Complex.NaN.negate();
        Assert.assertTrue((boolean)z.isNaN());
    }

    @Test
    public void testSubtract() {
        Complex x = new Complex(3.0, 4.0);
        Complex y = new Complex(5.0, 6.0);
        Complex z = x.subtract(y);
        Assert.assertEquals((double)-2.0, (double)z.getReal(), (double)1.0E-5);
        Assert.assertEquals((double)-2.0, (double)z.getImaginary(), (double)1.0E-5);
    }

    @Test
    public void testSubtractNaN() {
        Complex x = new Complex(3.0, 4.0);
        Complex z = x.subtract(Complex.NaN);
        Assert.assertSame((Object)Complex.NaN, (Object)z);
        z = new Complex(1.0, this.nan);
        Complex w = x.subtract(z);
        Assert.assertSame((Object)Complex.NaN, (Object)w);
    }

    @Test
    public void testSubtractInf() {
        Complex x = new Complex(1.0, 1.0);
        Complex z = new Complex(this.neginf, 0.0);
        Complex w = x.subtract(z);
        Assert.assertEquals((double)w.getImaginary(), (double)1.0, (double)0.0);
        Assert.assertEquals((double)this.inf, (double)w.getReal(), (double)0.0);
        x = new Complex(this.neginf, 0.0);
        Assert.assertTrue((boolean)Double.isNaN(x.subtract(z).getReal()));
    }

    @Test
    public void testScalarSubtract() {
        Complex x = new Complex(3.0, 4.0);
        double yDouble = 2.0;
        Complex yComplex = new Complex(yDouble);
        Assert.assertEquals((Object)x.subtract(yComplex), (Object)x.subtract(yDouble));
    }

    @Test
    public void testScalarSubtractNaN() {
        Complex x = new Complex(3.0, 4.0);
        double yDouble = Double.NaN;
        Complex yComplex = new Complex(yDouble);
        Assert.assertEquals((Object)x.subtract(yComplex), (Object)x.subtract(yDouble));
    }

    @Test
    public void testScalarSubtractInf() {
        Complex x = new Complex(1.0, 1.0);
        double yDouble = Double.POSITIVE_INFINITY;
        Complex yComplex = new Complex(yDouble);
        Assert.assertEquals((Object)x.subtract(yComplex), (Object)x.subtract(yDouble));
        x = new Complex(this.neginf, 0.0);
        Assert.assertEquals((Object)x.subtract(yComplex), (Object)x.subtract(yDouble));
    }

    @Test
    public void testEqualsNull() {
        Complex x = new Complex(3.0, 4.0);
        Assert.assertFalse((boolean)x.equals(null));
    }

    @Test(expected=NullPointerException.class)
    public void testFloatingPointEqualsPrecondition1() {
        Complex.equals((Complex)new Complex(3.0, 4.0), null, (int)3);
    }

    @Test(expected=NullPointerException.class)
    public void testFloatingPointEqualsPrecondition2() {
        Complex.equals(null, (Complex)new Complex(3.0, 4.0), (int)3);
    }

    @Test
    public void testEqualsClass() {
        Complex x = new Complex(3.0, 4.0);
        Assert.assertFalse((boolean)x.equals((Object)this));
    }

    @Test
    public void testEqualsSame() {
        Complex x = new Complex(3.0, 4.0);
        Assert.assertTrue((boolean)x.equals((Object)x));
    }

    @Test
    public void testFloatingPointEquals() {
        double re = -3.21;
        double im = 4.56789E15;
        Complex x = new Complex(re, im);
        Complex y = new Complex(re, im);
        Assert.assertTrue((boolean)x.equals((Object)y));
        Assert.assertTrue((boolean)Complex.equals((Complex)x, (Complex)y));
        int maxUlps = 5;
        for (int i = 0; i < 5; ++i) {
            re = FastMath.nextUp((double)re);
            im = FastMath.nextUp((double)im);
        }
        y = new Complex(re, im);
        Assert.assertTrue((boolean)Complex.equals((Complex)x, (Complex)y, (int)5));
        re = FastMath.nextUp((double)re);
        im = FastMath.nextUp((double)im);
        y = new Complex(re, im);
        Assert.assertFalse((boolean)Complex.equals((Complex)x, (Complex)y, (int)5));
    }

    @Test
    public void testFloatingPointEqualsNaN() {
        Complex c = new Complex(Double.NaN, 1.0);
        Assert.assertFalse((boolean)Complex.equals((Complex)c, (Complex)c));
        c = new Complex(1.0, Double.NaN);
        Assert.assertFalse((boolean)Complex.equals((Complex)c, (Complex)c));
    }

    @Test
    public void testFloatingPointEqualsWithAllowedDelta() {
        double re = 153.0;
        double im = 152.9375;
        double tol1 = 0.0625;
        Complex x = new Complex(153.0, 152.9375);
        Complex y = new Complex(153.0625, 153.0);
        Assert.assertTrue((boolean)Complex.equals((Complex)x, (Complex)y, (double)0.0625));
        double tol2 = 0.0624;
        Assert.assertFalse((boolean)Complex.equals((Complex)x, (Complex)y, (double)0.0624));
    }

    @Test
    public void testFloatingPointEqualsWithAllowedDeltaNaN() {
        Complex x = new Complex(0.0, Double.NaN);
        Complex y = new Complex(Double.NaN, 0.0);
        Assert.assertFalse((boolean)Complex.equals((Complex)x, (Complex)Complex.ZERO, (double)0.1));
        Assert.assertFalse((boolean)Complex.equals((Complex)x, (Complex)x, (double)0.1));
        Assert.assertFalse((boolean)Complex.equals((Complex)x, (Complex)y, (double)0.1));
    }

    @Test
    public void testFloatingPointEqualsWithRelativeTolerance() {
        double tol = 1.0E-4;
        double re = 1.0;
        double im = 1.0E10;
        double f = 1.0001;
        Complex x = new Complex(1.0, 1.0E10);
        Complex y = new Complex(1.0001, 1.0001E10);
        Assert.assertTrue((boolean)Complex.equalsWithRelativeTolerance((Complex)x, (Complex)y, (double)1.0E-4));
    }

    @Test
    public void testFloatingPointEqualsWithRelativeToleranceNaN() {
        Complex x = new Complex(0.0, Double.NaN);
        Complex y = new Complex(Double.NaN, 0.0);
        Assert.assertFalse((boolean)Complex.equalsWithRelativeTolerance((Complex)x, (Complex)Complex.ZERO, (double)0.1));
        Assert.assertFalse((boolean)Complex.equalsWithRelativeTolerance((Complex)x, (Complex)x, (double)0.1));
        Assert.assertFalse((boolean)Complex.equalsWithRelativeTolerance((Complex)x, (Complex)y, (double)0.1));
    }

    @Test
    public void testEqualsTrue() {
        Complex x = new Complex(3.0, 4.0);
        Complex y = new Complex(3.0, 4.0);
        Assert.assertTrue((boolean)x.equals((Object)y));
    }

    @Test
    public void testEqualsRealDifference() {
        Complex x = new Complex(0.0, 0.0);
        Complex y = new Complex(Double.MIN_VALUE, 0.0);
        Assert.assertFalse((boolean)x.equals((Object)y));
    }

    @Test
    public void testEqualsImaginaryDifference() {
        Complex x = new Complex(0.0, 0.0);
        Complex y = new Complex(0.0, Double.MIN_VALUE);
        Assert.assertFalse((boolean)x.equals((Object)y));
    }

    @Test
    public void testEqualsNaN() {
        Complex realNaN = new Complex(Double.NaN, 0.0);
        Complex imaginaryNaN = new Complex(0.0, Double.NaN);
        Complex complexNaN = Complex.NaN;
        Assert.assertTrue((boolean)realNaN.equals((Object)imaginaryNaN));
        Assert.assertTrue((boolean)imaginaryNaN.equals((Object)complexNaN));
        Assert.assertTrue((boolean)realNaN.equals((Object)complexNaN));
    }

    @Test
    public void testHashCode() {
        Complex x = new Complex(0.0, 0.0);
        Complex y = new Complex(0.0, Double.MIN_VALUE);
        Assert.assertFalse((x.hashCode() == y.hashCode() ? 1 : 0) != 0);
        y = new Complex(Double.MIN_VALUE, 0.0);
        Assert.assertFalse((x.hashCode() == y.hashCode() ? 1 : 0) != 0);
        Complex realNaN = new Complex(Double.NaN, 0.0);
        Complex imaginaryNaN = new Complex(0.0, Double.NaN);
        Assert.assertEquals((long)realNaN.hashCode(), (long)imaginaryNaN.hashCode());
        Assert.assertEquals((long)imaginaryNaN.hashCode(), (long)Complex.NaN.hashCode());
        String msg = "'equals' not compatible with 'hashCode'";
        x = new Complex(0.0, 0.0);
        y = new Complex(0.0, -0.0);
        Assert.assertTrue((x.hashCode() != y.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((String)"'equals' not compatible with 'hashCode'", (boolean)x.equals((Object)y));
        x = new Complex(0.0, 0.0);
        y = new Complex(-0.0, 0.0);
        Assert.assertTrue((x.hashCode() != y.hashCode() ? 1 : 0) != 0);
        Assert.assertFalse((String)"'equals' not compatible with 'hashCode'", (boolean)x.equals((Object)y));
    }

    @Test
    public void testAcos() {
        Complex z = new Complex(3.0, 4.0);
        Complex expected = new Complex(0.936812, -2.30551);
        TestUtils.assertEquals(expected, z.acos(), 1.0E-5);
        TestUtils.assertEquals(new Complex(FastMath.acos((double)0.0), 0.0), Complex.ZERO.acos(), 1.0E-12);
    }

    @Test
    public void testAcosInf() {
        TestUtils.assertSame(Complex.NaN, this.oneInf.acos());
        TestUtils.assertSame(Complex.NaN, this.oneNegInf.acos());
        TestUtils.assertSame(Complex.NaN, this.infOne.acos());
        TestUtils.assertSame(Complex.NaN, this.negInfOne.acos());
        TestUtils.assertSame(Complex.NaN, this.infInf.acos());
        TestUtils.assertSame(Complex.NaN, this.infNegInf.acos());
        TestUtils.assertSame(Complex.NaN, this.negInfInf.acos());
        TestUtils.assertSame(Complex.NaN, this.negInfNegInf.acos());
    }

    @Test
    public void testAcosNaN() {
        Assert.assertTrue((boolean)Complex.NaN.acos().isNaN());
    }

    @Test
    public void testAsin() {
        Complex z = new Complex(3.0, 4.0);
        Complex expected = new Complex(0.633984, 2.30551);
        TestUtils.assertEquals(expected, z.asin(), 1.0E-5);
    }

    @Test
    public void testAsinNaN() {
        Assert.assertTrue((boolean)Complex.NaN.asin().isNaN());
    }

    @Test
    public void testAsinInf() {
        TestUtils.assertSame(Complex.NaN, this.oneInf.asin());
        TestUtils.assertSame(Complex.NaN, this.oneNegInf.asin());
        TestUtils.assertSame(Complex.NaN, this.infOne.asin());
        TestUtils.assertSame(Complex.NaN, this.negInfOne.asin());
        TestUtils.assertSame(Complex.NaN, this.infInf.asin());
        TestUtils.assertSame(Complex.NaN, this.infNegInf.asin());
        TestUtils.assertSame(Complex.NaN, this.negInfInf.asin());
        TestUtils.assertSame(Complex.NaN, this.negInfNegInf.asin());
    }

    @Test
    public void testAtan() {
        Complex z = new Complex(3.0, 4.0);
        Complex expected = new Complex(1.44831, 0.158997);
        TestUtils.assertEquals(expected, z.atan(), 1.0E-5);
    }

    @Test
    public void testAtanInf() {
        TestUtils.assertSame(Complex.NaN, this.oneInf.atan());
        TestUtils.assertSame(Complex.NaN, this.oneNegInf.atan());
        TestUtils.assertSame(Complex.NaN, this.infOne.atan());
        TestUtils.assertSame(Complex.NaN, this.negInfOne.atan());
        TestUtils.assertSame(Complex.NaN, this.infInf.atan());
        TestUtils.assertSame(Complex.NaN, this.infNegInf.atan());
        TestUtils.assertSame(Complex.NaN, this.negInfInf.atan());
        TestUtils.assertSame(Complex.NaN, this.negInfNegInf.atan());
    }

    @Test
    public void testAtanI() {
        Assert.assertTrue((boolean)Complex.I.atan().isNaN());
    }

    @Test
    public void testAtanNaN() {
        Assert.assertTrue((boolean)Complex.NaN.atan().isNaN());
    }

    @Test
    public void testCos() {
        Complex z = new Complex(3.0, 4.0);
        Complex expected = new Complex(-27.03495, -3.851153);
        TestUtils.assertEquals(expected, z.cos(), 1.0E-5);
    }

    @Test
    public void testCosNaN() {
        Assert.assertTrue((boolean)Complex.NaN.cos().isNaN());
    }

    @Test
    public void testCosInf() {
        TestUtils.assertSame(this.infNegInf, this.oneInf.cos());
        TestUtils.assertSame(this.infInf, this.oneNegInf.cos());
        TestUtils.assertSame(Complex.NaN, this.infOne.cos());
        TestUtils.assertSame(Complex.NaN, this.negInfOne.cos());
        TestUtils.assertSame(Complex.NaN, this.infInf.cos());
        TestUtils.assertSame(Complex.NaN, this.infNegInf.cos());
        TestUtils.assertSame(Complex.NaN, this.negInfInf.cos());
        TestUtils.assertSame(Complex.NaN, this.negInfNegInf.cos());
    }

    @Test
    public void testCosh() {
        Complex z = new Complex(3.0, 4.0);
        Complex expected = new Complex(-6.58066, -7.58155);
        TestUtils.assertEquals(expected, z.cosh(), 1.0E-5);
    }

    @Test
    public void testCoshNaN() {
        Assert.assertTrue((boolean)Complex.NaN.cosh().isNaN());
    }

    @Test
    public void testCoshInf() {
        TestUtils.assertSame(Complex.NaN, this.oneInf.cosh());
        TestUtils.assertSame(Complex.NaN, this.oneNegInf.cosh());
        TestUtils.assertSame(this.infInf, this.infOne.cosh());
        TestUtils.assertSame(this.infNegInf, this.negInfOne.cosh());
        TestUtils.assertSame(Complex.NaN, this.infInf.cosh());
        TestUtils.assertSame(Complex.NaN, this.infNegInf.cosh());
        TestUtils.assertSame(Complex.NaN, this.negInfInf.cosh());
        TestUtils.assertSame(Complex.NaN, this.negInfNegInf.cosh());
    }

    @Test
    public void testExp() {
        Complex z = new Complex(3.0, 4.0);
        Complex expected = new Complex(-13.12878, -15.20078);
        TestUtils.assertEquals(expected, z.exp(), 1.0E-5);
        TestUtils.assertEquals(Complex.ONE, Complex.ZERO.exp(), 1.0E-11);
        Complex iPi = Complex.I.multiply(new Complex(this.pi, 0.0));
        TestUtils.assertEquals(Complex.ONE.negate(), iPi.exp(), 1.0E-11);
    }

    @Test
    public void testExpNaN() {
        Assert.assertTrue((boolean)Complex.NaN.exp().isNaN());
    }

    @Test
    public void testExpInf1() {
        TestUtils.assertSame(Complex.NaN, this.oneInf.exp());
    }

    @Test
    public void testExpInf2() {
        TestUtils.assertSame(Complex.NaN, this.oneNegInf.exp());
    }

    @Test
    public void testExpInf3() {
        TestUtils.assertSame(this.infInf, this.infOne.exp());
    }

    @Test
    public void testExpInf4() {
        Complex exp = this.negInfOne.exp();
        TestUtils.assertSame(Complex.ZERO, exp);
    }

    @Test
    public void testExpInf5() {
        TestUtils.assertSame(Complex.NaN, this.infInf.exp());
    }

    @Test
    public void testExpInf6() {
        TestUtils.assertSame(Complex.NaN, this.infNegInf.exp());
    }

    @Test
    public void testExpInf7() {
        TestUtils.assertSame(Complex.NaN, this.negInfInf.exp());
    }

    @Test
    public void testExpInf8() {
        TestUtils.assertSame(Complex.NaN, this.negInfNegInf.exp());
    }

    @Test
    public void testLog() {
        Complex z = new Complex(3.0, 4.0);
        Complex expected = new Complex(1.60944, 0.927295);
        TestUtils.assertEquals(expected, z.log(), 1.0E-5);
    }

    @Test
    public void testLogNaN() {
        Assert.assertTrue((boolean)Complex.NaN.log().isNaN());
    }

    @Test
    public void testLogInf() {
        TestUtils.assertEquals(new Complex(this.inf, this.pi / 2.0), this.oneInf.log(), 1.0E-11);
        TestUtils.assertEquals(new Complex(this.inf, -this.pi / 2.0), this.oneNegInf.log(), 1.0E-11);
        TestUtils.assertEquals(this.infZero, this.infOne.log(), 1.0E-11);
        TestUtils.assertEquals(new Complex(this.inf, this.pi), this.negInfOne.log(), 1.0E-11);
        TestUtils.assertEquals(new Complex(this.inf, this.pi / 4.0), this.infInf.log(), 1.0E-11);
        TestUtils.assertEquals(new Complex(this.inf, -this.pi / 4.0), this.infNegInf.log(), 1.0E-11);
        TestUtils.assertEquals(new Complex(this.inf, 3.0 * this.pi / 4.0), this.negInfInf.log(), 1.0E-11);
        TestUtils.assertEquals(new Complex(this.inf, -3.0 * this.pi / 4.0), this.negInfNegInf.log(), 1.0E-11);
    }

    @Test
    public void testLogZero() {
        TestUtils.assertSame(this.negInfZero, Complex.ZERO.log());
    }

    @Test
    public void testPow() {
        Complex x = new Complex(3.0, 4.0);
        Complex y = new Complex(5.0, 6.0);
        Complex expected = new Complex(-1.860893, 11.83677);
        TestUtils.assertEquals(expected, x.pow(y), 1.0E-5);
    }

    @Test
    public void testPowNaNBase() {
        Complex x = new Complex(3.0, 4.0);
        Assert.assertTrue((boolean)Complex.NaN.pow(x).isNaN());
    }

    @Test
    public void testPowNaNExponent() {
        Complex x = new Complex(3.0, 4.0);
        Assert.assertTrue((boolean)x.pow(Complex.NaN).isNaN());
    }

    @Test
    public void testPowInf() {
        TestUtils.assertSame(Complex.NaN, Complex.ONE.pow(this.oneInf));
        TestUtils.assertSame(Complex.NaN, Complex.ONE.pow(this.oneNegInf));
        TestUtils.assertSame(Complex.NaN, Complex.ONE.pow(this.infOne));
        TestUtils.assertSame(Complex.NaN, Complex.ONE.pow(this.infInf));
        TestUtils.assertSame(Complex.NaN, Complex.ONE.pow(this.infNegInf));
        TestUtils.assertSame(Complex.NaN, Complex.ONE.pow(this.negInfInf));
        TestUtils.assertSame(Complex.NaN, Complex.ONE.pow(this.negInfNegInf));
        TestUtils.assertSame(Complex.NaN, this.infOne.pow(Complex.ONE));
        TestUtils.assertSame(Complex.NaN, this.negInfOne.pow(Complex.ONE));
        TestUtils.assertSame(Complex.NaN, this.infInf.pow(Complex.ONE));
        TestUtils.assertSame(Complex.NaN, this.infNegInf.pow(Complex.ONE));
        TestUtils.assertSame(Complex.NaN, this.negInfInf.pow(Complex.ONE));
        TestUtils.assertSame(Complex.NaN, this.negInfNegInf.pow(Complex.ONE));
        TestUtils.assertSame(Complex.NaN, this.negInfNegInf.pow(this.infNegInf));
        TestUtils.assertSame(Complex.NaN, this.negInfNegInf.pow(this.negInfNegInf));
        TestUtils.assertSame(Complex.NaN, this.negInfNegInf.pow(this.infInf));
        TestUtils.assertSame(Complex.NaN, this.infInf.pow(this.infNegInf));
        TestUtils.assertSame(Complex.NaN, this.infInf.pow(this.negInfNegInf));
        TestUtils.assertSame(Complex.NaN, this.infInf.pow(this.infInf));
        TestUtils.assertSame(Complex.NaN, this.infNegInf.pow(this.infNegInf));
        TestUtils.assertSame(Complex.NaN, this.infNegInf.pow(this.negInfNegInf));
        TestUtils.assertSame(Complex.NaN, this.infNegInf.pow(this.infInf));
    }

    @Test
    public void testPowZero() {
        TestUtils.assertSame(Complex.NaN, Complex.ZERO.pow(Complex.ONE));
        TestUtils.assertSame(Complex.NaN, Complex.ZERO.pow(Complex.ZERO));
        TestUtils.assertSame(Complex.NaN, Complex.ZERO.pow(Complex.I));
        TestUtils.assertEquals(Complex.ONE, Complex.ONE.pow(Complex.ZERO), 1.0E-11);
        TestUtils.assertEquals(Complex.ONE, Complex.I.pow(Complex.ZERO), 1.0E-11);
        TestUtils.assertEquals(Complex.ONE, new Complex(-1.0, 3.0).pow(Complex.ZERO), 1.0E-11);
    }

    @Test
    public void testScalarPow() {
        Complex x = new Complex(3.0, 4.0);
        double yDouble = 5.0;
        Complex yComplex = new Complex(yDouble);
        Assert.assertEquals((Object)x.pow(yComplex), (Object)x.pow(yDouble));
    }

    @Test
    public void testScalarPowNaNBase() {
        Complex x = Complex.NaN;
        double yDouble = 5.0;
        Complex yComplex = new Complex(yDouble);
        Assert.assertEquals((Object)x.pow(yComplex), (Object)x.pow(yDouble));
    }

    @Test
    public void testScalarPowNaNExponent() {
        Complex x = new Complex(3.0, 4.0);
        double yDouble = Double.NaN;
        Complex yComplex = new Complex(yDouble);
        Assert.assertEquals((Object)x.pow(yComplex), (Object)x.pow(yDouble));
    }

    @Test
    public void testScalarPowInf() {
        TestUtils.assertSame(Complex.NaN, Complex.ONE.pow(Double.POSITIVE_INFINITY));
        TestUtils.assertSame(Complex.NaN, Complex.ONE.pow(Double.NEGATIVE_INFINITY));
        TestUtils.assertSame(Complex.NaN, this.infOne.pow(1.0));
        TestUtils.assertSame(Complex.NaN, this.negInfOne.pow(1.0));
        TestUtils.assertSame(Complex.NaN, this.infInf.pow(1.0));
        TestUtils.assertSame(Complex.NaN, this.infNegInf.pow(1.0));
        TestUtils.assertSame(Complex.NaN, this.negInfInf.pow(10.0));
        TestUtils.assertSame(Complex.NaN, this.negInfNegInf.pow(1.0));
        TestUtils.assertSame(Complex.NaN, this.negInfNegInf.pow(Double.POSITIVE_INFINITY));
        TestUtils.assertSame(Complex.NaN, this.negInfNegInf.pow(Double.POSITIVE_INFINITY));
        TestUtils.assertSame(Complex.NaN, this.infInf.pow(Double.POSITIVE_INFINITY));
        TestUtils.assertSame(Complex.NaN, this.infInf.pow(Double.NEGATIVE_INFINITY));
        TestUtils.assertSame(Complex.NaN, this.infNegInf.pow(Double.NEGATIVE_INFINITY));
        TestUtils.assertSame(Complex.NaN, this.infNegInf.pow(Double.POSITIVE_INFINITY));
    }

    @Test
    public void testScalarPowZero() {
        TestUtils.assertSame(Complex.NaN, Complex.ZERO.pow(1.0));
        TestUtils.assertSame(Complex.NaN, Complex.ZERO.pow(0.0));
        TestUtils.assertEquals(Complex.ONE, Complex.ONE.pow(0.0), 1.0E-11);
        TestUtils.assertEquals(Complex.ONE, Complex.I.pow(0.0), 1.0E-11);
        TestUtils.assertEquals(Complex.ONE, new Complex(-1.0, 3.0).pow(0.0), 1.0E-11);
    }

    @Test(expected=NullArgumentException.class)
    public void testpowNull() {
        Complex.ONE.pow(null);
    }

    @Test
    public void testSin() {
        Complex z = new Complex(3.0, 4.0);
        Complex expected = new Complex(3.853738, -27.01681);
        TestUtils.assertEquals(expected, z.sin(), 1.0E-5);
    }

    @Test
    public void testSinInf() {
        TestUtils.assertSame(this.infInf, this.oneInf.sin());
        TestUtils.assertSame(this.infNegInf, this.oneNegInf.sin());
        TestUtils.assertSame(Complex.NaN, this.infOne.sin());
        TestUtils.assertSame(Complex.NaN, this.negInfOne.sin());
        TestUtils.assertSame(Complex.NaN, this.infInf.sin());
        TestUtils.assertSame(Complex.NaN, this.infNegInf.sin());
        TestUtils.assertSame(Complex.NaN, this.negInfInf.sin());
        TestUtils.assertSame(Complex.NaN, this.negInfNegInf.sin());
    }

    @Test
    public void testSinNaN() {
        Assert.assertTrue((boolean)Complex.NaN.sin().isNaN());
    }

    @Test
    public void testSinh() {
        Complex z = new Complex(3.0, 4.0);
        Complex expected = new Complex(-6.54812, -7.61923);
        TestUtils.assertEquals(expected, z.sinh(), 1.0E-5);
    }

    @Test
    public void testSinhNaN() {
        Assert.assertTrue((boolean)Complex.NaN.sinh().isNaN());
    }

    @Test
    public void testSinhInf() {
        TestUtils.assertSame(Complex.NaN, this.oneInf.sinh());
        TestUtils.assertSame(Complex.NaN, this.oneNegInf.sinh());
        TestUtils.assertSame(this.infInf, this.infOne.sinh());
        TestUtils.assertSame(this.negInfInf, this.negInfOne.sinh());
        TestUtils.assertSame(Complex.NaN, this.infInf.sinh());
        TestUtils.assertSame(Complex.NaN, this.infNegInf.sinh());
        TestUtils.assertSame(Complex.NaN, this.negInfInf.sinh());
        TestUtils.assertSame(Complex.NaN, this.negInfNegInf.sinh());
    }

    @Test
    public void testSqrtRealPositive() {
        Complex z = new Complex(3.0, 4.0);
        Complex expected = new Complex(2.0, 1.0);
        TestUtils.assertEquals(expected, z.sqrt(), 1.0E-5);
    }

    @Test
    public void testSqrtRealZero() {
        Complex z = new Complex(0.0, 4.0);
        Complex expected = new Complex(1.41421, 1.41421);
        TestUtils.assertEquals(expected, z.sqrt(), 1.0E-5);
    }

    @Test
    public void testSqrtRealNegative() {
        Complex z = new Complex(-3.0, 4.0);
        Complex expected = new Complex(1.0, 2.0);
        TestUtils.assertEquals(expected, z.sqrt(), 1.0E-5);
    }

    @Test
    public void testSqrtImaginaryZero() {
        Complex z = new Complex(-3.0, 0.0);
        Complex expected = new Complex(0.0, 1.73205);
        TestUtils.assertEquals(expected, z.sqrt(), 1.0E-5);
    }

    @Test
    public void testSqrtImaginaryNegative() {
        Complex z = new Complex(-3.0, -4.0);
        Complex expected = new Complex(1.0, -2.0);
        TestUtils.assertEquals(expected, z.sqrt(), 1.0E-5);
    }

    @Test
    public void testSqrtPolar() {
        double r = 1.0;
        for (int i = 0; i < 5; ++i) {
            r += (double)i;
            double theta = 0.0;
            for (int j = 0; j < 11; ++j) {
                Complex z = ComplexUtils.polar2Complex((double)r, (double)(theta += this.pi / 12.0));
                Complex sqrtz = ComplexUtils.polar2Complex((double)FastMath.sqrt((double)r), (double)(theta / 2.0));
                TestUtils.assertEquals(sqrtz, z.sqrt(), 1.0E-11);
            }
        }
    }

    @Test
    public void testSqrtNaN() {
        Assert.assertTrue((boolean)Complex.NaN.sqrt().isNaN());
    }

    @Test
    public void testSqrtInf() {
        TestUtils.assertSame(this.infNaN, this.oneInf.sqrt());
        TestUtils.assertSame(this.infNaN, this.oneNegInf.sqrt());
        TestUtils.assertSame(this.infZero, this.infOne.sqrt());
        TestUtils.assertSame(this.zeroInf, this.negInfOne.sqrt());
        TestUtils.assertSame(this.infNaN, this.infInf.sqrt());
        TestUtils.assertSame(this.infNaN, this.infNegInf.sqrt());
        TestUtils.assertSame(this.nanInf, this.negInfInf.sqrt());
        TestUtils.assertSame(this.nanNegInf, this.negInfNegInf.sqrt());
    }

    @Test
    public void testSqrt1z() {
        Complex z = new Complex(3.0, 4.0);
        Complex expected = new Complex(4.08033, -2.94094);
        TestUtils.assertEquals(expected, z.sqrt1z(), 1.0E-5);
    }

    @Test
    public void testSqrt1zNaN() {
        Assert.assertTrue((boolean)Complex.NaN.sqrt1z().isNaN());
    }

    @Test
    public void testTan() {
        Complex z = new Complex(3.0, 4.0);
        Complex expected = new Complex(-1.87346E-4, 0.999356);
        TestUtils.assertEquals(expected, z.tan(), 1.0E-5);
        Complex actual = new Complex(3.0, 1.0E10).tan();
        expected = new Complex(0.0, 1.0);
        TestUtils.assertEquals(expected, actual, 1.0E-5);
        actual = new Complex(3.0, -1.0E10).tan();
        expected = new Complex(0.0, -1.0);
        TestUtils.assertEquals(expected, actual, 1.0E-5);
    }

    @Test
    public void testTanNaN() {
        Assert.assertTrue((boolean)Complex.NaN.tan().isNaN());
    }

    @Test
    public void testTanInf() {
        TestUtils.assertSame(Complex.valueOf((double)0.0, (double)1.0), this.oneInf.tan());
        TestUtils.assertSame(Complex.valueOf((double)0.0, (double)-1.0), this.oneNegInf.tan());
        TestUtils.assertSame(Complex.NaN, this.infOne.tan());
        TestUtils.assertSame(Complex.NaN, this.negInfOne.tan());
        TestUtils.assertSame(Complex.NaN, this.infInf.tan());
        TestUtils.assertSame(Complex.NaN, this.infNegInf.tan());
        TestUtils.assertSame(Complex.NaN, this.negInfInf.tan());
        TestUtils.assertSame(Complex.NaN, this.negInfNegInf.tan());
    }

    @Test
    public void testTanCritical() {
        TestUtils.assertSame(this.infNaN, new Complex(this.pi / 2.0, 0.0).tan());
        TestUtils.assertSame(this.negInfNaN, new Complex(-this.pi / 2.0, 0.0).tan());
    }

    @Test
    public void testTanh() {
        Complex z = new Complex(3.0, 4.0);
        Complex expected = new Complex(1.00071, 0.00490826);
        TestUtils.assertEquals(expected, z.tanh(), 1.0E-5);
        Complex actual = new Complex(1.0E10, 3.0).tanh();
        expected = new Complex(1.0, 0.0);
        TestUtils.assertEquals(expected, actual, 1.0E-5);
        actual = new Complex(-1.0E10, 3.0).tanh();
        expected = new Complex(-1.0, 0.0);
        TestUtils.assertEquals(expected, actual, 1.0E-5);
    }

    @Test
    public void testTanhNaN() {
        Assert.assertTrue((boolean)Complex.NaN.tanh().isNaN());
    }

    @Test
    public void testTanhInf() {
        TestUtils.assertSame(Complex.NaN, this.oneInf.tanh());
        TestUtils.assertSame(Complex.NaN, this.oneNegInf.tanh());
        TestUtils.assertSame(Complex.valueOf((double)1.0, (double)0.0), this.infOne.tanh());
        TestUtils.assertSame(Complex.valueOf((double)-1.0, (double)0.0), this.negInfOne.tanh());
        TestUtils.assertSame(Complex.NaN, this.infInf.tanh());
        TestUtils.assertSame(Complex.NaN, this.infNegInf.tanh());
        TestUtils.assertSame(Complex.NaN, this.negInfInf.tanh());
        TestUtils.assertSame(Complex.NaN, this.negInfNegInf.tanh());
    }

    @Test
    public void testTanhCritical() {
        TestUtils.assertSame(this.nanInf, new Complex(0.0, this.pi / 2.0).tanh());
    }

    @Test
    public void testMath221() {
        Assert.assertTrue((boolean)Complex.equals((Complex)new Complex(0.0, -1.0), (Complex)new Complex(0.0, 1.0).multiply(new Complex(-1.0, 0.0))));
    }

    @Test
    public void testNthRoot_normal_thirdRoot() {
        Complex z = new Complex(-2.0, 2.0);
        Complex[] thirdRootsOfZ = z.nthRoot(3).toArray(new Complex[0]);
        Assert.assertEquals((long)3L, (long)thirdRootsOfZ.length);
        Assert.assertEquals((double)1.0, (double)thirdRootsOfZ[0].getReal(), (double)1.0E-5);
        Assert.assertEquals((double)1.0, (double)thirdRootsOfZ[0].getImaginary(), (double)1.0E-5);
        Assert.assertEquals((double)-1.3660254037844386, (double)thirdRootsOfZ[1].getReal(), (double)1.0E-5);
        Assert.assertEquals((double)0.36602540378443843, (double)thirdRootsOfZ[1].getImaginary(), (double)1.0E-5);
        Assert.assertEquals((double)0.366025403784439, (double)thirdRootsOfZ[2].getReal(), (double)1.0E-5);
        Assert.assertEquals((double)-1.3660254037844384, (double)thirdRootsOfZ[2].getImaginary(), (double)1.0E-5);
    }

    @Test
    public void testNthRoot_normal_fourthRoot() {
        Complex z = new Complex(5.0, -2.0);
        Complex[] fourthRootsOfZ = z.nthRoot(4).toArray(new Complex[0]);
        Assert.assertEquals((long)4L, (long)fourthRootsOfZ.length);
        Assert.assertEquals((double)1.5164629308487783, (double)fourthRootsOfZ[0].getReal(), (double)1.0E-5);
        Assert.assertEquals((double)-0.14469266210702247, (double)fourthRootsOfZ[0].getImaginary(), (double)1.0E-5);
        Assert.assertEquals((double)0.14469266210702256, (double)fourthRootsOfZ[1].getReal(), (double)1.0E-5);
        Assert.assertEquals((double)1.5164629308487783, (double)fourthRootsOfZ[1].getImaginary(), (double)1.0E-5);
        Assert.assertEquals((double)-1.5164629308487783, (double)fourthRootsOfZ[2].getReal(), (double)1.0E-5);
        Assert.assertEquals((double)0.14469266210702267, (double)fourthRootsOfZ[2].getImaginary(), (double)1.0E-5);
        Assert.assertEquals((double)-0.14469266210702275, (double)fourthRootsOfZ[3].getReal(), (double)1.0E-5);
        Assert.assertEquals((double)-1.5164629308487783, (double)fourthRootsOfZ[3].getImaginary(), (double)1.0E-5);
    }

    @Test
    public void testNthRoot_cornercase_thirdRoot_imaginaryPartEmpty() {
        Complex z = new Complex(8.0, 0.0);
        Complex[] thirdRootsOfZ = z.nthRoot(3).toArray(new Complex[0]);
        Assert.assertEquals((long)3L, (long)thirdRootsOfZ.length);
        Assert.assertEquals((double)2.0, (double)thirdRootsOfZ[0].getReal(), (double)1.0E-5);
        Assert.assertEquals((double)0.0, (double)thirdRootsOfZ[0].getImaginary(), (double)1.0E-5);
        Assert.assertEquals((double)-1.0, (double)thirdRootsOfZ[1].getReal(), (double)1.0E-5);
        Assert.assertEquals((double)1.7320508075688774, (double)thirdRootsOfZ[1].getImaginary(), (double)1.0E-5);
        Assert.assertEquals((double)-1.0, (double)thirdRootsOfZ[2].getReal(), (double)1.0E-5);
        Assert.assertEquals((double)-1.732050807568877, (double)thirdRootsOfZ[2].getImaginary(), (double)1.0E-5);
    }

    @Test
    public void testNthRoot_cornercase_thirdRoot_realPartZero() {
        Complex z = new Complex(0.0, 2.0);
        Complex[] thirdRootsOfZ = z.nthRoot(3).toArray(new Complex[0]);
        Assert.assertEquals((long)3L, (long)thirdRootsOfZ.length);
        Assert.assertEquals((double)1.0911236359717216, (double)thirdRootsOfZ[0].getReal(), (double)1.0E-5);
        Assert.assertEquals((double)0.6299605249474365, (double)thirdRootsOfZ[0].getImaginary(), (double)1.0E-5);
        Assert.assertEquals((double)-1.0911236359717216, (double)thirdRootsOfZ[1].getReal(), (double)1.0E-5);
        Assert.assertEquals((double)0.6299605249474365, (double)thirdRootsOfZ[1].getImaginary(), (double)1.0E-5);
        Assert.assertEquals((double)-2.3144374213981936E-16, (double)thirdRootsOfZ[2].getReal(), (double)1.0E-5);
        Assert.assertEquals((double)-1.2599210498948732, (double)thirdRootsOfZ[2].getImaginary(), (double)1.0E-5);
    }

    @Test
    public void testNthRoot_cornercase_NAN_Inf() {
        List roots = this.oneNaN.nthRoot(3);
        Assert.assertEquals((long)1L, (long)roots.size());
        Assert.assertEquals((Object)Complex.NaN, roots.get(0));
        roots = this.nanZero.nthRoot(3);
        Assert.assertEquals((long)1L, (long)roots.size());
        Assert.assertEquals((Object)Complex.NaN, roots.get(0));
        roots = this.nanInf.nthRoot(3);
        Assert.assertEquals((long)1L, (long)roots.size());
        Assert.assertEquals((Object)Complex.NaN, roots.get(0));
        roots = this.oneInf.nthRoot(3);
        Assert.assertEquals((long)1L, (long)roots.size());
        Assert.assertEquals((Object)Complex.INF, roots.get(0));
        roots = this.negInfInf.nthRoot(3);
        Assert.assertEquals((long)1L, (long)roots.size());
        Assert.assertEquals((Object)Complex.INF, roots.get(0));
    }

    @Test
    public void testGetArgument() {
        Complex z = new Complex(1.0, 0.0);
        Assert.assertEquals((double)0.0, (double)z.getArgument(), (double)1.0E-12);
        z = new Complex(1.0, 1.0);
        Assert.assertEquals((double)0.7853981633974483, (double)z.getArgument(), (double)1.0E-12);
        z = new Complex(0.0, 1.0);
        Assert.assertEquals((double)1.5707963267948966, (double)z.getArgument(), (double)1.0E-12);
        z = new Complex(-1.0, 1.0);
        Assert.assertEquals((double)2.356194490192345, (double)z.getArgument(), (double)1.0E-12);
        z = new Complex(-1.0, 0.0);
        Assert.assertEquals((double)Math.PI, (double)z.getArgument(), (double)1.0E-12);
        z = new Complex(-1.0, -1.0);
        Assert.assertEquals((double)-2.356194490192345, (double)z.getArgument(), (double)1.0E-12);
        z = new Complex(0.0, -1.0);
        Assert.assertEquals((double)-1.5707963267948966, (double)z.getArgument(), (double)1.0E-12);
        z = new Complex(1.0, -1.0);
        Assert.assertEquals((double)-0.7853981633974483, (double)z.getArgument(), (double)1.0E-12);
    }

    @Test
    public void testGetArgumentInf() {
        Assert.assertEquals((double)0.7853981633974483, (double)this.infInf.getArgument(), (double)1.0E-12);
        Assert.assertEquals((double)1.5707963267948966, (double)this.oneInf.getArgument(), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)this.infOne.getArgument(), (double)1.0E-12);
        Assert.assertEquals((double)1.5707963267948966, (double)this.zeroInf.getArgument(), (double)1.0E-12);
        Assert.assertEquals((double)0.0, (double)this.infZero.getArgument(), (double)1.0E-12);
        Assert.assertEquals((double)Math.PI, (double)this.negInfOne.getArgument(), (double)1.0E-12);
        Assert.assertEquals((double)-2.356194490192345, (double)this.negInfNegInf.getArgument(), (double)1.0E-12);
        Assert.assertEquals((double)-1.5707963267948966, (double)this.oneNegInf.getArgument(), (double)1.0E-12);
    }

    @Test
    public void testGetArgumentNaN() {
        Assert.assertTrue((boolean)Double.isNaN(this.nanZero.getArgument()));
        Assert.assertTrue((boolean)Double.isNaN(this.zeroNaN.getArgument()));
        Assert.assertTrue((boolean)Double.isNaN(Complex.NaN.getArgument()));
    }

    @Test
    public void testSerial() {
        Complex z = new Complex(3.0, 4.0);
        Assert.assertEquals((Object)z, (Object)TestUtils.serializeAndRecover(z));
        Complex ncmplx = (Complex)TestUtils.serializeAndRecover(this.oneNaN);
        Assert.assertEquals((Object)this.nanZero, (Object)ncmplx);
        Assert.assertTrue((boolean)ncmplx.isNaN());
        Complex infcmplx = (Complex)TestUtils.serializeAndRecover(this.infInf);
        Assert.assertEquals((Object)this.infInf, (Object)infcmplx);
        Assert.assertTrue((boolean)infcmplx.isInfinite());
        TestComplex tz = new TestComplex(3.0, 4.0);
        Assert.assertEquals((Object)((Object)tz), (Object)TestUtils.serializeAndRecover((Object)tz));
        TestComplex ntcmplx = (TestComplex)((Object)TestUtils.serializeAndRecover((Object)new TestComplex(this.oneNaN)));
        Assert.assertEquals((Object)this.nanZero, (Object)((Object)ntcmplx));
        Assert.assertTrue((boolean)ntcmplx.isNaN());
        TestComplex inftcmplx = (TestComplex)((Object)TestUtils.serializeAndRecover((Object)new TestComplex(this.infInf)));
        Assert.assertEquals((Object)this.infInf, (Object)((Object)inftcmplx));
        Assert.assertTrue((boolean)inftcmplx.isInfinite());
    }

    public static class TestComplex
    extends Complex {
        private static final long serialVersionUID = 3268726724160389237L;

        public TestComplex(double real, double imaginary) {
            super(real, imaginary);
        }

        public TestComplex(Complex other) {
            this(other.getReal(), other.getImaginary());
        }

        protected TestComplex createComplex(double real, double imaginary) {
            return new TestComplex(real, imaginary);
        }
    }
}

