/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.BaseSecantSolverAbstractTest;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.RegulaFalsiSolver;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.solvers.UnivariateSolver;
import com.hazelcast.shaded.org.apache.commons.math3.exception.ConvergenceException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public final class RegulaFalsiSolverTest
extends BaseSecantSolverAbstractTest {
    protected UnivariateSolver getSolver() {
        return new RegulaFalsiSolver();
    }

    protected int[] getQuinticEvalCounts() {
        return new int[]{3, 7, 8, 19, 18, 11, 67, 55, 288, 151, -1};
    }

    @Test(expected=ConvergenceException.class)
    public void testIssue631() {
        UnivariateFunction f = new UnivariateFunction(){

            public double value(double x) {
                return FastMath.exp((double)x) - FastMath.pow((double)Math.PI, (double)3.0);
            }
        };
        RegulaFalsiSolver solver = new RegulaFalsiSolver();
        double root = solver.solve(3624, f, 1.0, 10.0);
        Assert.assertEquals((double)3.4341896575482003, (double)root, (double)1.0E-15);
    }
}

