/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation.LinearInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation.UnivariateInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation.UnivariatePeriodicInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NonMonotonicSequenceException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NumberIsTooSmallException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import java.util.Random;
import org.junit.Assert;
import org.junit.Test;

public class UnivariatePeriodicInterpolatorTest {
    private final Random rng = new Random(1224465L);

    @Test
    public void testSine() {
        int i;
        int n = 30;
        double[] xval = new double[30];
        double[] yval = new double[30];
        double period = 12.3;
        double offset = 45.67;
        double delta = 0.0;
        for (int i2 = 0; i2 < 30; ++i2) {
            xval[i2] = 45.67 + (delta += this.rng.nextDouble() * 12.3 / 30.0);
            yval[i2] = FastMath.sin((double)xval[i2]);
        }
        LinearInterpolator inter = new LinearInterpolator();
        UnivariateFunction f = inter.interpolate(xval, yval);
        UnivariatePeriodicInterpolator interP = new UnivariatePeriodicInterpolator((UnivariateInterpolator)new LinearInterpolator(), 12.3, 1);
        UnivariateFunction fP = interP.interpolate(xval, yval);
        double xMin = xval[0];
        double xMax = xval[29];
        for (i = 0; i < 30; ++i) {
            double x = xMin + (xMax - xMin) * this.rng.nextDouble();
            double y = f.value(x);
            double yP = fP.value(x);
            Assert.assertEquals((String)("x=" + x), (double)y, (double)yP, (double)Math.ulp(1.0));
        }
        for (i = 0; i < 30; ++i) {
            double xIn = 45.67 + this.rng.nextDouble() * 12.3;
            double xOut = xIn + (double)this.rng.nextInt(123456789) * 12.3;
            double yIn = fP.value(xIn);
            double yOut = fP.value(xOut);
            Assert.assertEquals((double)yIn, (double)yOut, (double)1.0E-7);
        }
    }

    @Test
    public void testLessThanOnePeriodCoverage() {
        int n = 30;
        double[] xval = new double[30];
        double[] yval = new double[30];
        double period = 12.3;
        double offset = 45.67;
        double delta = 6.15;
        for (int i = 0; i < 30; ++i) {
            xval[i] = 45.67 + (delta += 0.20500000000000002 * this.rng.nextDouble());
            yval[i] = FastMath.sin((double)xval[i]);
        }
        UnivariatePeriodicInterpolator interP = new UnivariatePeriodicInterpolator((UnivariateInterpolator)new LinearInterpolator(), 12.3, 1);
        UnivariateFunction fP = interP.interpolate(xval, yval);
        for (int i = 0; i < 30; ++i) {
            double xIn = 45.67 + this.rng.nextDouble() * 12.3;
            double xOut = xIn + (double)this.rng.nextInt(123456789) * 12.3;
            double yIn = fP.value(xIn);
            double yOut = fP.value(xOut);
            Assert.assertEquals((double)yIn, (double)yOut, (double)1.0E-7);
        }
    }

    @Test
    public void testMoreThanOnePeriodCoverage() {
        int n = 30;
        double[] xval = new double[30];
        double[] yval = new double[30];
        double period = 12.3;
        double offset = 45.67;
        double delta = 6.15;
        for (int i = 0; i < 30; ++i) {
            xval[i] = 45.67 + (delta += 4.1 * this.rng.nextDouble());
            yval[i] = FastMath.sin((double)xval[i]);
        }
        UnivariatePeriodicInterpolator interP = new UnivariatePeriodicInterpolator((UnivariateInterpolator)new LinearInterpolator(), 12.3, 1);
        UnivariateFunction fP = interP.interpolate(xval, yval);
        for (int i = 0; i < 30; ++i) {
            double xIn = 45.67 + this.rng.nextDouble() * 12.3;
            double xOut = xIn + (double)this.rng.nextInt(123456789) * 12.3;
            double yIn = fP.value(xIn);
            double yOut = fP.value(xOut);
            Assert.assertEquals((double)yIn, (double)yOut, (double)1.0E-6);
        }
    }

    @Test(expected=NumberIsTooSmallException.class)
    public void testTooFewSamples() {
        double[] xval = new double[]{2.0, 3.0, 7.0};
        double[] yval = new double[]{1.0, 6.0, 5.0};
        double period = 10.0;
        UnivariatePeriodicInterpolator interpolator = new UnivariatePeriodicInterpolator((UnivariateInterpolator)new LinearInterpolator(), 10.0);
        interpolator.interpolate(xval, yval);
    }

    @Test(expected=NonMonotonicSequenceException.class)
    public void testUnsortedSamples() {
        double[] xval = new double[]{2.0, 3.0, 7.0, 4.0, 6.0};
        double[] yval = new double[]{1.0, 6.0, 5.0, -1.0, -2.0};
        double period = 10.0;
        UnivariatePeriodicInterpolator interpolator = new UnivariatePeriodicInterpolator((UnivariateInterpolator)new LinearInterpolator(), 10.0);
        interpolator.interpolate(xval, yval);
    }
}

