/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.TrivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation.TricubicInterpolatingFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation.TricubicInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public final class TricubicInterpolatorTest {
    @Test
    public void testPreconditions() {
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5};
        double[] yval = new double[]{-4.0, -3.0, -1.0, 2.5};
        double[] zval = new double[]{-12.0, -8.0, -5.5, -3.0, 0.0, 2.5};
        double[][][] fval = new double[xval.length][yval.length][zval.length];
        TricubicInterpolatingFunction tcf = new TricubicInterpolator().interpolate(xval, yval, zval, fval);
        double[] wxval = new double[]{3.0, 2.0, 5.0, 6.5};
        try {
            tcf = new TricubicInterpolator().interpolate(wxval, yval, zval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[] wyval = new double[]{-4.0, -1.0, -1.0, 2.5};
        try {
            tcf = new TricubicInterpolator().interpolate(xval, wyval, zval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[] wzval = new double[]{-12.0, -8.0, -9.0, -3.0, 0.0, 2.5};
        try {
            tcf = new TricubicInterpolator().interpolate(xval, yval, wzval, fval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[][][] wfval = new double[xval.length - 1][yval.length][zval.length];
        try {
            tcf = new TricubicInterpolator().interpolate(xval, yval, zval, wfval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        wfval = new double[xval.length][yval.length - 1][zval.length];
        try {
            tcf = new TricubicInterpolator().interpolate(xval, yval, zval, wfval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        wfval = new double[xval.length][yval.length][zval.length - 1];
        try {
            tcf = new TricubicInterpolator().interpolate(xval, yval, zval, wfval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
    }

    public void testIsValid() {
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5};
        double[] yval = new double[]{-4.0, -3.0, -1.0, 2.5};
        double[] zval = new double[]{-12.0, -8.0, -5.5, -3.0, 0.0, 2.5};
        double[][][] fval = new double[xval.length][yval.length][zval.length];
        TricubicInterpolatingFunction tcf = new TricubicInterpolator().interpolate(xval, yval, zval, fval);
        Assert.assertTrue((boolean)tcf.isValidPoint(4.0, -3.0, -8.0));
        Assert.assertTrue((boolean)tcf.isValidPoint(5.0, -3.0, -8.0));
        Assert.assertTrue((boolean)tcf.isValidPoint(4.0, -1.0, -8.0));
        Assert.assertTrue((boolean)tcf.isValidPoint(5.0, -1.0, -8.0));
        Assert.assertTrue((boolean)tcf.isValidPoint(4.0, -3.0, 0.0));
        Assert.assertTrue((boolean)tcf.isValidPoint(5.0, -3.0, 0.0));
        Assert.assertTrue((boolean)tcf.isValidPoint(4.0, -1.0, 0.0));
        Assert.assertTrue((boolean)tcf.isValidPoint(5.0, -1.0, 0.0));
        Assert.assertFalse((boolean)tcf.isValidPoint(3.5, -3.0, -8.0));
        Assert.assertFalse((boolean)tcf.isValidPoint(4.5, -3.1, -8.0));
        Assert.assertFalse((boolean)tcf.isValidPoint(4.5, -2.0, 0.0));
        Assert.assertFalse((boolean)tcf.isValidPoint(4.5, 0.0, -3.5));
        Assert.assertFalse((boolean)tcf.isValidPoint(-10.0, 4.1, -1.0));
    }

    @Test
    public void testPlane() {
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5};
        double[] yval = new double[]{-4.0, -3.0, -1.0, 2.0, 2.5};
        double[] zval = new double[]{-12.0, -8.0, -5.5, -3.0, 0.0, 2.5};
        TrivariateFunction f = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 2.0 * x - 3.0 * y - 4.0 * z + 5.0;
            }
        };
        double[][][] fval = new double[xval.length][yval.length][zval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                for (int k = 0; k < zval.length; ++k) {
                    fval[i][j][k] = f.value(xval[i], yval[j], zval[k]);
                }
            }
        }
        TricubicInterpolatingFunction tcf = new TricubicInterpolator().interpolate(xval, yval, zval, fval);
        double x = 4.0;
        double y = -3.0;
        double z = 0.0;
        double expected = f.value(x, y, z);
        double result = tcf.value(x, y, z);
        Assert.assertEquals((String)"On sample point", (double)expected, (double)result, (double)1.0E-15);
        x = 4.5;
        y = -1.5;
        z = -4.25;
        expected = f.value(x, y, z);
        result = tcf.value(x, y, z);
        Assert.assertEquals((String)"Half-way between sample points (middle of the patch)", (double)expected, (double)result, (double)1.0E-14);
    }

    @Test
    public void testWave() {
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5};
        double[] yval = new double[]{-4.0, -3.0, -1.0, 2.0, 2.5};
        double[] zval = new double[]{-12.0, -8.0, -5.5, -3.0, 0.0, 4.0};
        double a = 0.2;
        double omega = 0.5;
        double kx = 2.0;
        double ky = 1.0;
        TrivariateFunction f = new TrivariateFunction(){

            public double value(double x, double y, double z) {
                return 0.2 * FastMath.cos((double)(0.5 * z - 2.0 * x - 1.0 * y));
            }
        };
        double[][][] fval = new double[xval.length][yval.length][zval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                for (int k = 0; k < zval.length; ++k) {
                    fval[i][j][k] = f.value(xval[i], yval[j], zval[k]);
                }
            }
        }
        TricubicInterpolatingFunction tcf = new TricubicInterpolator().interpolate(xval, yval, zval, fval);
        double x = 4.0;
        double y = -3.0;
        double z = 0.0;
        double expected = f.value(x, y, z);
        double result = tcf.value(x, y, z);
        Assert.assertEquals((String)"On sample point", (double)expected, (double)result, (double)1.0E-14);
        x = 4.5;
        y = -1.5;
        z = -4.25;
        expected = f.value(x, y, z);
        result = tcf.value(x, y, z);
        Assert.assertEquals((String)"Half-way between sample points (middle of the patch)", (double)expected, (double)result, (double)0.1);
    }
}

