/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.BivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation.PiecewiseBicubicSplineInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.UniformRealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.InsufficientDataException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NonMonotonicSequenceException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.Well19937c;
import org.junit.Assert;
import org.junit.Test;

public final class PiecewiseBicubicSplineInterpolatorTest {
    @Test
    public void testPreconditions() {
        double[] yval12;
        double[] xval12;
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5, 7.5};
        double[] yval = new double[]{-4.0, -3.0, -1.0, 2.5, 3.5};
        double[][] zval = new double[xval.length][yval.length];
        PiecewiseBicubicSplineInterpolator interpolator = new PiecewiseBicubicSplineInterpolator();
        try {
            interpolator.interpolate(null, yval, zval);
            Assert.fail((String)"Failed to detect x null pointer");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            interpolator.interpolate(xval, null, zval);
            Assert.fail((String)"Failed to detect y null pointer");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            interpolator.interpolate(xval, yval, (double[][])null);
            Assert.fail((String)"Failed to detect z null pointer");
        }
        catch (NullArgumentException nullArgumentException) {
            // empty catch block
        }
        try {
            xval12 = new double[]{0.0, 1.0, 2.0, 3.0};
            interpolator.interpolate(xval12, yval, zval);
            Assert.fail((String)"Failed to detect insufficient x data");
        }
        catch (InsufficientDataException xval12) {
            // empty catch block
        }
        try {
            yval12 = new double[]{0.0, 1.0, 2.0, 3.0};
            interpolator.interpolate(xval, yval12, zval);
            Assert.fail((String)"Failed to detect insufficient y data");
        }
        catch (InsufficientDataException yval12) {
            // empty catch block
        }
        try {
            double[][] zval1 = new double[4][4];
            interpolator.interpolate(xval, yval, zval1);
            Assert.fail((String)"Failed to detect insufficient z data");
        }
        catch (InsufficientDataException zval1) {
            // empty catch block
        }
        try {
            xval12 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
            interpolator.interpolate(xval12, yval, zval);
            Assert.fail((String)"Failed to detect data set array with different sizes.");
        }
        catch (DimensionMismatchException xval13) {
            // empty catch block
        }
        try {
            yval12 = new double[]{0.0, 1.0, 2.0, 3.0, 4.0, 5.0, 6.0};
            interpolator.interpolate(xval, yval12, zval);
            Assert.fail((String)"Failed to detect data set array with different sizes.");
        }
        catch (DimensionMismatchException yval13) {
            // empty catch block
        }
        try {
            xval12 = new double[]{0.0, 1.0, 0.5, 7.0, 3.5};
            interpolator.interpolate(xval12, yval, zval);
            Assert.fail((String)"Failed to detect unsorted x arguments.");
        }
        catch (NonMonotonicSequenceException xval14) {
            // empty catch block
        }
        try {
            yval12 = new double[]{0.0, 1.0, 1.5, 0.0, 3.0};
            interpolator.interpolate(xval, yval12, zval);
            Assert.fail((String)"Failed to detect unsorted y arguments.");
        }
        catch (NonMonotonicSequenceException nonMonotonicSequenceException) {
            // empty catch block
        }
    }

    @Test
    public void testInterpolation1() {
        int sz = 21;
        double[] xval = new double[21];
        double[] yval = new double[21];
        double delta = 0.05;
        for (int i = 0; i < 21; ++i) {
            xval[i] = -1.0 + (double)(15 * i) * 0.05;
            yval[i] = -20.0 + (double)(30 * i) * 0.05;
        }
        BivariateFunction f = new BivariateFunction(){

            public double value(double x, double y) {
                return 2.0 * x - 3.0 * y + 5.0;
            }
        };
        double[][] zval = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                zval[i][j] = f.value(xval[i], yval[j]);
            }
        }
        PiecewiseBicubicSplineInterpolator interpolator = new PiecewiseBicubicSplineInterpolator();
        BivariateFunction p = interpolator.interpolate(xval, yval, zval);
        Well19937c rng = new Well19937c(1234567L);
        UniformRealDistribution distX = new UniformRealDistribution((RandomGenerator)rng, xval[0], xval[xval.length - 1]);
        UniformRealDistribution distY = new UniformRealDistribution((RandomGenerator)rng, yval[0], yval[yval.length - 1]);
        int numSamples = 50;
        double tol = 2.0E-14;
        for (int i = 0; i < 50; ++i) {
            double x = distX.sample();
            for (int j = 0; j < 50; ++j) {
                double y = distY.sample();
                Assert.assertEquals((double)f.value(x, y), (double)p.value(x, y), (double)2.0E-14);
            }
        }
    }

    @Test
    public void testInterpolation2() {
        int sz = 21;
        double[] xval = new double[21];
        double[] yval = new double[21];
        double delta = 0.05;
        for (int i = 0; i < 21; ++i) {
            xval[i] = -1.0 + (double)(15 * i) * 0.05;
            yval[i] = -20.0 + (double)(30 * i) * 0.05;
        }
        BivariateFunction f = new BivariateFunction(){

            public double value(double x, double y) {
                return 2.0 * x * x - 3.0 * y * y + 4.0 * x * y - 5.0;
            }
        };
        double[][] zval = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                zval[i][j] = f.value(xval[i], yval[j]);
            }
        }
        PiecewiseBicubicSplineInterpolator interpolator = new PiecewiseBicubicSplineInterpolator();
        BivariateFunction p = interpolator.interpolate(xval, yval, zval);
        Well19937c rng = new Well19937c(1234567L);
        UniformRealDistribution distX = new UniformRealDistribution((RandomGenerator)rng, xval[0], xval[xval.length - 1]);
        UniformRealDistribution distY = new UniformRealDistribution((RandomGenerator)rng, yval[0], yval[yval.length - 1]);
        int numSamples = 50;
        double tol = 5.0E-13;
        for (int i = 0; i < 50; ++i) {
            double x = distX.sample();
            for (int j = 0; j < 50; ++j) {
                double y = distY.sample();
                Assert.assertEquals((double)f.value(x, y), (double)p.value(x, y), (double)5.0E-13);
            }
        }
    }
}

