/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.BivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.interpolation.BicubicSplineInterpolator;
import com.hazelcast.shaded.org.apache.commons.math3.distribution.UniformRealDistribution;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.MathIllegalArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.random.RandomGenerator;
import com.hazelcast.shaded.org.apache.commons.math3.random.Well19937c;
import org.junit.Assert;
import org.junit.Test;

@Deprecated
public final class BicubicSplineInterpolatorTest {
    @Test
    public void testPreconditions() {
        double[] xval = new double[]{3.0, 4.0, 5.0, 6.5};
        double[] yval = new double[]{-4.0, -3.0, -1.0, 2.5};
        double[][] zval = new double[xval.length][yval.length];
        BicubicSplineInterpolator interpolator = new BicubicSplineInterpolator();
        BivariateFunction p = interpolator.interpolate(xval, yval, zval);
        double[] wxval = new double[]{3.0, 2.0, 5.0, 6.5};
        try {
            p = interpolator.interpolate(wxval, yval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[] wyval = new double[]{-4.0, -3.0, -1.0, -1.0};
        try {
            p = interpolator.interpolate(xval, wyval, zval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (MathIllegalArgumentException mathIllegalArgumentException) {
            // empty catch block
        }
        double[][] wzval = new double[xval.length][yval.length + 1];
        try {
            p = interpolator.interpolate(xval, yval, wzval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
        wzval = new double[xval.length - 1][yval.length];
        try {
            p = interpolator.interpolate(xval, yval, wzval);
            Assert.fail((String)"an exception should have been thrown");
        }
        catch (DimensionMismatchException dimensionMismatchException) {
            // empty catch block
        }
    }

    @Test
    public void testInterpolation1() {
        int sz = 21;
        double[] xval = new double[21];
        double[] yval = new double[21];
        double delta = 0.05;
        for (int i = 0; i < 21; ++i) {
            xval[i] = -1.0 + (double)(15 * i) * 0.05;
            yval[i] = -20.0 + (double)(30 * i) * 0.05;
        }
        BivariateFunction f = new BivariateFunction(){

            public double value(double x, double y) {
                return 2.0 * x - 3.0 * y + 5.0;
            }
        };
        double[][] zval = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                zval[i][j] = f.value(xval[i], yval[j]);
            }
        }
        BicubicSplineInterpolator interpolator = new BicubicSplineInterpolator();
        BivariateFunction p = interpolator.interpolate(xval, yval, zval);
        Well19937c rng = new Well19937c(1234567L);
        UniformRealDistribution distX = new UniformRealDistribution((RandomGenerator)rng, xval[0], xval[xval.length - 1]);
        UniformRealDistribution distY = new UniformRealDistribution((RandomGenerator)rng, yval[0], yval[yval.length - 1]);
        int numSamples = 50;
        double tol = 6.0;
        for (int i = 0; i < 50; ++i) {
            double x = distX.sample();
            for (int j = 0; j < 50; ++j) {
                double y = distY.sample();
                Assert.assertEquals((double)f.value(x, y), (double)p.value(x, y), (double)6.0);
            }
        }
    }

    @Test
    public void testInterpolation2() {
        int sz = 21;
        double[] xval = new double[21];
        double[] yval = new double[21];
        double delta = 0.05;
        for (int i = 0; i < 21; ++i) {
            xval[i] = -1.0 + (double)(15 * i) * 0.05;
            yval[i] = -20.0 + (double)(30 * i) * 0.05;
        }
        BivariateFunction f = new BivariateFunction(){

            public double value(double x, double y) {
                return 2.0 * x * x - 3.0 * y * y + 4.0 * x * y - 5.0;
            }
        };
        double[][] zval = new double[xval.length][yval.length];
        for (int i = 0; i < xval.length; ++i) {
            for (int j = 0; j < yval.length; ++j) {
                zval[i][j] = f.value(xval[i], yval[j]);
            }
        }
        BicubicSplineInterpolator interpolator = new BicubicSplineInterpolator();
        BivariateFunction p = interpolator.interpolate(xval, yval, zval);
        Well19937c rng = new Well19937c(1234567L);
        UniformRealDistribution distX = new UniformRealDistribution((RandomGenerator)rng, xval[0], xval[xval.length - 1]);
        UniformRealDistribution distY = new UniformRealDistribution((RandomGenerator)rng, yval[0], yval[yval.length - 1]);
        int numSamples = 50;
        double tol = 251.0;
        for (int i = 0; i < 50; ++i) {
            double x = distX.sample();
            for (int j = 0; j < 50; ++j) {
                double y = distY.sample();
                Assert.assertEquals((double)f.value(x, y), (double)p.value(x, y), (double)251.0);
            }
        }
    }
}

