/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.integration.gauss;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.integration.gauss.GaussIntegratorFactory;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.integration.gauss.GaussianQuadratureAbstractTest;
import java.util.ArrayList;
import java.util.Collection;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@RunWith(value=Parameterized.class)
public class LegendreParametricTest
extends GaussianQuadratureAbstractTest {
    private static final GaussIntegratorFactory factory = new GaussIntegratorFactory();
    public static final int MAX_NUM_POINTS = 30;

    public LegendreParametricTest(int numberOfPoints, int maxDegree, double eps, double numUlps) {
        super(factory.legendre(numberOfPoints), maxDegree, eps, numUlps);
    }

    @Parameterized.Parameters
    public static Collection<Object[]> getParameters() {
        ArrayList<Object[]> parameters = new ArrayList<Object[]>();
        for (int k = 1; k <= 30; ++k) {
            parameters.add(new Object[]{k, 2 * k - 1, Math.ulp(1.0), 91.0});
        }
        return parameters;
    }

    @Override
    public double getExpectedValue(int n) {
        if (n % 2 == 1) {
            return 0.0;
        }
        return 2.0 / (double)(n + 1);
    }
}

