/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.integration.gauss;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.integration.gauss.GaussIntegratorFactory;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.integration.gauss.SymmetricGaussIntegrator;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class HermiteTest {
    private static final GaussIntegratorFactory factory = new GaussIntegratorFactory();

    @Test
    public void testNormalDistribution() {
        final double oneOverSqrtPi = 1.0 / FastMath.sqrt((double)Math.PI);
        boolean numPoints = true;
        UnivariateFunction f = new UnivariateFunction(){

            public double value(double y) {
                return oneOverSqrtPi;
            }
        };
        SymmetricGaussIntegrator integrator = factory.hermite(1);
        double result = integrator.integrate(f);
        double expected = 1.0;
        Assert.assertEquals((double)1.0, (double)result, (double)Math.ulp(1.0));
    }

    @Test
    public void testNormalMean() {
        final double sqrtTwo = FastMath.sqrt((double)2.0);
        final double oneOverSqrtPi = 1.0 / FastMath.sqrt((double)Math.PI);
        double mu = 12345.6789;
        double sigma = 987.654321;
        int numPoints = 5;
        UnivariateFunction f = new UnivariateFunction(){

            public double value(double y) {
                return oneOverSqrtPi * (sqrtTwo * 987.654321 * y + 12345.6789);
            }
        };
        SymmetricGaussIntegrator integrator = factory.hermite(5);
        double result = integrator.integrate(f);
        double expected = 12345.6789;
        Assert.assertEquals((double)12345.6789, (double)result, (double)Math.ulp(12345.6789));
    }

    @Test
    public void testNormalVariance() {
        final double twoOverSqrtPi = 2.0 / FastMath.sqrt((double)Math.PI);
        double sigma = 987.654321;
        double sigma2 = 975461.057789971;
        int numPoints = 5;
        UnivariateFunction f = new UnivariateFunction(){

            public double value(double y) {
                return twoOverSqrtPi * 975461.057789971 * y * y;
            }
        };
        SymmetricGaussIntegrator integrator = factory.hermite(5);
        double result = integrator.integrate(f);
        double expected = 975461.057789971;
        Assert.assertEquals((double)975461.057789971, (double)result, (double)(10.0 * Math.ulp(975461.057789971)));
    }
}

