/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.function;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.UnivariateFunction;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sinc;
import com.hazelcast.shaded.org.apache.commons.math3.dfp.Dfp;
import com.hazelcast.shaded.org.apache.commons.math3.dfp.DfpField;
import com.hazelcast.shaded.org.apache.commons.math3.dfp.DfpMath;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class SincTest {
    @Test
    public void testShortcut() {
        Sinc s = new Sinc();
        UnivariateFunction f = new UnivariateFunction(){

            public double value(double x) {
                Dfp dfpX = new DfpField(25).newDfp(x);
                return DfpMath.sin((Dfp)dfpX).divide(dfpX).toDouble();
            }
        };
        for (double x = 1.0E-30; x < 1.0E10; x *= 2.0) {
            double fX = f.value(x);
            double sX = s.value(x);
            Assert.assertEquals((String)("x=" + x), (double)fX, (double)sX, (double)2.0E-16);
        }
    }

    @Test
    public void testCrossings() {
        Sinc s = new Sinc(true);
        int numCrossings = 1000;
        double tol = 2.0E-16;
        for (int i = 1; i <= 1000; ++i) {
            Assert.assertEquals((String)("i=" + i), (double)0.0, (double)s.value((double)i), (double)2.0E-16);
        }
    }

    @Test
    public void testZero() {
        Sinc s = new Sinc();
        Assert.assertEquals((double)1.0, (double)s.value(0.0), (double)0.0);
    }

    @Test
    public void testEuler() {
        Sinc s = new Sinc();
        double x = 123456.789;
        double prod = 1.0;
        for (double xOverPow2 = 61728.3945; xOverPow2 > 0.0; xOverPow2 /= 2.0) {
            prod *= FastMath.cos((double)xOverPow2);
        }
        Assert.assertEquals((double)prod, (double)s.value(123456.789), (double)1.0E-13);
    }

    @Test
    public void testDerivativeZero() {
        DerivativeStructure s0 = new Sinc(true).value(new DerivativeStructure(1, 1, 0, 0.0));
        Assert.assertEquals((double)0.0, (double)s0.getPartialDerivative(new int[]{1}), (double)0.0);
    }

    @Test
    public void testDerivatives1Dot2Unnormalized() {
        DerivativeStructure s = new Sinc(false).value(new DerivativeStructure(1, 5, 0, 1.2));
        Assert.assertEquals((double)0.7766992383060219, (double)s.getPartialDerivative(new int[]{0}), (double)1.0E-16);
        Assert.assertEquals((double)-0.3452845698577903, (double)s.getPartialDerivative(new int[]{1}), (double)1.0E-16);
        Assert.assertEquals((double)-0.20122495520970476, (double)s.getPartialDerivative(new int[]{2}), (double)1.0E-16);
        Assert.assertEquals((double)0.20109759262703392, (double)s.getPartialDerivative(new int[]{3}), (double)4.0E-16);
        Assert.assertEquals((double)0.1063739295492422, (double)s.getPartialDerivative(new int[]{4}), (double)1.0E-15);
        Assert.assertEquals((double)-0.14125991105794786, (double)s.getPartialDerivative(new int[]{5}), (double)3.0E-15);
    }

    @Test
    public void testDerivatives1Dot2Normalized() {
        DerivativeStructure s = new Sinc(true).value(new DerivativeStructure(1, 5, 0, 1.2));
        Assert.assertEquals((double)-0.15591488063143985, (double)s.getPartialDerivative(new int[]{0}), (double)6.0E-17);
        Assert.assertEquals((double)-0.544251761452923, (double)s.getPartialDerivative(new int[]{1}), (double)2.0E-16);
        Assert.assertEquals((double)2.4459044611635856, (double)s.getPartialDerivative(new int[]{2}), (double)9.0E-16);
        Assert.assertEquals((double)0.539136920623591, (double)s.getPartialDerivative(new int[]{3}), (double)7.0E-16);
        Assert.assertEquals((double)-16.984649869728848, (double)s.getPartialDerivative(new int[]{4}), (double)8.0E-15);
        Assert.assertEquals((double)5.0980327462666315, (double)s.getPartialDerivative(new int[]{5}), (double)9.0E-15);
    }

    @Test
    public void testDerivativeShortcut() {
        Sinc sinc = new Sinc();
        UnivariateFunction f = new UnivariateFunction(){

            public double value(double x) {
                Dfp dfpX = new DfpField(25).newDfp(x);
                return DfpMath.cos((Dfp)dfpX).subtract(DfpMath.sin((Dfp)dfpX).divide(dfpX)).divide(dfpX).toDouble();
            }
        };
        for (double x = 1.0E-30; x < 1.0E10; x *= 2.0) {
            double fX = f.value(x);
            DerivativeStructure sX = sinc.value(new DerivativeStructure(1, 1, 0, x));
            Assert.assertEquals((String)("x=" + x), (double)fX, (double)sX.getPartialDerivative(new int[]{1}), (double)3.0E-13);
        }
    }
}

