/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.function;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Sigmoid;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import org.junit.Assert;
import org.junit.Test;

public class SigmoidTest {
    private final double EPS = Math.ulp(1.0);

    @Test
    public void testSomeValues() {
        Sigmoid f = new Sigmoid();
        Assert.assertEquals((double)0.5, (double)f.value(0.0), (double)this.EPS);
        Assert.assertEquals((double)0.0, (double)f.value(Double.NEGATIVE_INFINITY), (double)this.EPS);
        Assert.assertEquals((double)1.0, (double)f.value(Double.POSITIVE_INFINITY), (double)this.EPS);
    }

    @Test
    public void testDerivative() {
        Sigmoid f = new Sigmoid();
        DerivativeStructure f0 = f.value(new DerivativeStructure(1, 1, 0, 0.0));
        Assert.assertEquals((double)0.25, (double)f0.getPartialDerivative(new int[]{1}), (double)0.0);
    }

    @Test
    public void testDerivativesHighOrder() {
        DerivativeStructure s = new Sigmoid(1.0, 3.0).value(new DerivativeStructure(1, 5, 0, 1.2));
        Assert.assertEquals((double)2.5370495669980353, (double)s.getPartialDerivative(new int[]{0}), (double)5.0E-16);
        Assert.assertEquals((double)0.3557888812936114, (double)s.getPartialDerivative(new int[]{1}), (double)6.0E-17);
        Assert.assertEquals((double)-0.1910762646414494, (double)s.getPartialDerivative(new int[]{2}), (double)6.0E-17);
        Assert.assertEquals((double)-0.02396830286286712, (double)s.getPartialDerivative(new int[]{3}), (double)4.0E-17);
        Assert.assertEquals((double)0.2168205979898105, (double)s.getPartialDerivative(new int[]{4}), (double)3.0E-17);
        Assert.assertEquals((double)-0.1918632023463266, (double)s.getPartialDerivative(new int[]{5}), (double)2.0E-16);
    }

    @Test
    public void testDerivativeLargeArguments() {
        Sigmoid f = new Sigmoid(1.0, 2.0);
        Assert.assertEquals((double)0.0, (double)f.value(new DerivativeStructure(1, 1, 0, Double.NEGATIVE_INFINITY)).getPartialDerivative(new int[]{1}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(new DerivativeStructure(1, 1, 0, -1.7976931348623157E308)).getPartialDerivative(new int[]{1}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(new DerivativeStructure(1, 1, 0, -1.0E50)).getPartialDerivative(new int[]{1}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(new DerivativeStructure(1, 1, 0, -1000.0)).getPartialDerivative(new int[]{1}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(new DerivativeStructure(1, 1, 0, 1000.0)).getPartialDerivative(new int[]{1}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(new DerivativeStructure(1, 1, 0, 1.0E50)).getPartialDerivative(new int[]{1}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(new DerivativeStructure(1, 1, 0, Double.MAX_VALUE)).getPartialDerivative(new int[]{1}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(new DerivativeStructure(1, 1, 0, Double.POSITIVE_INFINITY)).getPartialDerivative(new int[]{1}), (double)0.0);
    }

    @Test(expected=NullArgumentException.class)
    public void testParametricUsage1() {
        Sigmoid.Parametric g = new Sigmoid.Parametric();
        g.value(0.0, null);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testParametricUsage2() {
        Sigmoid.Parametric g = new Sigmoid.Parametric();
        g.value(0.0, new double[]{0.0});
    }

    @Test(expected=NullArgumentException.class)
    public void testParametricUsage3() {
        Sigmoid.Parametric g = new Sigmoid.Parametric();
        g.gradient(0.0, null);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testParametricUsage4() {
        Sigmoid.Parametric g = new Sigmoid.Parametric();
        g.gradient(0.0, new double[]{0.0});
    }

    @Test
    public void testParametricValue() {
        double lo = 2.0;
        double hi = 3.0;
        Sigmoid f = new Sigmoid(2.0, 3.0);
        Sigmoid.Parametric g = new Sigmoid.Parametric();
        Assert.assertEquals((double)f.value(-1.0), (double)g.value(-1.0, new double[]{2.0, 3.0}), (double)0.0);
        Assert.assertEquals((double)f.value(0.0), (double)g.value(0.0, new double[]{2.0, 3.0}), (double)0.0);
        Assert.assertEquals((double)f.value(2.0), (double)g.value(2.0, new double[]{2.0, 3.0}), (double)0.0);
    }
}

