/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.math3.analysis.function;

import com.hazelcast.shaded.org.apache.commons.math3.analysis.differentiation.DerivativeStructure;
import com.hazelcast.shaded.org.apache.commons.math3.analysis.function.Gaussian;
import com.hazelcast.shaded.org.apache.commons.math3.exception.DimensionMismatchException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NotStrictlyPositiveException;
import com.hazelcast.shaded.org.apache.commons.math3.exception.NullArgumentException;
import com.hazelcast.shaded.org.apache.commons.math3.util.FastMath;
import org.junit.Assert;
import org.junit.Test;

public class GaussianTest {
    private final double EPS = Math.ulp(1.0);

    @Test(expected=NotStrictlyPositiveException.class)
    public void testPreconditions() {
        new Gaussian(1.0, 2.0, -1.0);
    }

    @Test
    public void testSomeValues() {
        Gaussian f = new Gaussian();
        Assert.assertEquals((double)(1.0 / FastMath.sqrt((double)(Math.PI * 2))), (double)f.value(0.0), (double)this.EPS);
    }

    @Test
    public void testLargeArguments() {
        Gaussian f = new Gaussian();
        Assert.assertEquals((double)0.0, (double)f.value(Double.NEGATIVE_INFINITY), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(-1.7976931348623157E308), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(-100.0), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(100.0), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(Double.MAX_VALUE), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(Double.POSITIVE_INFINITY), (double)0.0);
    }

    @Test
    public void testDerivatives() {
        Gaussian gaussian = new Gaussian(2.0, 0.9, 3.0);
        DerivativeStructure dsX = new DerivativeStructure(1, 4, 0, 1.1);
        DerivativeStructure dsY = gaussian.value(dsX);
        Assert.assertEquals((double)1.9955604901712127, (double)dsY.getValue(), (double)this.EPS);
        Assert.assertEquals((double)-0.0443457886704714, (double)dsY.getPartialDerivative(new int[]{1}), (double)this.EPS);
        Assert.assertEquals((double)-0.22074348138190206, (double)dsY.getPartialDerivative(new int[]{2}), (double)this.EPS);
        Assert.assertEquals((double)0.014760030401924801, (double)dsY.getPartialDerivative(new int[]{3}), (double)this.EPS);
        Assert.assertEquals((double)0.07325315978503569, (double)dsY.getPartialDerivative(new int[]{4}), (double)this.EPS);
    }

    @Test
    public void testDerivativeLargeArguments() {
        Gaussian f = new Gaussian(0.0, 1.0E-50);
        Assert.assertEquals((double)0.0, (double)f.value(new DerivativeStructure(1, 1, 0, Double.NEGATIVE_INFINITY)).getPartialDerivative(new int[]{1}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(new DerivativeStructure(1, 1, 0, -1.7976931348623157E308)).getPartialDerivative(new int[]{1}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(new DerivativeStructure(1, 1, 0, -1.0E50)).getPartialDerivative(new int[]{1}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(new DerivativeStructure(1, 1, 0, -100.0)).getPartialDerivative(new int[]{1}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(new DerivativeStructure(1, 1, 0, 100.0)).getPartialDerivative(new int[]{1}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(new DerivativeStructure(1, 1, 0, 1.0E50)).getPartialDerivative(new int[]{1}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(new DerivativeStructure(1, 1, 0, Double.MAX_VALUE)).getPartialDerivative(new int[]{1}), (double)0.0);
        Assert.assertEquals((double)0.0, (double)f.value(new DerivativeStructure(1, 1, 0, Double.POSITIVE_INFINITY)).getPartialDerivative(new int[]{1}), (double)0.0);
    }

    @Test
    public void testDerivativesNaN() {
        Gaussian f = new Gaussian(0.0, 1.0E-50);
        DerivativeStructure fx = f.value(new DerivativeStructure(1, 5, 0, Double.NaN));
        int i = 0;
        while (i <= fx.getOrder()) {
            Assert.assertTrue((boolean)Double.isNaN(fx.getPartialDerivative(new int[]{i++})));
        }
    }

    @Test(expected=NullArgumentException.class)
    public void testParametricUsage1() {
        Gaussian.Parametric g = new Gaussian.Parametric();
        g.value(0.0, null);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testParametricUsage2() {
        Gaussian.Parametric g = new Gaussian.Parametric();
        g.value(0.0, new double[]{0.0});
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testParametricUsage3() {
        Gaussian.Parametric g = new Gaussian.Parametric();
        g.value(0.0, new double[]{0.0, 1.0, 0.0});
    }

    @Test(expected=NullArgumentException.class)
    public void testParametricUsage4() {
        Gaussian.Parametric g = new Gaussian.Parametric();
        g.gradient(0.0, null);
    }

    @Test(expected=DimensionMismatchException.class)
    public void testParametricUsage5() {
        Gaussian.Parametric g = new Gaussian.Parametric();
        g.gradient(0.0, new double[]{0.0});
    }

    @Test(expected=NotStrictlyPositiveException.class)
    public void testParametricUsage6() {
        Gaussian.Parametric g = new Gaussian.Parametric();
        g.gradient(0.0, new double[]{0.0, 1.0, 0.0});
    }

    @Test
    public void testParametricValue() {
        double norm = 2.0;
        double mean = 3.0;
        double sigma = 4.0;
        Gaussian f = new Gaussian(2.0, 3.0, 4.0);
        Gaussian.Parametric g = new Gaussian.Parametric();
        Assert.assertEquals((double)f.value(-1.0), (double)g.value(-1.0, new double[]{2.0, 3.0, 4.0}), (double)0.0);
        Assert.assertEquals((double)f.value(0.0), (double)g.value(0.0, new double[]{2.0, 3.0, 4.0}), (double)0.0);
        Assert.assertEquals((double)f.value(2.0), (double)g.value(2.0, new double[]{2.0, 3.0, 4.0}), (double)0.0);
    }

    @Test
    public void testParametricGradient() {
        double norm = 2.0;
        double mean = 3.0;
        double sigma = 4.0;
        Gaussian.Parametric f = new Gaussian.Parametric();
        double x = 1.0;
        double[] grad = f.gradient(1.0, new double[]{2.0, 3.0, 4.0});
        double diff = -2.0;
        double n = FastMath.exp((double)-0.125);
        Assert.assertEquals((double)n, (double)grad[0], (double)this.EPS);
        double m = 2.0 * n * -2.0 / 16.0;
        Assert.assertEquals((double)m, (double)grad[1], (double)this.EPS);
        double s = m * -2.0 / 4.0;
        Assert.assertEquals((double)s, (double)grad[2], (double)this.EPS);
    }
}

