/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.shaded.org.apache.commons.codec.digest;

import com.hazelcast.shaded.org.apache.commons.codec.digest.PureJavaCrc32C;
import java.util.Arrays;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class PureJavaCrc32CTest {
    private final PureJavaCrc32C crc = new PureJavaCrc32C();
    private final byte[] data = new byte[32];

    PureJavaCrc32CTest() {
    }

    private void check(int expected) {
        this.crc.reset();
        this.crc.update(this.data, 0, this.data.length);
        int actual = (int)this.crc.getValue();
        Assertions.assertEquals((Object)Integer.toHexString(expected), (Object)Integer.toHexString(actual));
    }

    @Test
    void testDecreasing() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (byte)(31 - i);
        }
        this.check(289397596);
    }

    @Test
    void testIncreasing() {
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = (byte)i;
        }
        this.check(1188919630);
    }

    @Test
    void testOnes() {
        Arrays.fill(this.data, (byte)-1);
        this.check(1655221059);
    }

    @Test
    void testZeros() {
        Arrays.fill(this.data, (byte)0);
        this.check(-1970194774);
    }
}

