/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql_nightly;

import com.hazelcast.config.Config;
import com.hazelcast.config.IndexConfig;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.jet.core.JetSplitBrainTestSupport;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.map.IMap;
import com.hazelcast.sql.SqlRow;
import com.hazelcast.test.HazelcastSerialClassRunner;
import com.hazelcast.test.annotation.NightlyTest;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
@Category(value={NightlyTest.class})
public class SqlSplitBrainTest
extends JetSplitBrainTestSupport {
    protected void onConfigCreated(Config config) {
        config.getJetConfig().setBackupCount(6);
        config.getJetConfig().setScaleUpDelayMillis(3000L);
    }

    @Test
    public void test_indexScan() throws InterruptedException {
        Thread[] threads = new Thread[16];
        AtomicBoolean done = new AtomicBoolean();
        AtomicInteger numQueries = new AtomicInteger();
        Consumer<HazelcastInstance[]> beforeSplit = instances -> {
            int i;
            IMap m = instances[0].getMap("m");
            for (i = 0; i < 10000; ++i) {
                m.put((Object)i, (Object)i);
            }
            m.addIndex(new IndexConfig().addAttribute("this"));
            SqlTestSupport.createMapping(instances[0], "m", Integer.class, Integer.class);
            int threadsLength = threads.length;
            for (i = 0; i < threadsLength; ++i) {
                HazelcastInstance inst = this.createHazelcastClient();
                threads[i] = new Thread(() -> {
                    int numQueriesLocal = 0;
                    while (!done.get()) {
                        try {
                            for (SqlRow sqlRow : inst.getSql().execute("select * from m where this>100 and this<1000", new Object[0])) {
                            }
                        }
                        catch (Throwable e) {
                            this.logger.info(e);
                        }
                        ++numQueriesLocal;
                    }
                    numQueries.addAndGet(numQueriesLocal);
                });
                threads[i].start();
                SqlSplitBrainTest.sleepSeconds((int)1);
            }
        };
        this.testSplitBrain(1, 1, beforeSplit, null, null, 3);
        done.set(true);
        boolean stuck = this.isStuck(threads, 1000);
        if (stuck) {
            this.logger.warning("Waiting a bit longer for possibly long-executing queries");
            stuck = this.isStuck(threads, 15000);
            if (!stuck) {
                Assert.fail((String)"All queries finished, but some queries took longer than expected");
            }
        }
        this.logger.info("num queries executed: " + numQueries.get());
        if (stuck) {
            Assert.fail((String)"some threads were stuck");
        }
    }

    private boolean isStuck(Thread[] threads, int timeoutMillis) throws InterruptedException {
        boolean stuck = false;
        for (Thread t : threads) {
            StackTraceElement[] stackTraceElements;
            t.join(timeoutMillis);
            if (!t.isAlive()) continue;
            StringBuilder dump = new StringBuilder("thread " + t.getName() + " stuck");
            for (StackTraceElement stackTraceElement : stackTraceElements = t.getStackTrace()) {
                dump.append("\n\t\tat ");
                dump.append(stackTraceElement);
            }
            this.logger.info(dump.toString());
            stuck = true;
        }
        return stuck;
    }
}

