/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate.types;

import com.hazelcast.jet.sql.impl.validate.types.HazelcastIntegerType;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeFactory;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeSystem;
import com.hazelcast.jet.sql.impl.validate.types.HazelcastTypeUtils;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataType;
import com.hazelcast.shaded.org.apache.calcite.rel.type.RelDataTypeFactory;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlIdentifier;
import com.hazelcast.shaded.org.apache.calcite.sql.parser.SqlParserPos;
import com.hazelcast.shaded.org.apache.calcite.sql.type.SqlTypeName;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class HazelcastTypeSystemTest {
    private static final HazelcastTypeFactory TYPE_FACTORY = HazelcastTypeFactory.INSTANCE;

    @Test
    public void numericPrecisionAndScaleTest() {
        Assert.assertEquals((long)76L, (long)76L);
        Assert.assertEquals((long)38L, (long)38L);
        Assert.assertEquals((long)76L, (long)HazelcastTypeSystem.INSTANCE.getMaxNumericPrecision());
        Assert.assertEquals((long)38L, (long)HazelcastTypeSystem.INSTANCE.getMaxNumericScale());
        Assert.assertEquals((long)76L, (long)HazelcastTypeSystem.INSTANCE.getMaxPrecision(SqlTypeName.DECIMAL));
        Assert.assertEquals((long)38L, (long)HazelcastTypeSystem.INSTANCE.getMaxScale(SqlTypeName.DECIMAL));
    }

    @Test
    public void isObjectTest() {
        Assert.assertTrue((boolean)HazelcastTypeUtils.isObjectIdentifier((SqlIdentifier)new SqlIdentifier("object", SqlParserPos.ZERO)));
        Assert.assertTrue((boolean)HazelcastTypeUtils.isObjectIdentifier((SqlIdentifier)new SqlIdentifier("OBJECT", SqlParserPos.ZERO)));
        Assert.assertFalse((boolean)HazelcastTypeUtils.isObjectIdentifier((SqlIdentifier)new SqlIdentifier("foo", SqlParserPos.ZERO)));
    }

    @Test
    public void withHigherPrecedenceTest() {
        HazelcastTypeSystemTest.assertPrecedence(HazelcastTypeSystemTest.type(SqlTypeName.VARCHAR), HazelcastTypeSystemTest.type(SqlTypeName.NULL));
        HazelcastTypeSystemTest.assertPrecedence(HazelcastTypeSystemTest.type(SqlTypeName.BOOLEAN), HazelcastTypeSystemTest.type(SqlTypeName.VARCHAR));
        HazelcastTypeSystemTest.assertPrecedence(HazelcastTypeSystemTest.type(SqlTypeName.TINYINT), HazelcastTypeSystemTest.type(SqlTypeName.BOOLEAN));
        HazelcastTypeSystemTest.assertPrecedence((RelDataType)HazelcastIntegerType.create((int)7, (boolean)false), (RelDataType)HazelcastIntegerType.create((int)6, (boolean)false));
        HazelcastTypeSystemTest.assertPrecedence(HazelcastTypeSystemTest.type(SqlTypeName.SMALLINT), HazelcastTypeSystemTest.type(SqlTypeName.TINYINT));
        HazelcastTypeSystemTest.assertPrecedence((RelDataType)HazelcastIntegerType.create((int)15, (boolean)false), (RelDataType)HazelcastIntegerType.create((int)14, (boolean)false));
        HazelcastTypeSystemTest.assertPrecedence(HazelcastTypeSystemTest.type(SqlTypeName.INTEGER), HazelcastTypeSystemTest.type(SqlTypeName.SMALLINT));
        HazelcastTypeSystemTest.assertPrecedence((RelDataType)HazelcastIntegerType.create((int)31, (boolean)false), (RelDataType)HazelcastIntegerType.create((int)30, (boolean)false));
        HazelcastTypeSystemTest.assertPrecedence(HazelcastTypeSystemTest.type(SqlTypeName.BIGINT), HazelcastTypeSystemTest.type(SqlTypeName.INTEGER));
        HazelcastTypeSystemTest.assertPrecedence((RelDataType)HazelcastIntegerType.create((int)63, (boolean)false), (RelDataType)HazelcastIntegerType.create((int)62, (boolean)false));
        HazelcastTypeSystemTest.assertPrecedence(HazelcastTypeSystemTest.type(SqlTypeName.DECIMAL), HazelcastTypeSystemTest.type(SqlTypeName.BIGINT));
        HazelcastTypeSystemTest.assertPrecedence(HazelcastTypeSystemTest.type(SqlTypeName.REAL), HazelcastTypeSystemTest.type(SqlTypeName.DECIMAL));
        HazelcastTypeSystemTest.assertPrecedence(HazelcastTypeSystemTest.type(SqlTypeName.DOUBLE), HazelcastTypeSystemTest.type(SqlTypeName.REAL));
        HazelcastTypeSystemTest.assertPrecedence(HazelcastTypeSystemTest.type(SqlTypeName.TIME), HazelcastTypeSystemTest.type(SqlTypeName.DOUBLE));
        HazelcastTypeSystemTest.assertPrecedence(HazelcastTypeSystemTest.type(SqlTypeName.DATE), HazelcastTypeSystemTest.type(SqlTypeName.TIME));
        HazelcastTypeSystemTest.assertPrecedence(HazelcastTypeSystemTest.type(SqlTypeName.TIMESTAMP), HazelcastTypeSystemTest.type(SqlTypeName.DATE));
        HazelcastTypeSystemTest.assertPrecedence(HazelcastTypeSystemTest.type(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE), HazelcastTypeSystemTest.type(SqlTypeName.TIMESTAMP));
        HazelcastTypeSystemTest.assertPrecedence(HazelcastTypeSystemTest.type(SqlTypeName.ANY), HazelcastTypeSystemTest.type(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE));
    }

    @Test
    public void deriveSumTypeTest() {
        HazelcastIntegerType bigint_64 = HazelcastIntegerType.create((int)64, (boolean)false);
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.VARCHAR), (Object)HazelcastTypeSystem.INSTANCE.deriveSumType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.VARCHAR)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.BOOLEAN), (Object)HazelcastTypeSystem.INSTANCE.deriveSumType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.BOOLEAN)));
        Assert.assertEquals((Object)bigint_64, (Object)HazelcastTypeSystem.INSTANCE.deriveSumType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.TINYINT)));
        Assert.assertEquals((Object)bigint_64, (Object)HazelcastTypeSystem.INSTANCE.deriveSumType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.SMALLINT)));
        Assert.assertEquals((Object)bigint_64, (Object)HazelcastTypeSystem.INSTANCE.deriveSumType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.INTEGER)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.DECIMAL), (Object)HazelcastTypeSystem.INSTANCE.deriveSumType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.BIGINT)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.DECIMAL), (Object)HazelcastTypeSystem.INSTANCE.deriveSumType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.DECIMAL)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.DOUBLE), (Object)HazelcastTypeSystem.INSTANCE.deriveSumType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.REAL)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.DOUBLE), (Object)HazelcastTypeSystem.INSTANCE.deriveSumType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.DOUBLE)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.TIME), (Object)HazelcastTypeSystem.INSTANCE.deriveSumType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.TIME)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.DATE), (Object)HazelcastTypeSystem.INSTANCE.deriveSumType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.DATE)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.TIMESTAMP), (Object)HazelcastTypeSystem.INSTANCE.deriveSumType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.TIMESTAMP)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE), (Object)HazelcastTypeSystem.INSTANCE.deriveSumType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.OTHER), (Object)HazelcastTypeSystem.INSTANCE.deriveSumType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.OTHER)));
    }

    @Test
    public void deriveAvgAggTypeTest() {
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.VARCHAR), (Object)HazelcastTypeSystem.INSTANCE.deriveAvgAggType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.VARCHAR)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.BOOLEAN), (Object)HazelcastTypeSystem.INSTANCE.deriveAvgAggType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.BOOLEAN)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.DECIMAL), (Object)HazelcastTypeSystem.INSTANCE.deriveAvgAggType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.TINYINT)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.DECIMAL), (Object)HazelcastTypeSystem.INSTANCE.deriveAvgAggType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.SMALLINT)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.DECIMAL), (Object)HazelcastTypeSystem.INSTANCE.deriveAvgAggType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.INTEGER)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.DECIMAL), (Object)HazelcastTypeSystem.INSTANCE.deriveAvgAggType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.BIGINT)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.DECIMAL), (Object)HazelcastTypeSystem.INSTANCE.deriveAvgAggType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.DECIMAL)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.DOUBLE), (Object)HazelcastTypeSystem.INSTANCE.deriveAvgAggType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.REAL)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.DOUBLE), (Object)HazelcastTypeSystem.INSTANCE.deriveAvgAggType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.DOUBLE)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.TIME), (Object)HazelcastTypeSystem.INSTANCE.deriveAvgAggType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.TIME)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.DATE), (Object)HazelcastTypeSystem.INSTANCE.deriveAvgAggType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.DATE)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.TIMESTAMP), (Object)HazelcastTypeSystem.INSTANCE.deriveAvgAggType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.TIMESTAMP)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE), (Object)HazelcastTypeSystem.INSTANCE.deriveAvgAggType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE)));
        Assert.assertEquals((Object)HazelcastTypeSystemTest.type(SqlTypeName.OTHER), (Object)HazelcastTypeSystem.INSTANCE.deriveAvgAggType((RelDataTypeFactory)TYPE_FACTORY, HazelcastTypeSystemTest.type(SqlTypeName.OTHER)));
    }

    private static void assertPrecedence(RelDataType expected, RelDataType other) {
        RelDataType actual = HazelcastTypeUtils.withHigherPrecedence((RelDataType)expected, (RelDataType)other);
        Assert.assertSame((Object)expected, (Object)actual);
        actual = HazelcastTypeUtils.withHigherPrecedence((RelDataType)other, (RelDataType)expected);
        Assert.assertSame((Object)expected, (Object)actual);
    }

    private static RelDataType type(SqlTypeName typeName) {
        return TYPE_FACTORY.createSqlType(typeName);
    }
}

