/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.validate;

import com.hazelcast.internal.util.BiTuple;
import com.hazelcast.jet.sql.impl.schema.HazelcastTableFunction;
import com.hazelcast.jet.sql.impl.validate.HazelcastSqlOperatorTable;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastFunction;
import com.hazelcast.jet.sql.impl.validate.operators.common.HazelcastOperandTypeCheckerAware;
import com.hazelcast.jet.sql.impl.validate.operators.misc.HazelcastCaseOperator;
import com.hazelcast.jet.sql.impl.validate.operators.typeinference.HazelcastReturnTypeInference;
import com.hazelcast.shaded.org.apache.calcite.sql.SqlOperator;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.HashMap;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class HazelcastSqlOperatorTableTest {
    @Test
    public void testNoOverride() {
        HashMap<BiTuple, SqlOperator> map = new HashMap<BiTuple, SqlOperator>();
        for (SqlOperator operator : HazelcastSqlOperatorTable.instance().getOperatorList()) {
            BiTuple key = BiTuple.of((Object)operator.getName(), (Object)operator.getSyntax());
            SqlOperator oldOperator = map.put(key, operator);
            Assert.assertNull((String)("Duplicate operator \"" + operator.getName()), (Object)oldOperator);
        }
    }

    @Test
    public void testOperandTypeChecker() {
        for (SqlOperator operator : HazelcastSqlOperatorTable.instance().getOperatorList()) {
            boolean valid = operator instanceof HazelcastOperandTypeCheckerAware || operator instanceof HazelcastTableFunction || operator instanceof HazelcastCaseOperator || operator == HazelcastSqlOperatorTable.ARGUMENT_ASSIGNMENT || operator == HazelcastSqlOperatorTable.DOT;
            Assert.assertTrue((String)("Operator must implement one of classes from " + HazelcastFunction.class.getPackage().toString() + ": " + operator.getClass().getSimpleName()), (boolean)valid);
        }
    }

    @Test
    public void testReturnTypeInference() {
        for (SqlOperator operator : HazelcastSqlOperatorTable.instance().getOperatorList()) {
            if (operator instanceof HazelcastTableFunction || operator == HazelcastSqlOperatorTable.IN || operator == HazelcastSqlOperatorTable.NOT_IN || operator == HazelcastSqlOperatorTable.UNION || operator == HazelcastSqlOperatorTable.UNION_ALL || operator == HazelcastSqlOperatorTable.ARGUMENT_ASSIGNMENT || operator == HazelcastSqlOperatorTable.DOT) continue;
            boolean valid = operator.getReturnTypeInference() instanceof HazelcastReturnTypeInference;
            Assert.assertTrue((String)("Operator must have " + HazelcastReturnTypeInference.class.getSimpleName() + ": " + operator.getClass().getSimpleName()), (boolean)valid);
        }
    }
}

