/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.type.converter;

import com.hazelcast.jet.sql.impl.type.converter.ToConverters;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Date;
import java.util.GregorianCalendar;
import org.assertj.core.api.Assertions;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class ToConvertersTest {
    @Test
    public void test_charConversion() {
        Object converted = ToConverters.getToConverter((QueryDataType)QueryDataType.VARCHAR_CHARACTER).convert((Object)"a");
        Assertions.assertThat((Object)converted).isEqualTo((Object)Character.valueOf('a'));
    }

    @Test
    public void test_bigIntegerConversion() {
        Object converted = ToConverters.getToConverter((QueryDataType)QueryDataType.DECIMAL_BIG_INTEGER).convert((Object)new BigDecimal("1"));
        Assertions.assertThat((Object)converted).isEqualTo((Object)new BigInteger("1"));
    }

    @Test
    public void test_dateConversion() {
        OffsetDateTime time = OffsetDateTime.of(2020, 9, 8, 11, 4, 0, 123, ZoneOffset.UTC);
        Object converted = ToConverters.getToConverter((QueryDataType)QueryDataType.TIMESTAMP_WITH_TZ_DATE).convert((Object)time);
        Assertions.assertThat((Object)converted).isEqualTo((Object)Date.from(time.toInstant()));
    }

    @Test
    public void test_calendarConversion() {
        OffsetDateTime time = OffsetDateTime.of(2020, 9, 8, 11, 4, 0, 0, ZoneOffset.UTC);
        Object converted = ToConverters.getToConverter((QueryDataType)QueryDataType.TIMESTAMP_WITH_TZ_CALENDAR).convert((Object)time);
        Assertions.assertThat((Object)converted).isEqualTo((Object)GregorianCalendar.from(time.toZonedDateTime()));
    }

    @Test
    public void test_instantConversion() {
        OffsetDateTime time = OffsetDateTime.of(2020, 9, 8, 11, 4, 0, 0, ZoneOffset.UTC);
        Object converted = ToConverters.getToConverter((QueryDataType)QueryDataType.TIMESTAMP_WITH_TZ_INSTANT).convert((Object)time);
        Assertions.assertThat((Object)converted).isEqualTo((Object)Instant.ofEpochMilli(1599563040000L));
    }

    @Test
    public void test_zonedDateTimeConversion() {
        OffsetDateTime time = OffsetDateTime.of(2020, 9, 8, 11, 4, 0, 0, ZoneOffset.UTC);
        Object converted = ToConverters.getToConverter((QueryDataType)QueryDataType.TIMESTAMP_WITH_TZ_ZONED_DATE_TIME).convert((Object)time);
        Assertions.assertThat((Object)converted).isEqualTo((Object)time.toZonedDateTime());
    }
}

