/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.type;

import com.hazelcast.config.Config;
import com.hazelcast.config.SerializationConfig;
import com.hazelcast.jet.sql.SqlJsonTestSupport;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.type.BasicNestedFieldsTest;
import com.hazelcast.jet.sql.impl.type.CompactNestedFieldsTest;
import com.hazelcast.jet.sql.impl.type.PortableNestedFieldsTest;
import com.hazelcast.map.IMap;
import com.hazelcast.nio.serialization.ClassDefinition;
import com.hazelcast.nio.serialization.ClassDefinitionBuilder;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.test.HazelcastSerialClassRunner;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
public class UdtObjectToJsonFunctionTest
extends SqlJsonTestSupport {
    @BeforeClass
    public static void beforeClass() {
        Config config = UdtObjectToJsonFunctionTest.smallInstanceConfig().setProperty(ClusterProperty.SQL_CUSTOM_CYCLIC_TYPES_ENABLED.getName(), "true");
        SerializationConfig serializationConfig = config.getSerializationConfig();
        ClassDefinition officeType = new ClassDefinitionBuilder(1, 3).addLongField("id").addStringField("name").build();
        ClassDefinition organizationType = new ClassDefinitionBuilder(1, 2).addLongField("id").addStringField("name").addPortableField("office", officeType).build();
        ClassDefinition userType = new ClassDefinitionBuilder(1, 1).addLongField("id").addStringField("name").addPortableField("organization", organizationType).build();
        serializationConfig.addClassDefinition(officeType);
        serializationConfig.addClassDefinition(organizationType);
        serializationConfig.addClassDefinition(userType);
        UdtObjectToJsonFunctionTest.initializeWithClient((int)3, (Config)config, null);
    }

    private static void createType(String name, String ... fields) {
        ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType(name).fields(fields)).create(UdtObjectToJsonFunctionTest.client());
    }

    private static void execute(String sql, Object ... args) {
        UdtObjectToJsonFunctionTest.client().getSql().execute(sql, args);
    }

    private void initDefault() {
        UdtObjectToJsonFunctionTest.createType("UserType", "id BIGINT", "name VARCHAR", "organization OrganizationType");
        UdtObjectToJsonFunctionTest.createType("OrganizationType", "id BIGINT", "name VARCHAR", "office OfficeType");
        UdtObjectToJsonFunctionTest.createType("OfficeType", "id BIGINT", "name VARCHAR");
        IMap testMap = UdtObjectToJsonFunctionTest.client().getMap("test");
        BasicNestedFieldsTest.createJavaMapping(UdtObjectToJsonFunctionTest.client(), "test", BasicNestedFieldsTest.User.class, "this UserType");
        BasicNestedFieldsTest.Office office = new BasicNestedFieldsTest.Office(3L, "office1");
        BasicNestedFieldsTest.Organization organization = new BasicNestedFieldsTest.Organization(2L, "organization1", office);
        BasicNestedFieldsTest.User user = new BasicNestedFieldsTest.User(1L, "user1", organization);
        testMap.put((Object)1L, (Object)user);
    }

    @Test
    public void test_nonCyclic() {
        this.initDefault();
        this.assertJsonRowsAnyOrder("SELECT CAST(this AS JSON) FROM test", UdtObjectToJsonFunctionTest.rows(1, UdtObjectToJsonFunctionTest.json("{\"organization\":{\"name\":\"organization1\",\"id\":2,\"office\":{\"name\":\"office1\",\"id\":3}},\"id\":1,\"name\":\"user1\"}")));
    }

    @Test
    public void test_failOnCycles() {
        UdtObjectToJsonFunctionTest.createType("AType", "name VARCHAR", "b BType");
        UdtObjectToJsonFunctionTest.createType("BType", "name VARCHAR", "c CType");
        UdtObjectToJsonFunctionTest.createType("CType", "name VARCHAR", "a AType");
        BasicNestedFieldsTest.A a = new BasicNestedFieldsTest.A("a");
        BasicNestedFieldsTest.B b = new BasicNestedFieldsTest.B("b");
        BasicNestedFieldsTest.C c = new BasicNestedFieldsTest.C("c");
        a.b = b;
        b.c = c;
        c.a = a;
        BasicNestedFieldsTest.createJavaMapping(UdtObjectToJsonFunctionTest.client(), "test", BasicNestedFieldsTest.A.class, "this AType");
        IMap map = UdtObjectToJsonFunctionTest.client().getMap("test");
        map.put((Object)1L, (Object)a);
        Assertions.assertThatThrownBy(() -> UdtObjectToJsonFunctionTest.assertRowsAnyOrder(UdtObjectToJsonFunctionTest.client(), "SELECT CAST(this AS JSON) FROM test", UdtObjectToJsonFunctionTest.rows(1, "a"))).hasMessageEndingWith("Cycle detected in row value").hasFieldOrPropertyWithValue("code", (Object)2000);
    }

    @Test
    public void test_returnNullOnNull() {
        this.initDefault();
        BasicNestedFieldsTest.User user = new BasicNestedFieldsTest.User(2L, "user2", null);
        UdtObjectToJsonFunctionTest.client().getMap("test").put((Object)2L, (Object)user);
        UdtObjectToJsonFunctionTest.assertRowsAnyOrder("SELECT CAST((this).organization AS JSON) FROM test WHERE __key = 2", UdtObjectToJsonFunctionTest.rows(1, new Object[]{null}));
    }

    @Test
    public void test_castRowAsJsonShouldFail() {
        Assertions.assertThatThrownBy(() -> UdtObjectToJsonFunctionTest.assertRowsAnyOrder(UdtObjectToJsonFunctionTest.client(), "SELECT CAST(v AS JSON) FROM (SELECT (42, 'foo') v)", UdtObjectToJsonFunctionTest.rows(1, ""))).hasMessageEndingWith("CAST function cannot convert value of type ROW to type JSON").hasFieldOrPropertyWithValue("code", (Object)1008);
    }

    @Test
    public void test_disabledQueries() {
        Assertions.assertThatThrownBy(() -> UdtObjectToJsonFunctionTest.execute("SELECT CAST(? as JSON)", new BasicNestedFieldsTest.User())).hasMessageContaining("Cannot convert OBJECT to JSON");
        Assertions.assertThatThrownBy(() -> UdtObjectToJsonFunctionTest.execute("SELECT CAST((2, 'user', null) as JSON)", new Object[0])).hasMessageContaining("Cannot convert ROW to JSON");
        Assertions.assertThatThrownBy(() -> UdtObjectToJsonFunctionTest.execute("SELECT CAST(CAST((2, 'user', null) AS UserType) as JSON)", new Object[0])).hasMessageContaining("Complex type specifications are not supported");
    }

    @Test
    public void test_compact() {
        CompactNestedFieldsTest.setupCompactTypesForNestedQuery(UdtObjectToJsonFunctionTest.client());
        UdtObjectToJsonFunctionTest.execute("INSERT INTO test VALUES (1, 1, 'user1', (10, 'organization1', (100, 'office1')))", new Object[0]);
        this.assertJsonRowsAnyOrder("SELECT CAST(organization AS JSON) FROM test", UdtObjectToJsonFunctionTest.rows(1, UdtObjectToJsonFunctionTest.json("{\"name\":\"organization1\",\"id\":10,\"office\":{\"name\":\"office1\",\"id\":100}}")));
    }

    @Test
    public void test_portable() {
        PortableNestedFieldsTest.setupPortableTypesForNestedQuery(UdtObjectToJsonFunctionTest.client());
        UdtObjectToJsonFunctionTest.execute("INSERT INTO test VALUES (1, 1, 'user1', (10, 'organization1', (100, 'office1')))", new Object[0]);
        this.assertJsonRowsAnyOrder("SELECT CAST(organization AS JSON) FROM test", UdtObjectToJsonFunctionTest.rows(1, UdtObjectToJsonFunctionTest.json("{\"name\":\"organization1\",\"id\":10,\"office\":{\"name\":\"office1\",\"id\":100}}")));
    }
}

