/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.type;

import com.hazelcast.config.Config;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.type.BasicNestedFieldsTest;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.properties.ClusterProperty;
import com.hazelcast.test.HazelcastSerialClassRunner;
import java.io.Serializable;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.Assertions;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=HazelcastSerialClassRunner.class)
public class RecurrentStructuresNestedFieldsTest
extends SqlTestSupport {
    @BeforeClass
    public static void beforeClass() {
        Config config = RecurrentStructuresNestedFieldsTest.smallInstanceConfig().setProperty(ClusterProperty.SQL_CUSTOM_CYCLIC_TYPES_ENABLED.getName(), "true");
        RecurrentStructuresNestedFieldsTest.initializeWithClient((int)2, (Config)config, null);
    }

    private static void createJavaMapping(String name, Class<?> valueClass, String ... valueFields) {
        BasicNestedFieldsTest.createJavaMapping(RecurrentStructuresNestedFieldsTest.client(), name, valueClass, valueFields);
    }

    private static void createType(String name, String ... fields) {
        ((SqlTestSupport.SqlType)new SqlTestSupport.SqlType(name).fields(fields)).create(RecurrentStructuresNestedFieldsTest.client());
    }

    @Test
    public void test_selfRefType() {
        RecurrentStructuresNestedFieldsTest.createType("SelfRefType", "id BIGINT", "name VARCHAR", "other SelfRefType");
        BasicNestedFieldsTest.SelfRef first = new BasicNestedFieldsTest.SelfRef(1L, "first");
        BasicNestedFieldsTest.SelfRef second = new BasicNestedFieldsTest.SelfRef(2L, "second");
        BasicNestedFieldsTest.SelfRef third = new BasicNestedFieldsTest.SelfRef(3L, "third");
        BasicNestedFieldsTest.SelfRef fourth = new BasicNestedFieldsTest.SelfRef(4L, "fourth");
        first.other = second;
        second.other = third;
        third.other = fourth;
        fourth.other = first;
        RecurrentStructuresNestedFieldsTest.createJavaMapping("test", BasicNestedFieldsTest.SelfRef.class, "this SelfRefType");
        RecurrentStructuresNestedFieldsTest.client().getMap("test").put((Object)1L, (Object)first);
        List<SqlTestSupport.Row> expectedRows = RecurrentStructuresNestedFieldsTest.rows(5, "first", "second", "third", "fourth", "first");
        RecurrentStructuresNestedFieldsTest.assertRowsAnyOrder(RecurrentStructuresNestedFieldsTest.client(), "SELECT test.this.name, test.this.other.name, test.this.other.other.name, test.this.other.other.other.name, test.this.other.other.other.other.name FROM test", expectedRows);
        RecurrentStructuresNestedFieldsTest.assertRowsAnyOrder(RecurrentStructuresNestedFieldsTest.instance(), "SELECT test.this.name, test.this.other.name, test.this.other.other.name, test.this.other.other.other.name, test.this.other.other.other.other.name FROM test", expectedRows);
    }

    @Test
    public void test_circularlyRecurrentTypes() {
        RecurrentStructuresNestedFieldsTest.createType("AType", "name VARCHAR", "b BType");
        RecurrentStructuresNestedFieldsTest.createType("BType", "name VARCHAR", "c CType");
        RecurrentStructuresNestedFieldsTest.createType("CType", "name VARCHAR", "a AType");
        BasicNestedFieldsTest.A a = new BasicNestedFieldsTest.A("a");
        BasicNestedFieldsTest.B b = new BasicNestedFieldsTest.B("b");
        BasicNestedFieldsTest.C c = new BasicNestedFieldsTest.C("c");
        a.b = b;
        b.c = c;
        c.a = a;
        RecurrentStructuresNestedFieldsTest.createJavaMapping("test", BasicNestedFieldsTest.A.class, "this AType");
        IMap map = RecurrentStructuresNestedFieldsTest.client().getMap("test");
        map.put((Object)1L, (Object)a);
        RecurrentStructuresNestedFieldsTest.assertRowsAnyOrder(RecurrentStructuresNestedFieldsTest.client(), "SELECT (this).b.c.a.name FROM test", RecurrentStructuresNestedFieldsTest.rows(1, "a"));
    }

    @Test
    public void test_cyclicTypeUpsertsValidationError() {
        RecurrentStructuresNestedFieldsTest.createType("FCA", "name VARCHAR", "b FCB", "c FCC");
        RecurrentStructuresNestedFieldsTest.createType("FCB", "name VARCHAR", "a FCA", "c FCC");
        RecurrentStructuresNestedFieldsTest.createType("FCC", "name VARCHAR", "a FCA", "b FCB");
        RecurrentStructuresNestedFieldsTest.createJavaMapping("tableA", FullyConnectedA.class, "this FCA");
        RecurrentStructuresNestedFieldsTest.createJavaMapping("tableB", FullyConnectedB.class, "this FCB");
        RecurrentStructuresNestedFieldsTest.createJavaMapping("tableC", FullyConnectedC.class, "this FCC");
        RecurrentStructuresNestedFieldsTest.createType("DualGraph", "name VARCHAR", "\"left\" DualGraph", "\"right\" DualGraph");
        RecurrentStructuresNestedFieldsTest.createJavaMapping("tableD", DualPathGraph.class, "this DualGraph");
        Consumer<String> assertNotSupported = sql -> Assertions.assertThatThrownBy(() -> RecurrentStructuresNestedFieldsTest.client().getSql().execute(sql, new Object[0])).hasMessageContaining("Upserts are not supported for cyclic data type columns");
        assertNotSupported.accept("INSERT INTO tableA VALUES (1, ?)");
        assertNotSupported.accept("INSERT INTO tableB VALUES (1, ?)");
        assertNotSupported.accept("INSERT INTO tableC VALUES (1, ?)");
        assertNotSupported.accept("INSERT INTO tableD VALUES (1, ?)");
        assertNotSupported.accept("UPDATE tableA SET this = ? WHERE __key = 1");
        assertNotSupported.accept("UPDATE tableB SET this = ? WHERE __key = 1");
        assertNotSupported.accept("UPDATE tableC SET this = ? WHERE __key = 1");
        assertNotSupported.accept("UPDATE tableD SET this = ? WHERE __key = 1");
    }

    @Test
    public void test_fullyConnectedGraph() {
        RecurrentStructuresNestedFieldsTest.createType("FCA", "name VARCHAR", "b FCB", "c FCC");
        RecurrentStructuresNestedFieldsTest.createType("FCB", "name VARCHAR", "a FCA", "c FCC");
        RecurrentStructuresNestedFieldsTest.createType("FCC", "name VARCHAR", "a FCA", "b FCB");
        FullyConnectedA a = new FullyConnectedA("A1");
        FullyConnectedB b = new FullyConnectedB("B1");
        FullyConnectedC c = new FullyConnectedC("C1");
        a.setB(b);
        a.setC(c);
        b.setA(a);
        b.setC(c);
        c.setA(a);
        c.setB(b);
        RecurrentStructuresNestedFieldsTest.createJavaMapping("tableA", FullyConnectedA.class, "this FCA");
        RecurrentStructuresNestedFieldsTest.createJavaMapping("tableB", FullyConnectedB.class, "this FCB");
        RecurrentStructuresNestedFieldsTest.createJavaMapping("tableC", FullyConnectedC.class, "this FCC");
        RecurrentStructuresNestedFieldsTest.client().getMap("tableA").put((Object)1L, (Object)a);
        RecurrentStructuresNestedFieldsTest.client().getMap("tableB").put((Object)1L, (Object)b);
        RecurrentStructuresNestedFieldsTest.client().getMap("tableC").put((Object)1L, (Object)c);
        RecurrentStructuresNestedFieldsTest.assertRowsAnyOrder(RecurrentStructuresNestedFieldsTest.client(), "SELECT (this).b.c.a.name, tableA.this.c.a.name FROM tableA", RecurrentStructuresNestedFieldsTest.rows(2, "A1", "A1"));
        RecurrentStructuresNestedFieldsTest.assertRowsAnyOrder(RecurrentStructuresNestedFieldsTest.client(), "SELECT (this).a.c.b.name, tableB.this.a.b.name FROM tableB", RecurrentStructuresNestedFieldsTest.rows(2, "B1", "B1"));
        RecurrentStructuresNestedFieldsTest.assertRowsAnyOrder(RecurrentStructuresNestedFieldsTest.client(), "SELECT (this).a.b.c.name, tableC.this.b.c.name FROM tableC", RecurrentStructuresNestedFieldsTest.rows(2, "C1", "C1"));
    }

    @Test
    public void test_sameTypesDifferentInstances() {
        RecurrentStructuresNestedFieldsTest.createType("FCA", "name VARCHAR", "b FCB", "c FCC");
        RecurrentStructuresNestedFieldsTest.createType("FCB", "name VARCHAR", "a FCA", "c FCC");
        RecurrentStructuresNestedFieldsTest.createType("FCC", "name VARCHAR", "a FCA", "b FCB");
        FullyConnectedA a1 = new FullyConnectedA("A1");
        FullyConnectedB b1 = new FullyConnectedB("B1");
        FullyConnectedC c1 = new FullyConnectedC("C1");
        FullyConnectedA a2 = new FullyConnectedA("A2");
        FullyConnectedB b2 = new FullyConnectedB("B2");
        FullyConnectedC c2 = new FullyConnectedC("C2");
        a1.setB(b1);
        b1.setC(c1);
        c1.setA(a2);
        a2.setB(b2);
        b2.setC(c2);
        c2.setA(a1);
        RecurrentStructuresNestedFieldsTest.createJavaMapping("test", FullyConnectedA.class, "this FCA");
        RecurrentStructuresNestedFieldsTest.client().getMap("test").put((Object)1L, (Object)a1);
        RecurrentStructuresNestedFieldsTest.assertRowsAnyOrder(RecurrentStructuresNestedFieldsTest.client(), "SELECT (this).name, (this).b.name, (this).b.c.name, (this).b.c.a.name, (this).b.c.a.b.name, (this).b.c.a.b.c.name, (this).b.c.a.b.c.a.name FROM test", RecurrentStructuresNestedFieldsTest.rows(7, "A1", "B1", "C1", "A2", "B2", "C2", "A1"));
    }

    @Test
    public void test_treeLikeCyclicGraph() {
        RecurrentStructuresNestedFieldsTest.createType("DualGraph", "name VARCHAR", "\"left\" DualGraph", "\"right\" DualGraph");
        DualPathGraph a1 = new DualPathGraph("A1");
        DualPathGraph a2 = new DualPathGraph("A2");
        DualPathGraph a3 = new DualPathGraph("A3");
        DualPathGraph a4 = new DualPathGraph("A4");
        DualPathGraph a5 = new DualPathGraph("A5");
        a1.setLeft(a2);
        a1.setRight(a3);
        a2.setLeft(a4);
        a2.setRight(a5);
        a4.setLeft(a1);
        a4.setRight(a4);
        a5.setRight(a3);
        RecurrentStructuresNestedFieldsTest.createJavaMapping("test", DualPathGraph.class, "this DualGraph");
        RecurrentStructuresNestedFieldsTest.client().getMap("test").put((Object)1L, (Object)a1);
        RecurrentStructuresNestedFieldsTest.assertRowsAnyOrder(RecurrentStructuresNestedFieldsTest.client(), "SELECT (this).name, (this).\"left\".name, (this).\"right\".name, (this).\"left\".\"left\".name, (this).\"left\".\"right\".name, (this).\"left\".\"left\".\"left\".name, (this).\"left\".\"left\".\"right\".name, (this).\"left\".\"left\".\"left\".\"right\".name  FROM test", RecurrentStructuresNestedFieldsTest.rows(8, "A1", "A2", "A3", "A4", "A5", "A1", "A4", "A3"));
    }

    public static class FullyConnectedA
    implements Serializable {
        private String name;
        private FullyConnectedB b;
        private FullyConnectedC c;

        public FullyConnectedA() {
        }

        public FullyConnectedA(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public FullyConnectedB getB() {
            return this.b;
        }

        public void setB(FullyConnectedB b) {
            this.b = b;
        }

        public FullyConnectedC getC() {
            return this.c;
        }

        public void setC(FullyConnectedC c) {
            this.c = c;
        }
    }

    public static class FullyConnectedB
    implements Serializable {
        private String name;
        private FullyConnectedA a;
        private FullyConnectedC c;

        public FullyConnectedB() {
        }

        public FullyConnectedB(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public FullyConnectedA getA() {
            return this.a;
        }

        public void setA(FullyConnectedA a) {
            this.a = a;
        }

        public FullyConnectedC getC() {
            return this.c;
        }

        public void setC(FullyConnectedC c) {
            this.c = c;
        }
    }

    public static class FullyConnectedC
    implements Serializable {
        private String name;
        private FullyConnectedA a;
        private FullyConnectedB b;

        public FullyConnectedC() {
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public FullyConnectedA getA() {
            return this.a;
        }

        public void setA(FullyConnectedA a) {
            this.a = a;
        }

        public FullyConnectedB getB() {
            return this.b;
        }

        public void setB(FullyConnectedB b) {
            this.b = b;
        }

        public FullyConnectedC(String name) {
            this.name = name;
        }
    }

    public static class DualPathGraph
    implements Serializable {
        private String name;
        private DualPathGraph left;
        private DualPathGraph right;

        public DualPathGraph() {
        }

        public DualPathGraph(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public DualPathGraph getLeft() {
            return this.left;
        }

        public void setLeft(DualPathGraph left) {
            this.left = left;
        }

        public DualPathGraph getRight() {
            return this.right;
        }

        public void setRight(DualPathGraph right) {
            this.right = right;
        }
    }
}

