/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.support.expressions;

import com.hazelcast.jet.sql.impl.support.expressions.ExpressionType;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ExpressionTypes {
    public static final ExpressionType<?> STRING = new ExpressionType.StringType();
    public static final ExpressionType<?> CHARACTER = new ExpressionType.CharacterType();
    public static final ExpressionType<?> BOOLEAN = new ExpressionType.BooleanType();
    public static final ExpressionType<?> BYTE = new ExpressionType.ByteType();
    public static final ExpressionType<?> SHORT = new ExpressionType.ShortType();
    public static final ExpressionType<?> INTEGER = new ExpressionType.IntegerType();
    public static final ExpressionType<?> LONG = new ExpressionType.LongType();
    public static final ExpressionType<?> BIG_DECIMAL = new ExpressionType.BigDecimalType();
    public static final ExpressionType<?> BIG_INTEGER = new ExpressionType.BigIntegerType();
    public static final ExpressionType<?> FLOAT = new ExpressionType.FloatType();
    public static final ExpressionType<?> DOUBLE = new ExpressionType.DoubleType();
    public static final ExpressionType<?> LOCAL_DATE = new ExpressionType.LocalDateType();
    public static final ExpressionType<?> LOCAL_TIME = new ExpressionType.LocalTimeType();
    public static final ExpressionType<?> LOCAL_DATE_TIME = new ExpressionType.LocalDateTimeType();
    public static final ExpressionType<?> OFFSET_DATE_TIME = new ExpressionType.OffsetDateTimeType();
    public static final ExpressionType<?> OBJECT = new ExpressionType.ObjectType();
    private static final Object MUX = new Object();
    private static volatile List<ExpressionType<?>> all;

    public static ExpressionType<?> resolve(Object value) {
        if (value instanceof String) {
            return STRING;
        }
        if (value instanceof Character) {
            return CHARACTER;
        }
        if (value instanceof Boolean) {
            return BOOLEAN;
        }
        if (value instanceof Byte) {
            return BYTE;
        }
        if (value instanceof Short) {
            return SHORT;
        }
        if (value instanceof Integer) {
            return INTEGER;
        }
        if (value instanceof Long) {
            return LONG;
        }
        if (value instanceof BigInteger) {
            return BIG_INTEGER;
        }
        if (value instanceof BigDecimal) {
            return BIG_DECIMAL;
        }
        if (value instanceof Float) {
            return FLOAT;
        }
        if (value instanceof Double) {
            return DOUBLE;
        }
        if (value instanceof LocalDate) {
            return LOCAL_DATE;
        }
        if (value instanceof LocalTime) {
            return LOCAL_TIME;
        }
        if (value instanceof LocalDateTime) {
            return LOCAL_DATE_TIME;
        }
        if (value instanceof OffsetDateTime) {
            return OFFSET_DATE_TIME;
        }
        return OBJECT;
    }

    public static ExpressionType<?>[] numeric() {
        return new ExpressionType[]{BYTE, SHORT, INTEGER, LONG, BIG_INTEGER, BIG_DECIMAL, FLOAT, DOUBLE};
    }

    public static ExpressionType<?>[] allExcept(ExpressionType<?> ... excludeTypes) {
        if (excludeTypes == null || excludeTypes.length == 0) {
            return ExpressionTypes.all();
        }
        ArrayList res = new ArrayList(Arrays.asList(ExpressionTypes.all()));
        for (ExpressionType<?> excludedType : excludeTypes) {
            res.remove(excludedType);
        }
        return res.toArray(new ExpressionType[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExpressionType<?>[] all() {
        List<ExpressionType<?>> res = all;
        if (res == null) {
            Object object = MUX;
            synchronized (object) {
                res = all;
                if (res == null) {
                    res = ExpressionTypes.all0();
                    all = res;
                }
            }
        }
        return res.toArray(new ExpressionType[0]);
    }

    private static List<ExpressionType<?>> all0() {
        try {
            ArrayList<ExpressionType> types = new ArrayList<ExpressionType>();
            for (Field field : ExpressionTypes.class.getDeclaredFields()) {
                if (!Modifier.isStatic(field.getModifiers()) || !field.getType().equals(ExpressionType.class)) continue;
                ExpressionType type = (ExpressionType)field.get(null);
                types.add(type);
            }
            return Collections.unmodifiableList(types);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Failed to initialize " + String.valueOf(ExpressionTypes.class) + ".all()", e);
        }
    }

    private ExpressionTypes() {
    }
}

