/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.jet.sql.impl.connector.SqlConnector;
import com.hazelcast.jet.sql.impl.connector.SqlConnectorCache;
import com.hazelcast.jet.sql.impl.schema.RelationsStorage;
import com.hazelcast.jet.sql.impl.schema.TableResolverImpl;
import com.hazelcast.mock.MockUtil;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.schema.Mapping;
import com.hazelcast.sql.impl.schema.MappingField;
import com.hazelcast.sql.impl.schema.TableResolver;
import com.hazelcast.sql.impl.schema.view.View;
import com.hazelcast.sql.impl.type.QueryDataType;
import com.hazelcast.test.HazelcastParallelClassRunner;
import com.hazelcast.test.annotation.ParallelJVMTest;
import com.hazelcast.test.annotation.QuickTest;
import java.util.Arrays;
import java.util.Collections;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentMatchers;
import org.mockito.BDDMockito;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

@RunWith(value=HazelcastParallelClassRunner.class)
@Category(value={QuickTest.class, ParallelJVMTest.class})
public class TableResolverImplTest {
    private TableResolverImpl catalog;
    @Mock
    private NodeEngine nodeEngine;
    @Mock
    private RelationsStorage relationsStorage;
    @Mock
    private SqlConnectorCache connectorCache;
    @Mock
    private SqlConnector connector;
    @Mock
    private TableResolver.TableListener listener;
    @Mock
    private HazelcastInstance hazelcastInstance;
    @Mock
    private LifecycleService lifecycleService;
    private AutoCloseable openMocks;

    @Before
    public void before() {
        this.openMocks = MockitoAnnotations.openMocks((Object)this);
        Mockito.when((Object)this.nodeEngine.getHazelcastInstance()).thenReturn((Object)this.hazelcastInstance);
        Mockito.when((Object)this.hazelcastInstance.getLifecycleService()).thenReturn((Object)this.lifecycleService);
        this.catalog = new TableResolverImpl(this.nodeEngine, this.relationsStorage, this.connectorCache);
        this.catalog.registerListener(this.listener);
    }

    @After
    public void cleanUp() {
        MockUtil.closeMocks((AutoCloseable)this.openMocks);
    }

    @Test
    public void when_createsInvalidMapping_then_throws() {
        Mapping mapping = TableResolverImplTest.mapping();
        BDDMockito.given((Object)this.connectorCache.forType(mapping.connectorType())).willReturn((Object)this.connector);
        BDDMockito.given((Object)this.connector.typeName()).willReturn((Object)mapping.connectorType());
        BDDMockito.given((Object)this.connector.defaultObjectType()).willReturn((Object)"Dummy");
        BDDMockito.given((Object)this.connector.resolveAndValidateFields(this.nodeEngine, new SqlConnector.SqlExternalResource(mapping.externalName(), mapping.dataConnection(), mapping.connectorType(), "Dummy", mapping.options()), mapping.fields())).willThrow(new Throwable[]{new RuntimeException("expected test exception")});
        Assertions.assertThatThrownBy(() -> this.catalog.createMapping(mapping, true, true, null)).hasMessageContaining("expected test exception");
        ((RelationsStorage)Mockito.verify((Object)this.relationsStorage, (VerificationMode)Mockito.never())).putIfAbsent(ArgumentMatchers.anyString(), (Mapping)ArgumentMatchers.any());
        ((RelationsStorage)Mockito.verify((Object)this.relationsStorage, (VerificationMode)Mockito.never())).put(ArgumentMatchers.anyString(), (Mapping)ArgumentMatchers.any());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void when_createsDuplicateMapping_then_throws() {
        Mapping mapping = TableResolverImplTest.mapping();
        BDDMockito.given((Object)this.connectorCache.forType(mapping.connectorType())).willReturn((Object)this.connector);
        BDDMockito.given((Object)this.connector.resolveAndValidateFields(this.nodeEngine, new SqlConnector.SqlExternalResource(mapping.externalName(), mapping.dataConnection(), "Dummy", null, mapping.options()), mapping.fields())).willReturn(Collections.singletonList(new MappingField("field_name", QueryDataType.INT)));
        BDDMockito.given((Object)this.connector.typeName()).willReturn((Object)"Dummy");
        BDDMockito.given((Object)this.connector.defaultObjectType()).willReturn((Object)"Dummy");
        BDDMockito.given((Object)this.relationsStorage.putIfAbsent((String)ArgumentMatchers.eq((Object)mapping.name()), (Mapping)ArgumentMatchers.isA(Mapping.class))).willReturn((Object)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.createMapping(mapping, false, false, null)).isInstanceOf(QueryException.class)).hasMessageContaining("Mapping or view already exists: name");
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void when_createsDuplicateMappingWithIfNotExists_then_succeeds() {
        Mapping mapping = TableResolverImplTest.mapping();
        BDDMockito.given((Object)this.connectorCache.forType(mapping.connectorType())).willReturn((Object)this.connector);
        BDDMockito.given((Object)this.connector.typeName()).willReturn((Object)mapping.connectorType());
        BDDMockito.given((Object)this.connector.defaultObjectType()).willReturn((Object)"Dummy");
        BDDMockito.given((Object)this.connector.resolveAndValidateFields(this.nodeEngine, new SqlConnector.SqlExternalResource(mapping.externalName(), mapping.dataConnection(), mapping.connectorType(), null, mapping.options()), mapping.fields())).willReturn(Collections.singletonList(new MappingField("field_name", QueryDataType.INT)));
        BDDMockito.given((Object)this.relationsStorage.putIfAbsent((String)ArgumentMatchers.eq((Object)mapping.name()), (Mapping)ArgumentMatchers.isA(Mapping.class))).willReturn((Object)false);
        this.catalog.createMapping(mapping, false, true, null);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void when_replacesMapping_then_succeeds() {
        Mapping mapping = TableResolverImplTest.mapping();
        BDDMockito.given((Object)this.connectorCache.forType(mapping.connectorType())).willReturn((Object)this.connector);
        BDDMockito.given((Object)this.connector.typeName()).willReturn((Object)mapping.connectorType());
        BDDMockito.given((Object)this.connector.defaultObjectType()).willReturn((Object)"Dummy");
        BDDMockito.given((Object)this.connector.resolveAndValidateFields(this.nodeEngine, new SqlConnector.SqlExternalResource(mapping.externalName(), mapping.dataConnection(), mapping.connectorType(), null, mapping.options()), mapping.fields())).willReturn(Collections.singletonList(new MappingField("field_name", QueryDataType.INT)));
        this.catalog.createMapping(mapping, true, false, null);
        ((RelationsStorage)Mockito.verify((Object)this.relationsStorage)).put((String)ArgumentMatchers.eq((Object)mapping.name()), (Mapping)ArgumentMatchers.isA(Mapping.class));
        ((TableResolver.TableListener)Mockito.verify((Object)this.listener)).onTableChanged();
    }

    @Test
    public void when_mappingWithNoObjectType_then_usesDefault() {
        Mapping mapping = TableResolverImplTest.mapping();
        BDDMockito.given((Object)this.connectorCache.forType(mapping.connectorType())).willReturn((Object)this.connector);
        BDDMockito.given((Object)this.connector.resolveAndValidateFields(this.nodeEngine, new SqlConnector.SqlExternalResource(mapping.externalName(), mapping.dataConnection(), mapping.connectorType(), "MyDummyType", mapping.options()), mapping.fields())).willReturn(Collections.singletonList(new MappingField("field_name", QueryDataType.INT)));
        BDDMockito.given((Object)this.connector.resolveAndValidateFields(this.nodeEngine, new SqlConnector.SqlExternalResource(mapping.externalName(), mapping.dataConnection(), mapping.connectorType(), null, mapping.options()), mapping.fields())).willThrow(new Throwable[]{new AssertionError((Object)"Object type must not be null")});
        BDDMockito.given((Object)this.connector.typeName()).willReturn((Object)mapping.connectorType());
        BDDMockito.given((Object)this.connector.defaultObjectType()).willReturn((Object)"MyDummyType");
        this.catalog.createMapping(mapping, true, false, null);
        ((RelationsStorage)Mockito.verify((Object)this.relationsStorage)).put((String)ArgumentMatchers.eq((Object)mapping.name()), (Mapping)ArgumentMatchers.isA(Mapping.class));
        ((TableResolver.TableListener)Mockito.verify((Object)this.listener)).onTableChanged();
    }

    @Test
    public void when_removesExistingMapping_then_callsListeners() {
        String name = "name";
        BDDMockito.given((Object)this.relationsStorage.removeMapping(name)).willReturn((Object)TableResolverImplTest.mapping());
        this.catalog.removeMapping(name, false);
        ((TableResolver.TableListener)Mockito.verify((Object)this.listener)).onTableChanged();
    }

    @Test
    public void when_removesNonExistingMapping_then_throws() {
        String name = "name";
        BDDMockito.given((Object)this.relationsStorage.removeMapping(name)).willReturn(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.removeMapping(name, false)).isInstanceOf(QueryException.class)).hasMessageContaining("Mapping does not exist: name");
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void when_removesNonExistingMappingWithIfExists_then_succeeds() {
        String name = "name";
        BDDMockito.given((Object)this.relationsStorage.removeMapping(name)).willReturn(null);
        this.catalog.removeMapping(name, true);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void when_createsView_then_succeeds() {
        View view = TableResolverImplTest.view();
        BDDMockito.given((Object)this.relationsStorage.putIfAbsent(view.name(), view)).willReturn((Object)true);
        this.catalog.createView(view, false, false);
        ((RelationsStorage)Mockito.verify((Object)this.relationsStorage)).putIfAbsent((String)ArgumentMatchers.eq((Object)view.name()), (View)ArgumentMatchers.isA(View.class));
    }

    @Test
    public void when_createsViewIfNotExists_then_succeeds() {
        View view = TableResolverImplTest.view();
        BDDMockito.given((Object)this.relationsStorage.putIfAbsent(view.name(), view)).willReturn((Object)true);
        this.catalog.createView(view, false, true);
        ((RelationsStorage)Mockito.verify((Object)this.relationsStorage)).putIfAbsent((String)ArgumentMatchers.eq((Object)view.name()), (View)ArgumentMatchers.isA(View.class));
    }

    @Test
    public void when_createsDuplicateViewsIfReplace_then_succeeds() {
        View view = TableResolverImplTest.view();
        this.catalog.createView(view, true, false);
        ((RelationsStorage)Mockito.verify((Object)this.relationsStorage)).put((String)ArgumentMatchers.eq((Object)view.name()), (View)ArgumentMatchers.isA(View.class));
    }

    @Test
    public void when_createsDuplicateViewsIfReplaceAndIfNotExists_then_succeeds() {
        View view = TableResolverImplTest.view();
        this.catalog.createView(view, true, true);
        ((RelationsStorage)Mockito.verify((Object)this.relationsStorage)).putIfAbsent((String)ArgumentMatchers.eq((Object)view.name()), (View)ArgumentMatchers.isA(View.class));
    }

    @Test
    public void when_createsDuplicateViews_then_throws() {
        View view = TableResolverImplTest.view();
        BDDMockito.given((Object)this.relationsStorage.putIfAbsent((String)ArgumentMatchers.eq((Object)view.name()), (View)ArgumentMatchers.isA(View.class))).willReturn((Object)false);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.createView(view, false, false)).isInstanceOf(QueryException.class)).hasMessageContaining("Mapping or view already exists: name");
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void when_removesNonExistingView_then_throws() {
        String name = "name";
        BDDMockito.given((Object)this.relationsStorage.removeView(name)).willReturn(null);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.catalog.removeView(name, false)).isInstanceOf(QueryException.class)).hasMessageContaining("View does not exist: name");
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
    }

    @Test
    public void when_removesNonExistingViewWithIfExists_then_succeeds() {
        String name = "name";
        BDDMockito.given((Object)this.relationsStorage.removeView(name)).willReturn(null);
        this.catalog.removeView(name, true);
        Mockito.verifyNoInteractions((Object[])new Object[]{this.listener});
    }

    private static Mapping mapping() {
        return new Mapping("name", "external_name", null, "type", null, Collections.emptyList(), Collections.emptyMap());
    }

    private static View view() {
        return new View("name", "SELECT * FROM map", Collections.singletonList("*"), Arrays.asList(QueryDataType.OBJECT, QueryDataType.OBJECT));
    }
}

