/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.jet.sql.impl.schema;

import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.function.ConsumerEx;
import com.hazelcast.jet.sql.SqlTestSupport;
import com.hazelcast.jet.sql.impl.schema.RelationsStorage;
import com.hazelcast.jet.sql.impl.schema.model.Person;
import com.hazelcast.map.IMap;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.sql.HazelcastSqlException;
import com.hazelcast.sql.SqlResult;
import com.hazelcast.sql.SqlService;
import com.hazelcast.test.Accessors;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.Consumer;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class SqlMappingTest
extends SqlTestSupport {
    private static SqlService sqlService;

    @BeforeClass
    public static void setUpClass() {
        SqlMappingTest.initializeWithClient((int)1, null, null);
        sqlService = SqlMappingTest.instance().getSql();
    }

    @Test
    public void when_mappingIsNotCreated_then_itIsNotAvailable() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlMappingTest.client().getSql().execute("SELECT * FROM map", new Object[0]).forEach((Consumer)ConsumerEx.noop())).isInstanceOf(HazelcastSqlException.class)).hasFieldOrPropertyWithValue("code", (Object)1010)).hasFieldOrPropertyWithValue("suggestion", null)).hasMessageContaining("Object 'map' not found, did you forget to CREATE MAPPING?");
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlMappingTest.client().getSql().execute("SELECT * FROM public.map", new Object[0]).forEach((Consumer)ConsumerEx.noop())).isInstanceOf(HazelcastSqlException.class)).hasFieldOrPropertyWithValue("code", (Object)1010)).hasFieldOrPropertyWithValue("suggestion", null)).hasMessageContaining("Object 'map' not found within 'hazelcast.public', did you forget to CREATE MAPPING?");
        ((AbstractThrowableAssert)((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlMappingTest.client().getSql().execute("SELECT * FROM hazelcast.public.map", new Object[0]).forEach((Consumer)ConsumerEx.noop())).isInstanceOf(HazelcastSqlException.class)).hasFieldOrPropertyWithValue("code", (Object)1010)).hasFieldOrPropertyWithValue("suggestion", null)).hasMessageContaining("Object 'map' not found within 'hazelcast.public', did you forget to CREATE MAPPING?");
    }

    @Test
    public void when_mapExistsButMappingIsNotCreated_then_suggestDdl() {
        IMap map = SqlMappingTest.instance().getMap("map");
        map.put((Object)1, (Object)1);
        String expectedDdl = "Object 'map' not found%s, did you forget to CREATE MAPPING? If you want to use the IMap named 'map', execute this command first: CREATE OR REPLACE EXTERNAL MAPPING \"hazelcast\".\"public\".\"map\" EXTERNAL NAME \"map\"\nTYPE \"IMap\"\nOPTIONS (\n  'keyFormat'='java',\n  'keyJavaClass'='java.lang.Integer',\n  'valueFormat'='java',\n  'valueJavaClass'='java.lang.Integer'\n)";
        String message = ((HazelcastSqlException)SqlMappingTest.assertThrows(HazelcastSqlException.class, () -> SqlMappingTest.client().getSql().execute("SELECT * FROM map", new Object[0]))).getMessage();
        Assertions.assertThat((String)message).isEqualToNormalizingNewlines((CharSequence)String.format(expectedDdl, ""));
        message = ((HazelcastSqlException)SqlMappingTest.assertThrows(HazelcastSqlException.class, () -> SqlMappingTest.client().getSql().execute("SELECT * FROM public.map", new Object[0]))).getMessage();
        Assertions.assertThat((String)message).isEqualToNormalizingNewlines((CharSequence)String.format(expectedDdl, " within 'hazelcast.public'"));
        message = ((HazelcastSqlException)SqlMappingTest.assertThrows(HazelcastSqlException.class, () -> SqlMappingTest.client().getSql().execute("SELECT * FROM hazelcast.public.map", new Object[0]))).getMessage();
        Assertions.assertThat((String)message).isEqualToNormalizingNewlines((CharSequence)String.format(expectedDdl, " within 'hazelcast.public'"));
    }

    @Test
    public void when_mappingIsNotCreatedButIMapExists_then_suggestionIsProvided() {
        try {
            SqlMappingTest.instance().getMap("map1").put((Object)1, (Object)"value-1");
            SqlMappingTest.client().getSql().execute("SELECT * FROM map1", new Object[0]).forEach((Consumer)ConsumerEx.noop());
            Assert.fail();
        }
        catch (HazelcastSqlException e) {
            SqlMappingTest.client().getSql().execute(e.getSuggestion(), new Object[0]);
            SqlMappingTest.assertRowsAnyOrder("SELECT * FROM map1", Collections.singletonList(new SqlTestSupport.Row(1, "value-1")));
        }
        try {
            SqlMappingTest.instance().getMap("map2").put((Object)2, (Object)"value-2");
            SqlMappingTest.client().getSql().execute("SELECT * FROM public.map2", new Object[0]).forEach((Consumer)ConsumerEx.noop());
            Assert.fail();
        }
        catch (HazelcastSqlException e) {
            SqlMappingTest.client().getSql().execute(e.getSuggestion(), new Object[0]);
            SqlMappingTest.assertRowsAnyOrder("SELECT * FROM public.map2", Collections.singletonList(new SqlTestSupport.Row(2, "value-2")));
        }
        try {
            SqlMappingTest.instance().getMap("map3").put((Object)3, (Object)"value-3");
            SqlMappingTest.client().getSql().execute("SELECT * FROM hazelcast.public.map3", new Object[0]).forEach((Consumer)ConsumerEx.noop());
            Assert.fail();
        }
        catch (HazelcastSqlException e) {
            SqlMappingTest.client().getSql().execute(e.getSuggestion(), new Object[0]);
            SqlMappingTest.assertRowsAnyOrder("SELECT * FROM hazelcast.public.map3", Collections.singletonList(new SqlTestSupport.Row(3, "value-3")));
        }
    }

    @Test
    public void when_mappingIsDeclared_then_itIsAvailable() {
        String name = SqlMappingTest.randomName();
        SqlMappingTest.createMapping(name, Integer.class, String.class);
        SqlResult queryResult = sqlService.execute("SELECT __key, this FROM public." + name, new Object[0]);
        Assertions.assertThat((long)queryResult.updateCount()).isEqualTo(-1L);
        Assertions.assertThat((Iterator)queryResult.iterator()).isExhausted();
    }

    @Test
    public void when_mappingIsDropped_then_itIsNotAvailable() {
        String name = SqlMappingTest.randomName();
        SqlMappingTest.createMapping(name, Integer.class, Person.class);
        SqlResult dropResult = sqlService.execute("DROP MAPPING " + name, new Object[0]);
        Assertions.assertThat((long)dropResult.updateCount()).isEqualTo(0L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("SELECT * FROM public." + name, new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Object '" + name + "' not found within 'hazelcast.public'");
    }

    @Test
    public void when_orReplaceAndIfNotExistsUsedTogether_then_fail() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE OR REPLACE MAPPING IF NOT EXISTS t TYPE TestBatch", new Object[0])).hasMessageContaining("OR REPLACE in conjunction with IF NOT EXISTS not supported");
    }

    @Test
    public void when_duplicateColumn_then_fail() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING t (a INT, a BIGINT) TYPE TestBatch", new Object[0])).hasMessageContaining("Column 'a' specified more than once");
    }

    @Test
    public void when_emptyColumnList_then_fail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("create mapping t () type TestBatch", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageStartingWith("Encountered \")\" at line 1, column 19.");
    }

    @Test
    public void when_badType_then_fail() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING m TYPE TooBad", new Object[0])).hasMessageContaining("Unknown connector type: TooBad");
    }

    @Test
    public void when_dataConnectionDoesNotExist_then_fail() {
        String dlName = SqlMappingTest.randomName();
        String mappingName = SqlMappingTest.randomName();
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> SqlMappingTest.instance().getSql().execute("CREATE OR REPLACE MAPPING " + mappingName + " DATA CONNECTION " + dlName + "\nOPTIONS ()", new Object[0])).isInstanceOf(HazelcastSqlException.class)).hasMessageContaining("Data connection '" + dlName + "' not found");
    }

    @Test
    public void test_alias_int_integer() {
        this.test_alias(Integer.class.getName(), "int", "integer");
    }

    @Test
    public void test_alias_double_doublePrecision() {
        this.test_alias(Double.class.getName(), "double", "double precision");
    }

    @Test
    public void test_alias_dec_decimal_numeric() {
        this.test_alias(BigDecimal.class.getName(), "dec", "decimal", "numeric");
    }

    @Test
    public void test_alias_varchar_charVarying_characterVarying() {
        this.test_alias(String.class.getName(), "varchar", "char varying", "character varying");
    }

    private void test_alias(String javaClassName, String ... aliases) {
        for (String alias : aliases) {
            sqlService.execute("CREATE MAPPING \"m_" + alias + "\"(__key " + alias + ") TYPE IMap OPTIONS('keyFormat'='java', 'keyJavaClass'='" + javaClassName + "', 'valueFormat'='json-flat')", new Object[0]);
        }
        RelationsStorage relationsStorage = new RelationsStorage((NodeEngine)Accessors.getNodeEngineImpl((HazelcastInstance)SqlMappingTest.instance()));
        Assert.assertEquals((long)aliases.length, (long)relationsStorage.allObjects().size());
        Iterator iterator = relationsStorage.allObjects().iterator();
        Object firstMapping = iterator.next();
        while (iterator.hasNext()) {
            Assertions.assertThat(iterator.next()).isEqualToIgnoringGivenFields(firstMapping, new String[]{"name", "externalName"});
        }
    }

    @Test
    public void test_caseInsensitiveType() {
        sqlService.execute("CREATE MAPPING t1 TYPE AllTypes", new Object[0]);
        sqlService.execute("CREATE MAPPING t2 TYPE alltypes", new Object[0]);
        sqlService.execute("CREATE MAPPING t3 TYPE ALLTYPES", new Object[0]);
        sqlService.execute("CREATE MAPPING t4 TYPE aLlTyPeS", new Object[0]);
    }

    @Test
    public void when_duplicateOption_then_fail() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING t TYPE TestBatch OPTIONS('o'='1', 'o'='2')", new Object[0])).hasMessageContaining("Option 'o' specified more than once");
    }

    @Test
    public void test_createDropMappingUsingSchema_public() {
        this.test_createDropMappingUsingSchema("public");
    }

    @Test
    public void test_createDropMappingUsingSchema_hazelcastPublic() {
        this.test_createDropMappingUsingSchema("hazelcast.public");
    }

    private void test_createDropMappingUsingSchema(String schemaName) {
        String name = SqlMappingTest.randomName();
        SqlMappingTest.createMapping(schemaName + "." + name, Integer.class, Integer.class);
        sqlService.execute("sink into " + name + " values(1, 1)", new Object[0]);
        sqlService.execute("sink into public." + name + " values(2, 2)", new Object[0]);
        sqlService.execute("sink into hazelcast.public." + name + " values(3, 3)", new Object[0]);
        List<SqlTestSupport.Row> expectedRows = Arrays.asList(new SqlTestSupport.Row(1, 1), new SqlTestSupport.Row(2, 2), new SqlTestSupport.Row(3, 3));
        SqlMappingTest.assertRowsAnyOrder("select * from " + name, expectedRows);
        SqlMappingTest.assertRowsAnyOrder("select * from public." + name, expectedRows);
        SqlMappingTest.assertRowsAnyOrder("select * from hazelcast.public." + name, expectedRows);
        sqlService.execute("drop mapping " + schemaName + "." + name, new Object[0]);
    }

    @Test
    public void when_createMappingInWrongSchema_then_fail() {
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING badSchema.mapping TYPE TestBatch", new Object[0])).hasMessage("From line 1, column 16 to line 1, column 32: The mapping must be created in the \"public\" schema");
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING badSchema.public.mapping TYPE TestBatch", new Object[0])).hasMessage("From line 1, column 16 to line 1, column 39: The mapping must be created in the \"public\" schema");
        Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING hazelcast.badSchema.mapping TYPE TestBatch", new Object[0])).hasMessage("From line 1, column 16 to line 1, column 42: The mapping must be created in the \"public\" schema");
    }

    @Test
    public void when_createMappingWithParameters_then_fail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("CREATE MAPPING m TYPE TestBatch", new Object[]{"param"})).isInstanceOf(HazelcastSqlException.class)).hasMessage("CREATE MAPPING does not support dynamic parameters");
    }

    @Test
    public void when_dropMappingWithParameters_then_fail() {
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> sqlService.execute("DROP MAPPING m", new Object[]{"param"})).isInstanceOf(HazelcastSqlException.class)).hasMessage("DROP MAPPING does not support dynamic parameters");
    }
}

